/*
 * Decompiled with CFR 0.152.
 */
package cz.sokoban4j.tournament;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.StringParser;
import cz.sokoban4j.tournament.SokobanSummary;
import java.io.File;

public class SokobanSummaryConsole {
    private static final char ARG_RUN_RESULTS_SHORT = 'r';
    private static final String ARG_RUN_RESULTS_LONG = "run-results-file";
    private static final char ARG_OUTPUT_TO_SHORT = 'o';
    private static final String ARG_OUTPUT_TO_LONG = "output-to-file";
    private static JSAP jsap;
    private static String runResultsFileString;
    private static File runResultsFile;
    private static String outputToFileString;
    private static File outputToFile;
    private static JSAPResult config;
    private static boolean headerOutput;

    static {
        runResultsFileString = null;
        headerOutput = false;
    }

    private static void fail(String errorMessage) {
        SokobanSummaryConsole.fail(errorMessage, null);
    }

    private static void fail(String errorMessage, Throwable e) {
        SokobanSummaryConsole.header();
        System.out.println("ERROR: " + errorMessage);
        System.out.println();
        if (e != null) {
            e.printStackTrace();
            System.out.println("");
        }
        System.out.println("Usage: java -jar sokoban-summary.jar ");
        System.out.println("                " + jsap.getUsage());
        System.out.println();
        System.out.println(jsap.getHelp());
        System.out.println();
        throw new RuntimeException("FAILURE: " + errorMessage);
    }

    private static void header() {
        if (headerOutput) {
            return;
        }
        System.out.println();
        System.out.println("=======================");
        System.out.println("Sokoban Summary Console");
        System.out.println("=======================");
        System.out.println();
        headerOutput = true;
    }

    private static void initJSAP() throws JSAPException {
        jsap = new JSAP();
        FlaggedOption opt11 = new FlaggedOption(ARG_OUTPUT_TO_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(false).setDefault("./results/results-summary.csv").setShortFlag('o').setLongFlag(ARG_OUTPUT_TO_LONG);
        opt11.setHelp("File where to output the summary; if existing, will be overwritten.");
        jsap.registerParameter((Parameter)opt11);
        FlaggedOption opt31 = new FlaggedOption(ARG_RUN_RESULTS_LONG).setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(true).setShortFlag('r').setLongFlag(ARG_RUN_RESULTS_LONG);
        opt31.setHelp("File with respective run results as produced by SokobanTournamentConsole.");
        jsap.registerParameter((Parameter)opt31);
    }

    /*
     * Unable to fully structure code
     */
    private static void readConfig(String[] args) {
        block3: {
            block4: {
                System.out.println("Parsing command arguments.");
                try {
                    SokobanSummaryConsole.config = SokobanSummaryConsole.jsap.parse(args);
                }
                catch (Exception e) {
                    SokobanSummaryConsole.fail(e.getMessage());
                    System.out.println("");
                    e.printStackTrace();
                    throw new RuntimeException("FAILURE!");
                }
                if (SokobanSummaryConsole.config.success()) break block3;
                error = "Invalid arguments specified.";
                errorIter = SokobanSummaryConsole.config.getErrorMessageIterator();
                if (errorIter.hasNext()) ** GOTO lbl17
                error = String.valueOf(error) + "\n-- No details given.";
                break block4;
lbl-1000:
                // 1 sources

                {
                    error = String.valueOf(error) + "\n-- " + errorIter.next();
lbl17:
                    // 2 sources

                    ** while (errorIter.hasNext())
                }
            }
            SokobanSummaryConsole.fail(error);
        }
        SokobanSummaryConsole.runResultsFileString = SokobanSummaryConsole.config.getString("run-results-file");
        SokobanSummaryConsole.outputToFileString = SokobanSummaryConsole.config.getString("output-to-file");
    }

    private static void sanityChecks() {
        System.out.println("Sanity checks...");
        runResultsFile = new File(runResultsFileString);
        System.out.println("-- run results file to read: " + runResultsFileString + " --> " + runResultsFile.getAbsolutePath());
        if (!runResultsFile.exists()) {
            SokobanSummaryConsole.fail("Results file does not exist!");
        } else if (!runResultsFile.isFile()) {
            SokobanSummaryConsole.fail("Resuts file is not a file!");
        }
        outputToFile = new File(outputToFileString);
        System.out.println("-- output to file: " + outputToFileString + " --> " + outputToFile.getAbsolutePath());
        if (!outputToFile.exists()) {
            System.out.println("---- output file does not exist, will be created");
        } else if (!outputToFile.isFile()) {
            SokobanSummaryConsole.fail("Output file is not a file!");
        } else {
            System.out.println("---- output file exists, will be overwritten");
        }
        if (!outputToFile.getParentFile().exists()) {
            System.out.println("---- creating parent directories for " + outputToFile.getAbsolutePath());
            outputToFile.getParentFile().mkdirs();
            if (!outputToFile.getParentFile().exists()) {
                SokobanSummaryConsole.fail("Failed to create parent directories for " + outputToFile.getAbsolutePath());
            }
        }
        System.out.println("Sanity checks OK!");
    }

    private static void run() {
        System.out.println("================");
        System.out.println("Running SUMMARY!");
        System.out.println("================");
        SokobanSummary summary = new SokobanSummary(runResultsFile);
        summary.summarize(outputToFile);
    }

    public static String[] getTestArgs() {
        return new String[]{"-r", "./results/results.csv", "-o", "./results/results-summary.csv"};
    }

    public static void main(String[] args) throws JSAPException {
        try {
            SokobanSummaryConsole.initJSAP();
            SokobanSummaryConsole.header();
            SokobanSummaryConsole.readConfig(args);
            SokobanSummaryConsole.sanityChecks();
            SokobanSummaryConsole.run();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("---// SUMMARY FINISHED //---");
        System.exit(0);
    }
}

