/*
 * Decompiled with CFR 0.152.
 */
package cz.sokoban4j.tournament;

import cz.cuni.amis.utils.maps.LazyMap;
import cz.sokoban4j.simulation.SokobanResult;
import cz.sokoban4j.tournament.utils.CSV;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;

public class SokobanSummary {
    private File file;
    private Map<String, AgentSummary> agents = new LazyMap<String, AgentSummary>(){

        protected AgentSummary create(String key) {
            return new AgentSummary(key);
        }
    };

    public SokobanSummary(File file) {
        this.file = file;
    }

    public void summarize(File outputTo) {
        try {
            CSV csv = new CSV(this.file, ";", true);
            for (CSV.CSVRow row : csv.rows) {
                if (!row.getString("result").toLowerCase().equals(SokobanResult.SokobanResultType.VICTORY.name().toLowerCase())) continue;
                AgentSummary agent = this.agents.get(row.getString("id"));
                SolvedLevel level = agent.solved.get(String.valueOf(row.getString("levelFile")) + " / " + row.getString("levelNumber"));
                level.solutionSteps = row.getInt("steps");
                level.solutionTimeMillis = row.getInt("playTimeMillis").intValue();
            }
            this.output(outputTo);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to read CSV from: " + this.file.getAbsolutePath());
        }
    }

    private void output(File resultFile) {
        System.out.println("Outputting summary into: " + resultFile.getAbsolutePath());
        FileOutputStream output = null;
        boolean header = !resultFile.exists();
        try {
            output = new FileOutputStream(resultFile, false);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Failed to open file: " + resultFile.getAbsolutePath(), e);
        }
        try {
            PrintWriter writer = new PrintWriter(output);
            if (header) {
                writer.println("id;levelsSolved;totalSteps;totalSolutionTimeMillis");
            }
            ArrayList<AgentSummary> agentList = new ArrayList<AgentSummary>(this.agents.values());
            Collections.sort(agentList, new Comparator<AgentSummary>(){

                @Override
                public int compare(AgentSummary o1, AgentSummary o2) {
                    return o2.solved.size() - o1.solved.size();
                }
            });
            for (AgentSummary summary : agentList) {
                writer.println(String.valueOf(summary.id) + ";" + summary.solved.size() + ";" + summary.getTotalSteps() + ";" + summary.getTotalTimeMillis());
            }
            writer.flush();
            writer.close();
        }
        finally {
            try {
                output.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static class AgentSummary {
        public String id;
        public Map<String, SolvedLevel> solved = new LazyMap<String, SolvedLevel>(){

            protected SolvedLevel create(String key) {
                return new SolvedLevel(key);
            }
        };

        public AgentSummary(String key) {
            this.id = key;
        }

        public double getTotalTimeMillis() {
            double result = 0.0;
            for (SolvedLevel solvedLevel : this.solved.values()) {
                result += solvedLevel.solutionTimeMillis;
            }
            return result;
        }

        public int getTotalSteps() {
            int result = 0;
            for (SolvedLevel solvedLevel : this.solved.values()) {
                result += solvedLevel.solutionSteps;
            }
            return result;
        }
    }

    public static class SolvedLevel {
        public String id;
        public double solutionTimeMillis;
        public int solutionSteps;

        public SolvedLevel(String key) {
            this.id = key;
        }
    }
}

