/*
 * Decompiled with CFR 0.152.
 */
package cz.sokoban4j.agents;

import cz.sokoban4j.Sokoban;
import cz.sokoban4j.agents.ArtificialAgent;
import cz.sokoban4j.simulation.SokobanResult;
import cz.sokoban4j.simulation.actions.EDirection;
import cz.sokoban4j.simulation.actions.compact.CAction;
import cz.sokoban4j.simulation.actions.compact.CMove;
import cz.sokoban4j.simulation.actions.compact.CPush;
import cz.sokoban4j.simulation.agent.IAgent;
import cz.sokoban4j.simulation.board.compact.BoardCompact;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class MTDFS1Agent
extends ArtificialAgent {
    protected BoardCompact board;
    protected Object solutionFoundMutex = new Object();
    protected boolean solutionFound = false;
    protected AtomicInteger searchedNodes = new AtomicInteger();

    protected List<EDirection> think(BoardCompact board) {
        this.board = board;
        this.solutionFound = false;
        this.searchedNodes.set(0);
        int spareThreads = 8;
        int searchLevel = 15;
        System.out.println("=================");
        System.out.println("===== BOARD =====");
        this.board.debugPrint();
        System.out.println("=================");
        long searchStartMillis = System.currentTimeMillis();
        DFS1Thread rootThread = new DFS1Thread(board, searchLevel, spareThreads - 1);
        rootThread.start();
        try {
            rootThread.join();
        }
        catch (InterruptedException e) {
            throw new RuntimeException("Interrupted on rootThread.join()", e);
        }
        List<EDirection> result = rootThread.solutionFound ? rootThread.result : new ArrayList<EDirection>();
        long searchTime = System.currentTimeMillis() - searchStartMillis;
        System.out.println("SEARCH TOOK:   " + searchTime + " ms");
        System.out.println("NODES VISITED: " + this.searchedNodes);
        System.out.println("PERFORMANCE:   " + (double)this.searchedNodes.get() / (double)searchTime * 1000.0 + " nodes/sec");
        System.out.println("SOLUTION:      " + (result.size() == 0 ? "NOT FOUND" : "FOUND in " + result.size() + " steps"));
        if (result.size() > 0) {
            System.out.print("STEPS:         ");
            for (EDirection winDirection : result) {
                System.out.print(winDirection + " -> ");
            }
            System.out.println("BOARD SOLVED!");
        }
        System.out.println("=================");
        if (result.size() == 0) {
            throw new RuntimeException("FAILED TO SOLVE THE BOARD...");
        }
        return result;
    }

    public static void main(String[] args) {
        SokobanResult result = Sokoban.playAgentLevel((String)"../Sokoban4J/levels/Easy/level0002.1.s4jl", (IAgent)new MTDFS1Agent());
        System.out.println("MTDFS1Agent result: " + result.getResult());
        System.exit(0);
    }

    public class DFS1Thread
    extends Thread {
        public List<EDirection> preActions;
        public List<EDirection> result;
        public BoardCompact board;
        public boolean solutionFound;
        private int level;
        private int spareThreads;

        public DFS1Thread(BoardCompact board, int level, int spareThreads) {
            super("DFSThread");
            this.preActions = new ArrayList<EDirection>();
            this.result = new ArrayList<EDirection>();
            this.solutionFound = false;
            this.board = board;
            this.level = level;
            this.spareThreads = spareThreads;
        }

        @Override
        public void run() {
            if (this.level <= 0) {
                return;
            }
            if (MTDFS1Agent.this.solutionFound) {
                return;
            }
            if (this.spareThreads == 0) {
                this.dfs(this.level);
                return;
            }
            ArrayList<CAction> actions = new ArrayList<CAction>(4);
            while (true) {
                for (CMove move : CMove.getActions()) {
                    if (!move.isPossible(this.board)) continue;
                    actions.add((CAction)move);
                }
                for (CPush push : CPush.getActions()) {
                    if (!push.isPossible(this.board)) continue;
                    actions.add((CAction)push);
                }
                if (actions.size() != 1) break;
                this.preActions.add(((CAction)actions.get(0)).getDirection());
                ((CAction)actions.get(0)).perform(this.board);
            }
            HashMap<DFS1Thread, EDirection> threads = new HashMap<DFS1Thread, EDirection>();
            while (this.spareThreads > 0 && actions.size() > 1) {
                EDirection dir = ((CAction)actions.get(0)).getDirection();
                BoardCompact threadBoard = this.board.clone();
                ((CAction)actions.get(0)).perform(threadBoard);
                int nextSpareThreads = actions.size() == 2 ? this.spareThreads - 1 : (this.spareThreads > 2 ? 1 : 0);
                DFS1Thread thread = new DFS1Thread(threadBoard, this.level - 1, nextSpareThreads);
                thread.start();
                threads.put(thread, dir);
                this.spareThreads = this.spareThreads - 1 - nextSpareThreads;
                actions.remove(0);
            }
            this.dfs(actions, this.level);
            if (this.solutionFound) {
                this.preActions.addAll(this.result);
                this.result = this.preActions;
                return;
            }
            for (DFS1Thread thread : threads.keySet()) {
                try {
                    thread.join();
                }
                catch (Exception e) {
                    return;
                }
            }
            for (DFS1Thread thread : threads.keySet()) {
                if (!thread.solutionFound) continue;
                EDirection firstAction = (EDirection)threads.get(thread);
                this.result.clear();
                this.result.addAll(this.preActions);
                this.result.add(firstAction);
                this.result.addAll(thread.result);
                this.solutionFound = true;
            }
        }

        private boolean dfs(int level) {
            if (level <= 0) {
                return false;
            }
            if (MTDFS1Agent.this.solutionFound) {
                return false;
            }
            ArrayList<CAction> actions = new ArrayList<CAction>(4);
            for (CMove move : CMove.getActions()) {
                if (!move.isPossible(this.board)) continue;
                actions.add((CAction)move);
            }
            for (CPush push : CPush.getActions()) {
                if (!push.isPossible(this.board)) continue;
                actions.add((CAction)push);
            }
            return this.dfs(actions, level);
        }

        private boolean dfs(List<CAction> actions, int level) {
            if (level <= 0) {
                return false;
            }
            MTDFS1Agent.this.searchedNodes.incrementAndGet();
            for (CAction action : actions) {
                if (MTDFS1Agent.this.solutionFound) {
                    return false;
                }
                this.result.add(action.getDirection());
                action.perform(this.board);
                if (this.board.isVictory()) {
                    this.solutionFound();
                    return true;
                }
                if (this.dfs(level - 1)) {
                    this.solutionFound();
                    return true;
                }
                this.result.remove(this.result.size() - 1);
                action.reverse(this.board);
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void solutionFound() {
            Object object = MTDFS1Agent.this.solutionFoundMutex;
            synchronized (object) {
                if (!MTDFS1Agent.this.solutionFound) {
                    MTDFS1Agent.this.solutionFound = true;
                    this.solutionFound = true;
                }
            }
        }
    }
}

