/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.adventure.aggregators;

import cz.dd4j.utils.csv.CSV;
import java.io.File;
import java.util.ArrayList;

public class ResultsAggregator {
    private File resultsDir;
    private File outputDir;
    private CSV results;

    public ResultsAggregator(File resultsDir, File outputDir) {
        this.resultsDir = resultsDir;
        this.outputDir = outputDir;
    }

    public void aggregate() {
        System.out.println("Aggregating results...");
        this.results = new CSV();
        this.results.keys = new ArrayList();
        File[] fileArray = this.resultsDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().endsWith("-result.csv")) {
                this.processResultFile(file);
            }
            ++n2;
        }
        this.results.toFile(new File(this.outputDir, "aggregated-results.csv"));
    }

    private void processResultFile(File file) {
        CSV csv = null;
        try {
            csv = new CSV(file, ";", true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse CSV file at: " + file.getAbsolutePath(), e);
        }
        for (String key : csv.keys) {
            if (this.results.keys.contains(key)) continue;
            this.results.keys.add(key);
        }
        this.results.rows.addAll(csv.rows);
    }

    public static void main(String[] args) {
        File resultsDir = new File("./results");
        File outputDir = new File("./results");
        System.out.println("Aggregating Experiment Results");
        System.out.println("-- results taken from          " + resultsDir.getAbsolutePath());
        System.out.println("-- aggregated file output into " + outputDir.getAbsolutePath());
        ResultsAggregator aggregator = new ResultsAggregator(resultsDir, outputDir);
        aggregator.aggregate();
        System.out.println("---// FINISHED //---");
    }
}

