/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.adventure.aggregators;

import cz.dd4j.adventure.aggregators.AdventureDescriptorAggregator;
import cz.dd4j.adventure.aggregators.ResultsAggregator;
import cz.dd4j.utils.csv.CSV;
import java.io.File;
import java.util.ArrayList;

public class ExperimentResultsAggregator {
    private File resultsDir;
    private File outputDir;
    private CSV results;
    private CSV simstateDesc;

    public ExperimentResultsAggregator(File resultsDir, File outputDir) {
        this.resultsDir = resultsDir;
        this.outputDir = outputDir;
    }

    public void aggregate() {
        ResultsAggregator resultsAggregator = new ResultsAggregator(this.resultsDir, this.outputDir);
        resultsAggregator.aggregate();
        AdventureDescriptorAggregator simstateAggregator = new AdventureDescriptorAggregator(this.resultsDir, this.outputDir);
        simstateAggregator.aggregate();
        System.out.println("Aggregating results...");
        this.results = new CSV();
        this.results.keys = new ArrayList();
        this.simstateDesc = new CSV();
        this.simstateDesc.keys = new ArrayList();
        File[] fileArray = this.resultsDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().endsWith("-result.csv")) {
                this.processResultFile(file);
            } else if (file.getName().endsWith("-simstate_descriptor.csv")) {
                this.processDescriptorFile(file);
            }
            ++n2;
        }
        this.simstateDesc.keys.remove("EXP-id");
        this.simstateDesc.keys.remove("EXP-hero");
        this.results.toFile(new File(this.outputDir, "aggregated-results.csv"));
        this.simstateDesc.toFile(new File(this.outputDir, "aggregated-simstate_descriptors.csv"));
    }

    private void processResultFile(File file) {
        CSV csv = null;
        try {
            csv = new CSV(file, ";", true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse CSV file at: " + file.getAbsolutePath(), e);
        }
        for (String key : csv.keys) {
            if (this.results.keys.contains(key)) continue;
            this.results.keys.add(key);
        }
        this.results.rows.addAll(csv.rows);
    }

    private void processDescriptorFile(File file) {
        CSV csv = null;
        try {
            csv = new CSV(file, ";", true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse CSV file at: " + file.getAbsolutePath(), e);
        }
        for (String key : csv.keys) {
            if (this.simstateDesc.keys.contains(key)) continue;
            this.simstateDesc.keys.add(key);
        }
        for (CSV.CSVRow newRow : csv.rows) {
            boolean add = true;
            for (CSV.CSVRow existingRow : this.simstateDesc.rows) {
                if (!existingRow.getString("EXP-adventure").equals(newRow.getString("EXP-adventure"))) continue;
                add = false;
                break;
            }
            if (!add) continue;
            this.simstateDesc.rows.add(newRow);
        }
    }

    public static void main(String[] args) {
        File resultsDir = new File("./results");
        File outputDir = new File("./results");
        System.out.println("Aggregating Experiment Results");
        System.out.println("-- results taken from          " + resultsDir.getAbsolutePath());
        System.out.println("-- aggregated file output into " + outputDir.getAbsolutePath());
        ExperimentResultsAggregator aggregator = new ExperimentResultsAggregator(resultsDir, outputDir);
        aggregator.aggregate();
        System.out.println("---// FINISHED //---");
    }
}

