/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.adventure.aggregators;

import cz.dd4j.utils.csv.CSV;
import java.io.File;
import java.util.ArrayList;

public class AdventureDescriptorAggregator {
    private File resultsDir;
    private File outputDir;
    private CSV simstateDesc;

    public AdventureDescriptorAggregator(File resultsDir, File outputDir) {
        this.resultsDir = resultsDir;
        this.outputDir = outputDir;
    }

    public void aggregate() {
        System.out.println("Aggregating dventure descriptors...");
        this.simstateDesc = new CSV();
        this.simstateDesc.keys = new ArrayList();
        File[] fileArray = this.resultsDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (file.getName().endsWith("-adventure_descriptor.csv")) {
                this.processDescriptorFile(file);
            }
            ++n2;
        }
        this.simstateDesc.keys.remove("EXP-id");
        this.simstateDesc.keys.remove("EXP-hero");
        this.simstateDesc.toFile(new File(this.outputDir, "aggregated-adventure_descriptors.csv"));
    }

    private void processDescriptorFile(File file) {
        CSV csv = null;
        try {
            csv = new CSV(file, ";", true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to parse CSV file at: " + file.getAbsolutePath(), e);
        }
        for (String key : csv.keys) {
            if (this.simstateDesc.keys.contains(key)) continue;
            this.simstateDesc.keys.add(key);
        }
        for (CSV.CSVRow newRow : csv.rows) {
            boolean add = true;
            for (CSV.CSVRow existingRow : this.simstateDesc.rows) {
                if (!existingRow.getString("EXP-adventure").equals(newRow.getString("EXP-adventure"))) continue;
                add = false;
                break;
            }
            if (!add) continue;
            this.simstateDesc.rows.add(newRow);
        }
    }

    public static void main(String[] args) {
        File resultsDir = new File("./results");
        File outputDir = new File("./results");
        System.out.println("Aggregating Experiment SimState Descriptors");
        System.out.println("-- results taken from          " + resultsDir.getAbsolutePath());
        System.out.println("-- aggregated file output into " + outputDir.getAbsolutePath());
        AdventureDescriptorAggregator aggregator = new AdventureDescriptorAggregator(resultsDir, outputDir);
        aggregator.aggregate();
        System.out.println("---// FINISHED //---");
    }
}

