/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.adventure;

import cz.dd4j.adventure.ExperimentEvaluatorConfig;
import cz.dd4j.adventure.aggregators.ExperimentResultsAggregator;
import cz.dd4j.descriptor.AdventureDescriptor;
import cz.dd4j.domain.EEntity;
import cz.dd4j.loader.agents.AgentsLoader;
import cz.dd4j.loader.simstate.SimStateLoader;
import cz.dd4j.simulation.SimStatic;
import cz.dd4j.simulation.SimStaticConfig;
import cz.dd4j.simulation.SimStaticStats;
import cz.dd4j.simulation.actions.instant.IFeatureInstantAction;
import cz.dd4j.simulation.actions.instant.IHeroInstantAction;
import cz.dd4j.simulation.actions.instant.IInstantAction;
import cz.dd4j.simulation.actions.instant.IMonsterInstantAction;
import cz.dd4j.simulation.actions.instant.impl.FeatureAttackInstant;
import cz.dd4j.simulation.actions.instant.impl.HeroAttackInstant;
import cz.dd4j.simulation.actions.instant.impl.HeroDisarmInstant;
import cz.dd4j.simulation.actions.instant.impl.HeroDropInstant;
import cz.dd4j.simulation.actions.instant.impl.HeroMoveInstant;
import cz.dd4j.simulation.actions.instant.impl.HeroPickupInstant;
import cz.dd4j.simulation.actions.instant.impl.MonsterAttackInstant;
import cz.dd4j.simulation.actions.instant.impl.MonsterMoveInstant;
import cz.dd4j.simulation.data.agents.AgentMindBody;
import cz.dd4j.simulation.data.agents.Agents;
import cz.dd4j.simulation.data.state.SimState;
import cz.dd4j.simulation.events.ISimEvents;
import cz.dd4j.ui.console.VisConsole;
import cz.dd4j.ui.log.VisFile;
import cz.dd4j.utils.ExceptionToString;
import cz.dd4j.utils.csv.CSV;
import cz.dd4j.utils.files.DirCrawler;
import cz.dd4j.utils.files.DirCrawlerCallback;
import cz.dd4j.utils.files.IDirCrawlerCallback;
import cz.dd4j.utils.reporting.IReporting;
import cz.dd4j.utils.reporting.Reporting;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class ExperimentEvaluator {
    private ExperimentEvaluatorConfig config;
    private ExecutorService executor;
    private List<File> heroAgentsFiles;

    public ExperimentEvaluator(ExperimentEvaluatorConfig config) {
        this.config = config;
    }

    public synchronized void init() {
        if (this.executor != null) {
            return;
        }
        int numCores = this.config.maxCores;
        if (numCores == -1) {
            numCores = Runtime.getRuntime().availableProcessors();
        }
        this.executor = Executors.newFixedThreadPool(numCores);
        this.heroAgentsFiles = this.findHeroAgentFiles();
        this.config.target.ensureDir();
    }

    private List<File> findHeroAgentFiles() {
        final ArrayList<File> heroAgents = new ArrayList<File>();
        File heroAgentsDir = this.config.heroAgents.dir;
        DirCrawler.crawl((File)heroAgentsDir, (IDirCrawlerCallback)new DirCrawlerCallback(){

            public void visitFile(File file) {
                if (file.getName().endsWith(".xml")) {
                    heroAgents.add(file);
                }
            }
        });
        return heroAgents;
    }

    public void run() throws InterruptedException {
        System.out.println("EXPERIMENT EVALUATOR: RUNNING");
        this.init();
        File dungeonDirs = this.config.source.dir;
        DirCrawler.crawl((File)dungeonDirs, (IDirCrawlerCallback)new DirCrawlerCallback(){

            public void visitFile(File adventurefile) {
                if (!adventurefile.getName().endsWith(".xml")) {
                    return;
                }
                for (File heroAgentFile : ExperimentEvaluator.this.heroAgentsFiles) {
                    Playout item = new Playout(adventurefile, heroAgentFile);
                    ExperimentEvaluator.this.runOnExecutor(item);
                }
            }
        });
        System.out.println("EXPERIMENT EVALUATOR: FINISHED SUBMITTING TASKS, awaiting executor termination");
        this.executor.shutdown();
        this.executor.awaitTermination(Integer.MAX_VALUE, TimeUnit.DAYS);
        this.executor = null;
        System.out.println("EXPERIMENT EVALUATOR: AGGREGATING RESULTS");
        ExperimentResultsAggregator aggregator = new ExperimentResultsAggregator(this.config.target.dir, this.config.target.dir);
        aggregator.aggregate();
        System.out.println("EXPERIMENT EVALUATOR: AGGREGATING RESULTS");
    }

    private synchronized void runOnExecutor(final Playout item) {
        if (this.config.playoutLimit == 0) {
            return;
        }
        if (this.config.playoutLimit > 0) {
            --this.config.playoutLimit;
        }
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    item.stats = ExperimentEvaluator.this.playout(ExperimentEvaluator.getSimStaticConfig(), item);
                    System.out.println(String.valueOf(item.toString()) + ": playout result " + item.stats.simulationResult.resultType + " in " + item.stats.simulationResult.frameNumber + " frame");
                    if (item.stats.simulationResult.exception != null) {
                        System.out.println(ExceptionToString.process((String)(String.valueOf(item.toString()) + ": EXCEPTION!"), (Throwable)item.stats.simulationResult.exception));
                    }
                    try {
                        ExperimentEvaluator.this.saveResult(item);
                    }
                    catch (IOException e) {
                        System.out.println(ExceptionToString.process((String)(String.valueOf(item.toString()) + ": error trying to save result"), (Throwable)e));
                    }
                    System.out.println(String.valueOf(item.toString()) + ": DONE");
                }
                catch (Exception e) {
                    System.out.println(ExceptionToString.process((String)(String.valueOf(item.toString()) + ": FAILED TO RUN"), (Throwable)e));
                }
            }
        });
    }

    private SimStaticStats playout(SimStaticConfig config, Playout item) {
        AdventureDescriptor descriptor;
        System.out.println(String.valueOf(item.toString()) + ": loading simulation state");
        SimState simState = new SimStateLoader().loadSimState(item.adventureFile, true);
        config.bindSimState(simState);
        System.out.println(String.valueOf(item.toString()) + ": loading hero agent");
        Agents heroes = new AgentsLoader().loadAgents(item.heroFile);
        config.bindHeroes(heroes);
        config.id = "E" + item.number;
        config.description = item.toString();
        config.state.roundsLeft = Math.max(1, (int)Math.ceil(config.timeoutMultiplier * (double)config.state.dungeon.rooms.size()));
        item.config = config;
        System.out.println(String.valueOf(item.toString()) + ": timeout set to " + config.state.roundsLeft + " frames = 10*dungeon.rooms.size()^2 = 10*" + config.state.dungeon.rooms.size() + "^2");
        System.out.println(String.valueOf(item.toString()) + ": checking the configuration");
        if (!config.isReady()) {
            throw new RuntimeException("Configuration is not complete. " + config.getMissingInitDescription());
        }
        System.out.println(String.valueOf(item.toString()) + ": creating dungeon descriptor");
        item.descriptor = descriptor = AdventureDescriptor.describe((File)item.adventureFile);
        System.out.println(String.valueOf(item.toString()) + ": creating the simulation");
        SimStatic simulation = new SimStatic(config);
        if (this.config.consoleVisualization) {
            System.out.println(String.valueOf(item.toString()) + ": attaching VisConsole to the simulation");
            VisConsole visConsole = new VisConsole();
            visConsole.outputPrefix = String.valueOf(item.toString()) + " -> ";
            simulation.getEvents().addHandler((ISimEvents)visConsole);
        }
        if (this.config.storeReplays) {
            System.out.println(String.valueOf(item.toString()) + ": attaching VisFile to the simulation");
            VisFile visFile = new VisFile(this.config.target.getFile(item.toFileName(".replay.zip")), true);
            simulation.getEvents().addHandler((ISimEvents)visFile);
        }
        System.out.println(String.valueOf(item.toString()) + ": running the simulation");
        item.stats = simulation.simulate();
        return item.stats;
    }

    private void saveResult(Playout item) throws IOException {
        System.out.println(String.valueOf(item.toString()) + ": saving the results");
        File resultFile = this.config.target.getFile(item.toFileName("-result.csv"));
        new Reporting(new IReporting[]{item, item.stats.config, item.stats.simulationResult, ((AgentMindBody)item.config.state.heroes.values().iterator().next()).mind}).reportToFile(resultFile);
        File descriptorFile = this.config.target.getFile(item.toFileName("-adventure_descriptor.csv"));
        new Reporting(new IReporting[]{item, item.descriptor}).reportToFile(descriptorFile);
        File statsFile = this.config.target.getFile(item.toFileName("-stats.csv"));
        new Reporting(new IReporting[]{item, item.stats}).reportToFile(statsFile);
    }

    public static SimStaticConfig getSimStaticConfig() {
        SimStaticConfig config = new SimStaticConfig();
        IHeroInstantAction[] heroActions = new IHeroInstantAction[]{new HeroAttackInstant(), new HeroDisarmInstant(), new HeroDropInstant(), new HeroMoveInstant(), new HeroPickupInstant()};
        IMonsterInstantAction[] monsterActions = new IMonsterInstantAction[]{new MonsterMoveInstant(), new MonsterAttackInstant()};
        IFeatureInstantAction[] featureActions = new IFeatureInstantAction[]{new FeatureAttackInstant()};
        config.bindActions(EEntity.HERO, (IInstantAction[])heroActions);
        config.bindActions(EEntity.MONSTER, (IInstantAction[])monsterActions);
        config.bindActions(EEntity.FEATURE, (IInstantAction[])featureActions);
        return config;
    }

    public static void main(String[] args) {
        try {
            ExperimentEvaluatorConfig config = new ExperimentEvaluatorConfig();
            config.source.dir = new File("../DarkDungeon4J-Generator/result/adventures/2017/june/test");
            config.heroAgents.dir = new File("./data/hero-agents");
            config.target.dir = new File("./result");
            config.playoutLimit = 4;
            config.consoleVisualization = true;
            config.storeReplays = true;
            new ExperimentEvaluator(config).run();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public static class Playout
    implements IReporting {
        private static AtomicInteger ATOMIC_INTEGER = new AtomicInteger(0);
        public final int number = ATOMIC_INTEGER.incrementAndGet();
        public File adventureFile;
        public File heroFile;
        public SimStaticConfig config;
        public AdventureDescriptor descriptor;
        public SimStaticStats stats;
        public static final String CSV_ID = "EXP-id";
        public static final String CSV_ADVENTURE = "EXP-adventure";
        public static final String CSV_HERO = "EXP-hero";

        Playout(File dungeonDir, File heroFile) {
            this.adventureFile = dungeonDir;
            this.heroFile = heroFile;
        }

        public String toFileName(String suffix) {
            return String.valueOf(this.toId()) + suffix;
        }

        public String toString() {
            return "Playout[number=" + this.number + ", adventure=" + this.adventureFile.getName() + ", hero=" + this.heroFile.getName() + "]";
        }

        public String toId() {
            return "E" + this.number + "-" + this.adventureFile.getName().replaceAll("\\.xml", "") + "-" + this.heroFile.getName().replaceAll("\\.xml", "");
        }

        public List<String> getCSVHeaders() {
            ArrayList<String> result = new ArrayList<String>();
            result.add(CSV_ID);
            result.add(CSV_ADVENTURE);
            result.add(CSV_HERO);
            return result;
        }

        public CSV.CSVRow getCSVRow() {
            CSV.CSVRow result = new CSV.CSVRow();
            result.add(CSV_ID, (Object)this.number);
            result.add(CSV_ADVENTURE, this.adventureFile.getName());
            result.add(CSV_HERO, this.heroFile.getName());
            return result;
        }
    }
}

