/*
 * Decompiled with CFR 0.152.
 */
package cz.dd4j.adventure;

import cz.dd4j.adventure.ExperimentEvaluator;
import cz.dd4j.agents.replay.Replay;
import cz.dd4j.loader.simstate.SimStateLoader;
import cz.dd4j.simulation.SimStatic;
import cz.dd4j.simulation.SimStaticConfig;
import cz.dd4j.simulation.SimStaticStats;
import cz.dd4j.simulation.data.state.SimState;
import cz.dd4j.simulation.events.ISimEvents;
import cz.dd4j.ui.console.VisConsole;
import cz.dd4j.ui.gui.VisGUI;
import cz.dd4j.ui.log.VisFile;
import java.io.File;

public class ExampleAdventureReplay {
    public static void main(String[] args) {
        ExampleAdventureReplay.runDungeon();
    }

    private static void runDungeon() {
        SimStaticConfig config = ExperimentEvaluator.getSimStaticConfig();
        File dungeonFile = new File("./data/dungeons/dungeon-example/dungeon-01.xml");
        SimStateLoader loader = new SimStateLoader();
        SimState simState = loader.loadSimState(dungeonFile, false);
        Replay replay = new Replay(simState, "example-dungeon-run.zip");
        config.bindSimState(simState);
        config.bindHeroes(replay.replayHeroAgents);
        if (!config.isReady()) {
            throw new RuntimeException("Configuration is not complete. " + config.getMissingInitDescription());
        }
        SimStatic simulation = new SimStatic(config);
        simulation.getEvents().addHandler((ISimEvents)replay);
        simulation.getEvents().addHandler((ISimEvents)new VisConsole());
        simulation.getEvents().addHandler((ISimEvents)new VisFile("example-dungeon-run-replay.zip"));
        simulation.getEvents().addHandler((ISimEvents)new VisGUI());
        SimStaticStats result = simulation.simulate();
        System.out.println();
        System.out.println("Finished: " + result.simulationResult);
        System.out.println();
        System.out.println("---/// DONE ///---");
    }
}

