/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.widget;

import cz.cuni.amis.pogamut.sposh.elements.EnumValue;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.Result;
import cz.cuni.amis.pogamut.sposh.executor.ParamInfo;
import cz.cuni.pogamut.shed.presenter.IPresenter;
import cz.cuni.pogamut.shed.widget.IPresentedWidget;
import cz.cuni.pogamut.shed.widget.ShedScene;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.PopupMenuProvider;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class ShedWidget
extends Widget
implements PopupMenuProvider,
IPresentedWidget {
    private static final int textOfs = 4;
    protected Color color;
    protected Color borderColor;
    protected IPresenter actionProvider;
    protected static final int width = 240;
    protected static final int height = 30;
    private String heading;
    private static final Font headingFont = new Font("Helvetica", 1, 16);
    List<Variable> presentVars = new LinkedList<Variable>();
    private static final Font presentFont = new Font("Helvetica", 1, 12);
    List<Variable> errorVars = new LinkedList<Variable>();
    private static final Font missingFont = new Font("Helvetica", 1, 12);
    List<Variable> unusedVars = new LinkedList<Variable>();
    private static final Font unusedFont = new Font("Helvetica", 2, 12);
    private static final Font typeFont = new Font("Helvetica", 2, 8);
    private int intensity = 0;
    private static int BORDER_WIDTH = 4;
    static final int BREAKPOINT_STRIP_WIDTH = 10;
    private ShowBreakpoint showBreakpointStrip = ShowBreakpoint.NONE;

    ShedWidget(ShedScene scene, String displayName, Color color) {
        super((Scene)scene);
        assert (displayName != null);
        this.heading = displayName;
        this.setToolTipText(this.heading);
        assert (color != null);
        this.color = color;
        this.borderColor = color;
        this.getActions().addAction(ActionFactory.createPopupMenuAction((PopupMenuProvider)this));
        this.setPreferredBounds(null);
        this.setMinimumSize(new Dimension(240, 30));
    }

    public final String getDisplayName() {
        return this.heading;
    }

    public final void setDisplayName(String newDisplayName) {
        this.heading = newDisplayName;
        this.setToolTipText(this.heading);
        this.revalidate(true);
    }

    void setBorderColor(Color newBorderColor) {
        this.borderColor = newBorderColor;
    }

    public final void setPresent(List<Variable> newPresent) {
        this.presentVars.clear();
        this.presentVars.addAll(newPresent);
        this.revalidate();
    }

    public final void setError(List<Variable> newMissing) {
        this.errorVars.clear();
        this.errorVars.addAll(newMissing);
        this.revalidate();
    }

    public final void setUnused(List<Variable> newUnused) {
        this.unusedVars.clear();
        this.unusedVars.addAll(newUnused);
        this.revalidate();
    }

    public void setActiveIntensity(int percent) {
        this.intensity = percent;
        this.repaint();
    }

    @Override
    public final IPresenter getPresenter() {
        return this.actionProvider;
    }

    public final void setPresenter(IPresenter newPresenter) {
        this.actionProvider = newPresenter;
    }

    public void addBreakpoint(boolean single) {
        this.showBreakpointStrip = single ? ShowBreakpoint.SINGLE : ShowBreakpoint.PERMANENT;
        this.repaint();
    }

    public void removeBreakpoint() {
        this.showBreakpointStrip = ShowBreakpoint.NONE;
        this.repaint();
    }

    public final JPopupMenu getPopupMenu(Widget widget, Point localLocation) {
        assert (widget == this);
        Action[] actions = this.actionProvider.getMenuActions();
        if (actions == null) {
            return null;
        }
        JPopupMenu menu = new JPopupMenu();
        for (Action action : actions) {
            JMenuItem item = new JMenuItem(action);
            menu.add(item);
        }
        return menu;
    }

    protected Rectangle calculateClientArea() {
        Graphics2D gr = this.getGraphics();
        if (gr == null) {
            throw new IllegalStateException("Trying to compute client area without graphics2D.");
        }
        FontMetrics titleFontMetrics = gr.getFontMetrics(headingFont);
        FontMetrics boldFontMetrics = gr.getFontMetrics(presentFont);
        FontMetrics plainFontMetrics = gr.getFontMetrics(missingFont);
        FontMetrics italicFontMetrics = gr.getFontMetrics(unusedFont);
        int widgetHeight = this.calculateHeadingY(gr);
        widgetHeight += titleFontMetrics.getHeight();
        widgetHeight += boldFontMetrics.getHeight() * this.presentVars.size();
        widgetHeight += plainFontMetrics.getHeight() * this.errorVars.size();
        return new Rectangle(0, 0, 240, widgetHeight += italicFontMetrics.getHeight() * this.unusedVars.size());
    }

    private int calculateHeadingY(Graphics2D gr) {
        FontMetrics titleFontMetrics = gr.getFontMetrics(headingFont);
        return titleFontMetrics.getLeading() + titleFontMetrics.getAscent();
    }

    protected void paintWidget() {
        Graphics2D gr = this.getGraphics();
        Rectangle clientArea = this.getClientArea();
        this.paintBackground(gr, clientArea);
        if (this.showBreakpointStrip != ShowBreakpoint.NONE) {
            gr.setColor(this.showBreakpointStrip.getColor());
            gr.fillRect(clientArea.width - 10, clientArea.y, 10, clientArea.height);
        }
        this.paintText(gr);
    }

    private void paintBackground(Graphics2D gr, Rectangle clientArea) {
        Color drawBorderColor;
        Color focusColor = Color.BLACK;
        Color color = drawBorderColor = this.getState().isObjectFocused() ? focusColor : this.borderColor;
        if (this.intensity > 0) {
            Color fullColor = Color.RED;
            drawBorderColor = new Color(this.color.getRed() + (fullColor.getRed() * this.intensity - this.color.getRed() * this.intensity) / 100, this.color.getGreen() + (fullColor.getGreen() * this.intensity - this.color.getGreen() * this.intensity) / 100, this.color.getBlue() + (fullColor.getBlue() * this.intensity - this.color.getBlue() * this.intensity) / 100);
        }
        gr.setColor(drawBorderColor);
        gr.fillRect(clientArea.x, clientArea.y, clientArea.width, clientArea.height);
        gr.setColor(this.color);
        gr.fillRect(clientArea.x + BORDER_WIDTH, clientArea.y + BORDER_WIDTH, clientArea.width - 2 * BORDER_WIDTH, clientArea.height - 2 * BORDER_WIDTH);
    }

    private void paintText(Graphics2D gr) {
        int x = 4;
        int y = this.calculateHeadingY(gr);
        y += this.drawLines(Color.BLACK, headingFont, Arrays.asList(this.heading), x, y, gr);
        y += this.drawLines(Color.BLACK, presentFont, this.convert(this.presentVars), x, y, gr);
        y += this.drawLines(Color.RED, missingFont, this.convert(this.errorVars), x, y, gr);
        this.drawLines(Color.BLACK, unusedFont, this.convert(this.unusedVars), x, y, gr);
    }

    private List<String> convert(List<Variable> vars) {
        LinkedList<String> lines = new LinkedList<String>();
        for (Variable var : vars) {
            lines.add(var.toString());
        }
        return lines;
    }

    private int drawLines(Color fontColor, Font font, List<String> lines, int x, int y, Graphics2D gr) {
        gr.setColor(fontColor);
        gr.setFont(font);
        FontMetrics fontMetrics = gr.getFontMetrics(font);
        int linesHeight = 0;
        for (String missingLine : lines) {
            this.drawFittingString(x, y, missingLine, gr, fontMetrics);
            y += fontMetrics.getHeight();
            linesHeight += fontMetrics.getHeight();
        }
        return linesHeight;
    }

    private void drawFittingString(int x, int y, String text, Graphics2D gr, FontMetrics fm) {
        AffineTransform originalTransform = gr.getTransform();
        gr.translate(x, y);
        String fittingText = this.getFittingString(text, fm, 240);
        gr.drawString(fittingText, 0, 0);
        gr.setTransform(originalTransform);
    }

    private String getFittingString(String text, FontMetrics metrics, int maxWidth) {
        if (metrics.stringWidth(text) < maxWidth) {
            return text;
        }
        for (int index = text.length() - 1; index > 0; --index) {
            String shorter = text.substring(0, index).concat("...");
            if (metrics.stringWidth(shorter) >= maxWidth) continue;
            return shorter;
        }
        return "...";
    }

    public String toString() {
        return "ShedWidget: " + this.getDisplayName();
    }

    private static enum ShowBreakpoint {
        NONE(Color.WHITE),
        SINGLE(new Color(240, 72, 72)),
        PERMANENT(new Color(178, 15, 15));

        private final Color color;

        private ShowBreakpoint(Color color) {
            this.color = color;
        }

        public Color getColor() {
            return this.color;
        }
    }

    public static final class Variable {
        public final String name;
        public final ParamInfo.Type type;
        public final String valueString;
        public final String errorMsg;

        public Variable(String name, ParamInfo.Type type, String valueString, String errorMsg) {
            this.name = name;
            this.type = type;
            this.valueString = valueString;
            this.errorMsg = errorMsg;
        }

        public String toString() {
            String varInfo = this.name;
            if (!this.valueString.isEmpty()) {
                varInfo = varInfo + '=';
                try {
                    Object varValue = Result.parseValue((String)this.valueString);
                    varInfo = varValue instanceof EnumValue ? varInfo + ((EnumValue)varValue).getSimpleName() : varInfo + this.valueString;
                }
                catch (ParseException ex) {
                    varInfo = varInfo + this.valueString;
                }
            }
            if (!this.errorMsg.isEmpty()) {
                varInfo = varInfo + ' ';
                varInfo = varInfo + this.errorMsg;
            }
            return varInfo;
        }
    }
}

