/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.presenter;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.INamedElement;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveData;
import cz.cuni.pogamut.posh.explorer.IPaletteActions;
import cz.cuni.pogamut.shed.presenter.ShedPresenter;
import cz.cuni.pogamut.shed.widget.ShedScene;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.visual.action.WidgetAction;
import org.netbeans.api.visual.model.ObjectState;
import org.netbeans.api.visual.widget.Widget;

final class FocusActionFactory {
    FocusActionFactory() {
    }

    static WidgetAction createFocusAction() {
        return new FocusAction();
    }

    static WidgetAction createCompetenceFocusAction(final Competence competence) {
        return new FocusAction(){

            @Override
            protected String getHtmlDescription() {
                return competence.getHtmlDescription();
            }
        };
    }

    static WidgetAction createActionPatternFocusAction(final ActionPattern actionPattern) {
        return new FocusAction(){

            @Override
            protected String getHtmlDescription() {
                return actionPattern.getHtmlDescription();
            }
        };
    }

    static WidgetAction createPrimitiveFocusAction(final INamedElement primitive, final ShedPresenter presenter) {
        return new FocusAction(){

            @Override
            protected String getHtmlDescription() {
                PrimitiveData metadata = presenter.getMetadata(primitive.getName());
                if (metadata == null) {
                    metadata = new PrimitiveData(primitive.getName());
                }
                return metadata.getHtmlDescription();
            }
        };
    }

    private static class FocusAction
    extends WidgetAction.Adapter {
        private FocusAction() {
        }

        public final WidgetAction.State mouseClicked(Widget widget, WidgetAction.WidgetMouseEvent event) {
            if (event.getButton() == 1 && event.getClickCount() == 1) {
                ObjectState widgetState;
                boolean isFocused = (widgetState = widget.getState()).isObjectFocused();
                ObjectState newWidgetState = widgetState.deriveObjectFocused(!isFocused);
                this.unfocusAllWidgets(widget);
                widget.setState(newWidgetState);
                widget.revalidate();
                String htmlDescription = this.getHtmlDescription();
                if (htmlDescription != null) {
                    IPaletteActions paletteActions = ((ShedScene)widget.getScene()).getPaletteActions();
                    paletteActions.setHtmlDescription(htmlDescription);
                }
                return WidgetAction.State.CONSUMED;
            }
            return WidgetAction.State.REJECTED;
        }

        private void unfocusAllWidgets(Widget widget) {
            Set<Widget> allFocusedWidgets = this.getFocusedWidgets((Widget)widget.getScene());
            for (Widget focusedWidget : allFocusedWidgets) {
                ObjectState unfocusedState = focusedWidget.getState().deriveObjectFocused(false);
                focusedWidget.setState(unfocusedState);
            }
        }

        private Set<Widget> getFocusedWidgets(Widget rootWidget) {
            HashSet<Widget> focusedWidgets = new HashSet<Widget>();
            if (rootWidget.getState().isObjectFocused()) {
                focusedWidgets.add(rootWidget);
            }
            for (Widget child : rootWidget.getChildren()) {
                focusedWidgets.addAll(this.getFocusedWidgets(child));
            }
            return focusedWidgets;
        }

        protected String getHtmlDescription() {
            return null;
        }
    }
}

