/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.presenter;

import cz.cuni.amis.pogamut.sposh.elements.DriveCollection;
import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.LapPath;
import cz.cuni.amis.pogamut.sposh.elements.LapType;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.pogamut.shed.presenter.AbstractPresenter;
import cz.cuni.pogamut.shed.presenter.ShedPresenter;
import cz.cuni.pogamut.shed.widget.ShedCreationContainer;
import cz.cuni.pogamut.shed.widget.ShedDrivesEnvelope;
import cz.cuni.pogamut.shed.widget.ShedScene;
import cz.cuni.pogamut.shed.widget.SlotEnvelope;
import java.beans.PropertyChangeEvent;
import javax.swing.Action;
import org.netbeans.api.visual.action.WidgetAction;

final class DCPresenter
extends AbstractPresenter
implements PoshElementListener<DriveCollection> {
    private final DriveCollection dc;

    DCPresenter(ShedScene scene, ShedPresenter presenter, DriveCollection dc) {
        super(scene, presenter);
        this.dc = dc;
    }

    @Override
    public void register() {
        this.dc.addElementListener((PoshElementListener)this);
    }

    @Override
    public void unregister() {
        this.dc.removeElementListener((PoshElementListener)this);
    }

    @Override
    public Action[] getMenuActions() {
        return null;
    }

    public void childElementAdded(DriveCollection dc, PoshElement child) {
        assert (this.isDrive(child) || this.isSense(child));
        if (this.isDrive(child)) {
            DriveElement drive = this.extractDrive(dc.getDrives(), child);
            int drivePosition = this.getPosition(dc.getDrives(), drive);
            LapPath drivePath = LapPath.DRIVE_COLLECTION_PATH.concat(LapType.DRIVE_ELEMENT, drivePosition);
            ShedCreationContainer<SlotEnvelope> driveEnvelope = this.scene.getWidgetFactory().createDriveEnvelope(drivePath, drive);
            this.scene.getDrivesEnvelope().add(driveEnvelope.getWidget(), drivePosition);
            this.scene.update();
            this.scene.addArrows(driveEnvelope.getArrows());
            this.scene.addArrow(this.scene.getRootAnchor(), driveEnvelope.getWidget().getAnchor());
            this.scene.update();
        }
    }

    public void childElementMoved(DriveCollection dc, PoshElement child, int oldIndex, int newIndex) {
        assert (this.isDrive(child) || this.isSense(child));
        if (this.isDrive(child)) {
            ShedDrivesEnvelope drivesEnvelope = this.scene.getDrivesEnvelope();
            SlotEnvelope driveEnvelope = (SlotEnvelope)((Object)drivesEnvelope.getChild(oldIndex));
            drivesEnvelope.move(newIndex, driveEnvelope);
        }
    }

    public void childElementRemoved(DriveCollection dc, PoshElement child, int removedChildIndex) {
        assert (this.isDrive(child) || this.isSense(child));
        if (this.isDrive(child)) {
            SlotEnvelope removedDriveWidget = (SlotEnvelope)((Object)this.scene.getDrivesEnvelope().getChild(removedChildIndex));
            this.scene.removeBranch(removedDriveWidget);
            this.scene.update();
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public WidgetAction getEditAction() {
        return null;
    }
}

