/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.widget.editor;

import cz.cuni.amis.pogamut.sposh.elements.EnumValue;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.Result;
import cz.cuni.amis.pogamut.sposh.exceptions.FubarException;
import cz.cuni.amis.pogamut.sposh.executor.ParamInfo;
import cz.cuni.pogamut.shed.widget.editor.ArgumentsTableModel;
import cz.cuni.pogamut.shed.widget.editor.EnumStructureFactory;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

class VariableTable
extends JTable {
    private TableCellRenderer enumCellRenderer = new EnumCellRenderer();

    public VariableTable(TableModel dm) {
        super(dm);
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        Object value;
        Object stringValue = super.getValueAt(row, column);
        try {
            value = Result.parseValue((String)((String)stringValue));
        }
        catch (ParseException ex) {
            return super.getCellRenderer(row, column);
        }
        if (value instanceof EnumValue) {
            return this.enumCellRenderer;
        }
        return super.getCellRenderer(row, column);
    }

    @Override
    public TableCellEditor getCellEditor(int row, int column) {
        boolean paramIsEnum;
        String valueString = (String)this.getValueAt(row, column);
        ParamInfo info = this.getInfo(row);
        boolean bl = paramIsEnum = info != null && info.type == ParamInfo.Type.ENUM;
        if (paramIsEnum && valueString.isEmpty()) {
            return this.getEnumEditor(row, column, info.clsName);
        }
        try {
            Object value = Result.parseValue((String)valueString);
            boolean valueIsEnum = value instanceof EnumValue;
            if (valueIsEnum) {
                EnumValue enumValue = (EnumValue)value;
                return this.getEnumEditor(row, column, enumValue.getEnumFQN());
            }
        }
        catch (ParseException ex) {
            return super.getCellEditor(row, column);
        }
        return super.getCellEditor(row, column);
    }

    private TableCellEditor getEnumEditor(int row, int column, String enumFQN) {
        List<String> enumConsts = EnumStructureFactory.getValues(enumFQN);
        if (enumConsts != null) {
            ArrayList<EnumValue> enumValues = new ArrayList<EnumValue>();
            for (String enumConst : enumConsts) {
                enumValues.add(new EnumValue(enumFQN + '.' + enumConst));
            }
            return new EnumCellEditor(enumValues);
        }
        return super.getCellEditor(row, column);
    }

    private ParamInfo getInfo(int row) {
        if (this.dataModel instanceof ArgumentsTableModel) {
            ArgumentsTableModel model = (ArgumentsTableModel)this.dataModel;
            return model.getArguments().get(row).getInfo();
        }
        return null;
    }

    private static class EnumCellEditor
    extends AbstractCellEditor
    implements TableCellEditor,
    ActionListener {
        private JComboBox box;
        private static final String CLEAR_VALUE = "Clear the value";

        EnumCellEditor(List<EnumValue> enumValues) {
            this.box = new JComboBox<Object>(enumValues.toArray());
            this.box.addItem(CLEAR_VALUE);
            this.box.setRenderer(new CellRenderer());
            this.box.addActionListener(this);
        }

        @Override
        public Object getCellEditorValue() {
            if (this.box.getSelectedItem().equals(CLEAR_VALUE)) {
                return "";
            }
            EnumValue selectedItem = (EnumValue)this.box.getSelectedItem();
            return Result.toLap((Object)selectedItem);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object editedValueFromModel, boolean isSelected, int row, int column) {
            try {
                String enumConstFQN = (String)editedValueFromModel;
                if (!enumConstFQN.isEmpty()) {
                    Object editedEnumConst = Result.parseValue((String)enumConstFQN);
                    this.box.setSelectedItem(editedEnumConst);
                } else {
                    this.box.setSelectedIndex(0);
                }
            }
            catch (ParseException ex) {
                throw new FubarException("Unable to parse the " + editedValueFromModel, (Throwable)ex);
            }
            return this.box;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.fireEditingStopped();
        }

        private static class CellRenderer
        extends DefaultListCellRenderer {
            private CellRenderer() {
            }

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                if (value.equals(EnumCellEditor.CLEAR_VALUE)) {
                    return super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                }
                EnumValue enumValue = (EnumValue)value;
                String enumConst = enumValue.getSimpleName();
                this.setToolTipText(enumValue.getName());
                return super.getListCellRendererComponent((JList<?>)list, enumConst, index, isSelected, cellHasFocus);
            }
        }
    }

    private static class EnumCellRenderer
    extends DefaultTableCellRenderer {
        private EnumCellRenderer() {
        }

        @Override
        public void setValue(Object value) {
            EnumValue enumValue = new EnumValue((String)value);
            this.setText(enumValue.getSimpleName());
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            String stringValue = (String)value;
            try {
                EnumValue enumValue = (EnumValue)Result.parseValue((String)stringValue);
                String enumConst = enumValue.getSimpleName();
                this.setToolTipText(enumValue.getName());
                return super.getTableCellRendererComponent(table, enumConst, isSelected, hasFocus, row, column);
            }
            catch (ParseException ex) {
                throw new FubarException("Enum renderer should be used only for enum fields, got " + stringValue, (Throwable)ex);
            }
        }
    }
}

