/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.widget.editor;

import cz.cuni.amis.pogamut.sposh.elements.Arguments;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.Result;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.ParamInfo;

final class TableArgument {
    private String name;
    private String valueString;
    private final ParamInfo info;

    TableArgument(String name, String valueString, ParamInfo info) {
        this.name = name;
        this.valueString = valueString;
        this.info = info;
    }

    public String getName() {
        return this.name;
    }

    public String getValueString() {
        return this.valueString;
    }

    public void setValueString(String newValueString) throws ParseException {
        if (!Result.isVariableName((String)newValueString)) {
            Result.parseValue((String)newValueString);
        }
        this.valueString = newValueString;
    }

    public void setValueBlank() {
        this.valueString = "";
    }

    public Arguments.Argument createArgument(VariableContext ctx) throws IllegalStateException {
        if (Result.isVariableName((String)this.valueString)) {
            if (!ctx.hasVariable(this.valueString)) {
                throw new IllegalStateException("Variable " + this.valueString + " is not defined and can't be used as value.");
            }
            return Arguments.Argument.createVariableArgument((String)this.name, (String)this.valueString);
        }
        try {
            Object value = Result.parseValue((String)this.valueString);
            return Arguments.Argument.createValueArgument((String)this.name, (Object)value);
        }
        catch (ParseException ex) {
            throw new IllegalStateException(ex);
        }
    }

    void setName(String newName) {
        this.name = newName;
    }

    ParamInfo getInfo() {
        return this.info;
    }
}

