/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.presenter;

import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshElementListener;
import cz.cuni.pogamut.shed.presenter.AbstractAcceptAction;
import cz.cuni.pogamut.shed.presenter.AbstractPresenter;
import cz.cuni.pogamut.shed.presenter.AcceptActionFactory;
import cz.cuni.pogamut.shed.presenter.DeleteFocusedNodeAction;
import cz.cuni.pogamut.shed.presenter.FocusActionFactory;
import cz.cuni.pogamut.shed.presenter.IPresenter;
import cz.cuni.pogamut.shed.presenter.ShedMenuActionFactory;
import cz.cuni.pogamut.shed.presenter.ShedPresenter;
import cz.cuni.pogamut.shed.widget.ShedScene;
import cz.cuni.pogamut.shed.widget.ShedWidget;
import cz.cuni.pogamut.shed.widget.editor.ShedInplaceEditorFactory;
import java.beans.PropertyChangeEvent;
import javax.swing.Action;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.action.WidgetAction;

class DrivePresenter
extends AbstractPresenter
implements IPresenter,
PoshElementListener<DriveElement> {
    private final DriveElement drive;
    private final ShedWidget shedWidget;

    DrivePresenter(ShedScene scene, ShedPresenter presenter, DriveElement drive, ShedWidget widget) {
        super(scene, presenter);
        this.drive = drive;
        this.shedWidget = widget;
    }

    @Override
    public void register() {
        this.shedWidget.setPresenter(this);
        this.drive.addElementListener((PoshElementListener)this);
        this.shedWidget.getActions().addAction(FocusActionFactory.createFocusAction());
        this.shedWidget.getActions().addAction((WidgetAction)new DeleteFocusedNodeAction(ShedMenuActionFactory.deleteDriveAction(this.drive)));
    }

    @Override
    public void unregister() {
        this.drive.removeElementListener((PoshElementListener)this);
        this.shedWidget.setPresenter(null);
    }

    @Override
    public Action[] getMenuActions() {
        return new Action[]{ShedMenuActionFactory.appendDriveAction(this.drive), ShedMenuActionFactory.deleteDriveAction(this.drive), ShedMenuActionFactory.createSenseAction(this.drive)};
    }

    public void childElementAdded(DriveElement parent, PoshElement child) {
    }

    public void childElementMoved(DriveElement parent, PoshElement child, int oldIndex, int newIndex) {
    }

    public void childElementRemoved(DriveElement parent, PoshElement child, int removedChildIndex) {
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (!evt.getPropertyName().equals("deName")) {
            throw new IllegalArgumentException();
        }
        String newDriveName = evt.getNewValue().toString();
        this.shedWidget.setDisplayName(newDriveName);
    }

    @Override
    public AbstractAcceptAction[] getAcceptProviders() {
        return new AbstractAcceptAction[]{AcceptActionFactory.createSense2Drive(this.drive), AcceptActionFactory.createDrive2Drive(this.drive), AcceptActionFactory.createChoice2Drive(this.drive)};
    }

    @Override
    public WidgetAction getEditAction() {
        return ActionFactory.createInplaceEditorAction((TextFieldInplaceEditor)ShedInplaceEditorFactory.createDriveEditor(this.drive));
    }
}

