/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed;

import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.spi.java.project.support.ui.templates.JavaTemplates;
import org.netbeans.spi.project.ui.templates.support.Templates;
import org.openide.WizardDescriptor;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;

public final class NewPrimitiveWizardIterator
implements WizardDescriptor.InstantiatingIterator<WizardDescriptor> {
    public static final String ACTION_TEMPLATE_FILE = "Templates/Classes/Action.java";
    public static final String SENSE_TEMPLATE_FILE = "Templates/Classes/Sense.java";
    private int index;
    private WizardDescriptor wizard;
    private List<WizardDescriptor.Panel<WizardDescriptor>> panels;

    private List<WizardDescriptor.Panel<WizardDescriptor>> getPanels() {
        if (this.panels == null) {
            Project project = Templates.getProject((WizardDescriptor)this.wizard);
            Sources sources = ProjectUtils.getSources((Project)project);
            SourceGroup[] groups = sources.getSourceGroups("java");
            this.panels = new ArrayList<WizardDescriptor.Panel<WizardDescriptor>>();
            this.panels.add((WizardDescriptor.Panel<WizardDescriptor>)JavaTemplates.createPackageChooser((Project)project, (SourceGroup[])groups));
            String[] steps = this.createSteps();
            for (int i = 0; i < this.panels.size(); ++i) {
                Component c = this.panels.get(i).getComponent();
                if (steps[i] == null) {
                    steps[i] = c.getName();
                }
                if (!(c instanceof JComponent)) continue;
                JComponent jc = (JComponent)c;
                jc.putClientProperty("title", "New primitive");
                jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
                jc.putClientProperty("WizardPanel_contentData", steps);
                jc.putClientProperty("WizardPanel_autoWizardStyle", true);
                jc.putClientProperty("WizardPanel_contentDisplayed", true);
                jc.putClientProperty("WizardPanel_contentNumbered", true);
            }
        }
        return this.panels;
    }

    public Set<?> instantiate() throws IOException {
        String className = Templates.getTargetName((WizardDescriptor)this.wizard);
        FileObject pkg = Templates.getTargetFolder((WizardDescriptor)this.wizard);
        DataFolder targetFolder = DataFolder.findFolder((FileObject)pkg);
        FileObject templateFile = Templates.getTemplate((WizardDescriptor)this.wizard);
        DataObject templateDataObject = DataObject.find((FileObject)templateFile);
        DataObject createdDataObject = templateDataObject.createFromTemplate(targetFolder, className);
        OpenCookie open = (OpenCookie)createdDataObject.getCookie(OpenCookie.class);
        if (open != null) {
            open.open();
        }
        return Collections.singleton(createdDataObject);
    }

    public void initialize(WizardDescriptor wizard) {
        this.wizard = wizard;
    }

    public void uninitialize(WizardDescriptor wizard) {
        this.panels = null;
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.getPanels().get(this.index);
    }

    public String name() {
        return this.index + 1 + ". from " + this.panels.size();
    }

    public boolean hasNext() {
        return this.index < this.getPanels().size() - 1;
    }

    public boolean hasPrevious() {
        return this.index > 0;
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    public void addChangeListener(ChangeListener l) {
    }

    public void removeChangeListener(ChangeListener l) {
    }

    private String[] createSteps() {
        String[] beforeSteps = (String[])this.wizard.getProperty("WizardPanel_contentData");
        if (beforeSteps == null) {
            beforeSteps = new String[1];
        }
        String[] res = new String[beforeSteps.length - 1 + this.panels.size()];
        for (int i = 0; i < res.length; ++i) {
            res[i] = i < beforeSteps.length - 1 ? beforeSteps[i] : this.panels.get(i - beforeSteps.length + 1).getComponent().getName();
        }
        return res;
    }
}

