package cz.cuni.pogamut.posh.explorer;

import cz.cuni.amis.pogamut.sposh.elements.*;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveData;
import cz.cuni.pogamut.shed.presenter.ShedPresenter;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import org.netbeans.api.project.Project;

/**
 * Panel containing explorers for nodes of the plan: <ul>
 *
 * <li>{@link Sense Senses}</li>
 *
 * <li>{@link TriggeredAction Actions}</li>
 *
 * <li>{@link Competence Competences}</li>
 *
 * <li>{@link ActionPattern Action patterns}</li> </ul>
 */
public final class PalettePane extends JPanel implements IPaletteActions {

    private final Explorer<Competence> competencesExplorer;
    private final Explorer<ActionPattern> actionPatternsExplorer;
    private final Explorer<PrimitiveData> actionsExplorer;
    private final Explorer<PrimitiveData> sensesExplorer;

    public PalettePane(PoshPlan plan, Project project, ShedPresenter namePresenter) {
        initComponents();

        competencesExplorer = ExplorerFactory.createCompetenceExplorer(this, plan);
        explorers.addTab("Competences", competencesExplorer);

        actionPatternsExplorer = ExplorerFactory.createAPExplorer(this, plan);
        explorers.addTab("Action patterns", actionPatternsExplorer);

        if (project != null) {
            // Do I need two listeners? Crawler is synchronous.
            CrawlerListener<PrimitiveData> actionNameMapListener = new NameMapCrawler(namePresenter);
            actionsExplorer = ExplorerFactory.createActionsExplorer(this, project, actionNameMapListener);
            explorers.addTab("Actions", actionsExplorer);

            CrawlerListener<PrimitiveData> sensesNameMapListener = new NameMapCrawler(namePresenter);
            sensesExplorer = ExplorerFactory.createSensesExplorer(this, project, sensesNameMapListener);
            explorers.addTab("Senses", sensesExplorer);
        } else {
            actionsExplorer = null;
            sensesExplorer = null;
        }
    }

    /**
     * Recrawl all elements and update the data in the explorers of the palette.
     * Crawling is currently synchronous.
     */
    @Override
    public void refresh() {
        refresh(competencesExplorer);
        refresh(actionPatternsExplorer);
        refresh(actionsExplorer);
        refresh(sensesExplorer);
    }

    private <T> void refresh(Explorer<T> explorer) {
        if (explorer == null) {
            return;
        }
        IExplorerActions<T> actions = explorer.getActions();
        actions.refresh(explorer);
    }


    @Override
    public void setHtmlDescription(String htmlDescription) {
        txtDescription.setText(htmlDescription);
    }
    
    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jSplitPane1 = new javax.swing.JSplitPane();
        explorers = new javax.swing.JTabbedPane();
        decriptionPanel = new javax.swing.JPanel();
        lblDescription = new javax.swing.JLabel();
        jScrollPane2 = new javax.swing.JScrollPane();
        txtDescription = new javax.swing.JTextPane();

        setLayout(new java.awt.BorderLayout());

        jSplitPane1.setOrientation(javax.swing.JSplitPane.VERTICAL_SPLIT);
        jSplitPane1.setResizeWeight(1.0);

        explorers.setPreferredSize(new java.awt.Dimension(301, 300));
        jSplitPane1.setTopComponent(explorers);

        decriptionPanel.setPreferredSize(new java.awt.Dimension(301, 300));

        lblDescription.setText(org.openide.util.NbBundle.getMessage(PalettePane.class, "PalettePane.lblDescription.text")); // NOI18N

        jScrollPane2.setPreferredSize(new java.awt.Dimension(20, 150));

        txtDescription.setContentType(org.openide.util.NbBundle.getMessage(PalettePane.class, "PalettePane.txtDescription.contentType")); // NOI18N
        txtDescription.setText(org.openide.util.NbBundle.getMessage(PalettePane.class, "PalettePane.txtDescription.text")); // NOI18N
        jScrollPane2.setViewportView(txtDescription);

        javax.swing.GroupLayout decriptionPanelLayout = new javax.swing.GroupLayout(decriptionPanel);
        decriptionPanel.setLayout(decriptionPanelLayout);
        decriptionPanelLayout.setHorizontalGroup(
            decriptionPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(decriptionPanelLayout.createSequentialGroup()
                .addComponent(lblDescription)
                .addGap(0, 341, Short.MAX_VALUE))
            .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
        );
        decriptionPanelLayout.setVerticalGroup(
            decriptionPanelLayout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(decriptionPanelLayout.createSequentialGroup()
                .addComponent(lblDescription)
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addComponent(jScrollPane2, javax.swing.GroupLayout.DEFAULT_SIZE, 268, Short.MAX_VALUE))
        );

        jSplitPane1.setRightComponent(decriptionPanel);

        add(jSplitPane1, java.awt.BorderLayout.CENTER);
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JPanel decriptionPanel;
    private javax.swing.JTabbedPane explorers;
    private javax.swing.JScrollPane jScrollPane2;
    private javax.swing.JSplitPane jSplitPane1;
    private javax.swing.JLabel lblDescription;
    private javax.swing.JTextPane txtDescription;
    // End of variables declaration//GEN-END:variables
}
