/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.widget.editor;

import cz.cuni.amis.pogamut.sposh.elements.LapChain;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.executor.ParamInfo;
import cz.cuni.pogamut.shed.widget.editor.AddArgumentAction;
import cz.cuni.pogamut.shed.widget.editor.ArgumentsTableModel;
import cz.cuni.pogamut.shed.widget.editor.ArgumentsTableModelFactory;
import cz.cuni.pogamut.shed.widget.editor.RemoveArgumentAction;
import cz.cuni.pogamut.shed.widget.editor.TableArgument;
import cz.cuni.pogamut.shed.widget.editor.VariableTable;
import java.awt.Color;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.api.visual.action.InplaceEditorProvider;

class ActionEditor
extends JPanel {
    private final JTextField nameTextField;
    private final ArgumentsTableModel argumentsModel;

    ActionEditor(TriggeredAction action, ParamInfo[] params, InplaceEditorProvider.EditorController controller, LapChain chain) {
        this.setLayout(new BoxLayout(this, 3));
        this.setBorder(BorderFactory.createLineBorder(Color.BLACK));
        this.nameTextField = new JTextField();
        this.nameTextField.setText(action.getName());
        this.add(this.nameTextField);
        this.argumentsModel = ArgumentsTableModelFactory.createLeafModel(params, action.getArguments());
        VariableTable argumentsTable = new VariableTable(this.argumentsModel);
        JButton addArgBtn = new JButton("Add argument");
        AddArgumentAction addArgumentListener = new AddArgumentAction(argumentsTable, this.argumentsModel, controller, chain);
        addArgBtn.addActionListener(addArgumentListener);
        this.add(addArgBtn);
        JButton removeArgBtn = new JButton("Remove argument");
        RemoveArgumentAction removeArgumentListener = new RemoveArgumentAction(argumentsTable, this.argumentsModel);
        removeArgBtn.addActionListener(removeArgumentListener);
        this.add(removeArgBtn);
        this.add(argumentsTable.getTableHeader());
        this.add(argumentsTable);
    }

    String getActionName() {
        return this.nameTextField.getText().trim();
    }

    List<TableArgument> getArguments() {
        return this.argumentsModel.getArguments();
    }
}

