/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.widget;

import cz.cuni.pogamut.shed.widget.ShedScene;
import cz.cuni.pogamut.shed.widget.ShedWidget;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public class ShedCollapseWidget
extends ShedWidget {
    public static final int SQUARE_SIZE = 20;
    private boolean collapsed = false;

    public ShedCollapseWidget(ShedScene scene, String displayName, Color color) {
        super(scene, displayName, color);
    }

    private void paintPlus(Graphics2D g, Point center, int thickness) {
        g.fillRect(center.x - 10, center.y - thickness / 2, 20, thickness);
        g.fillRect(center.x - thickness / 2, center.y - 10, thickness, 20);
    }

    private void paintMinus(Graphics2D g, Point center, int thickness) {
        g.fillRect(center.x - 10, center.y - thickness / 2, 20, thickness);
    }

    @Override
    protected void paintWidget() {
        super.paintWidget();
        Graphics2D g = this.getGraphics();
        Rectangle clientArea = this.getClientArea();
        Point center = new Point(clientArea.x + clientArea.width - 10 - 10, clientArea.y + clientArea.height / 2);
        g.setColor(this.color.darker());
        if (this.collapsed) {
            this.paintPlus(g, center, 6);
        } else {
            this.paintMinus(g, center, 6);
        }
    }

    public void setCollapsed(boolean newCollapsed) {
        this.collapsed = newCollapsed;
        this.revalidate(true);
    }

    public boolean isCollapseArea(Point localPoint) {
        Rectangle clientArea = this.getClientArea();
        Rectangle collapseArea = new Rectangle(clientArea.x + clientArea.width - 10 - 20, clientArea.y + (clientArea.height - 20) / 2, 20, 20);
        return collapseArea.contains(localPoint);
    }
}

