/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.presenter;

import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.executor.ParamInfo;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveData;
import cz.cuni.pogamut.shed.presenter.INameMapListener;
import cz.cuni.pogamut.shed.widget.ShedScene;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ShedPresenter {
    private final ShedScene scene;
    private final PoshPlan lapTree;
    private final Map<String, PrimitiveData> nameMap = new HashMap<String, PrimitiveData>();
    private final Set<INameMapListener> nameMapListeners = new HashSet<INameMapListener>();

    public ShedPresenter(ShedScene scene, PoshPlan lapTree) {
        this.scene = scene;
        this.lapTree = lapTree;
    }

    final ShedScene getScene() {
        return this.scene;
    }

    final PoshPlan getLapTree() {
        return this.lapTree;
    }

    void addNameMapListener(INameMapListener listener) {
        this.nameMapListeners.add(listener);
    }

    void removeNameMapListener(INameMapListener listener) {
        this.nameMapListeners.remove(listener);
    }

    INameMapListener[] getNameMapListener() {
        int nameListenersSize = this.nameMapListeners.size();
        return this.nameMapListeners.toArray(new INameMapListener[nameListenersSize]);
    }

    private void emitNameChange(String key, String oldName, String newName) {
        INameMapListener[] listeners;
        for (INameMapListener listener : listeners = this.getNameMapListener()) {
            listener.nameMapChanged(key, oldName, newName);
        }
    }

    public Set<String> getAllNameMappingKeys() {
        Set<String> keySet = this.nameMap.keySet();
        return Collections.unmodifiableSet(keySet);
    }

    public String getNameMapping(String primitiveName) {
        PrimitiveData record = this.nameMap.get(primitiveName);
        return record != null ? record.name : null;
    }

    public ParamInfo[] getPrimitiveParameters(String key) {
        PrimitiveData record = this.nameMap.get(key);
        if (record == null) {
            return new ParamInfo[0];
        }
        ArrayList params = new ArrayList(record.params);
        Collections.sort(params);
        return params.toArray(new ParamInfo[params.size()]);
    }

    public void setNameMapping(String key, PrimitiveData record) {
        key = key.trim();
        PrimitiveData oldRecord = this.nameMap.get(key);
        this.nameMap.put(key, record);
        this.emitNameChange(key, oldRecord != null ? oldRecord.name : null, record != null ? record.name : null);
    }

    PrimitiveData getMetadata(String name) {
        return this.nameMap.get(name);
    }
}

