/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.widget.editor;

import cz.cuni.amis.pogamut.sposh.elements.Arguments;
import cz.cuni.amis.pogamut.sposh.elements.FormalParameters;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.Result;
import cz.cuni.amis.pogamut.sposh.exceptions.FubarException;
import cz.cuni.pogamut.shed.widget.editor.TableParameter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

class ParametersTableModel
extends AbstractTableModel {
    private final List<TableParameter> variables = new LinkedList<TableParameter>();
    private static final String[] columns = new String[]{"Parameter name", "Default value", "Argument value"};

    public ParametersTableModel(FormalParameters params, Arguments args) {
        for (int paramIndex = 0; paramIndex < params.size(); ++paramIndex) {
            FormalParameters.Parameter param = params.get(paramIndex);
            TableParameter tableParamerter = new TableParameter(param);
            for (Arguments.Argument arg : args) {
                String argumentName = arg.getParameterName();
                if (this.isArgumentNameIndex(argumentName)) {
                    if (this.getArgumentNameIndex(argumentName) != paramIndex) continue;
                    tableParamerter = this.createTableParameter(param, arg);
                    continue;
                }
                if (this.isArgumentNameVariable(argumentName)) {
                    String paramName = param.getName();
                    if (!argumentName.equals(paramName)) continue;
                    tableParamerter = this.createTableParameter(param, arg);
                    continue;
                }
                throw new FubarException("Illegal argument name " + argumentName);
            }
            this.variables.add(tableParamerter);
        }
    }

    private TableParameter createTableParameter(FormalParameters.Parameter param, Arguments.Argument arg) {
        String defaultValueString = Result.toLap((Object)param.getDefaultValue());
        TableParameter tableParameter = arg.getParameterVariable() != null ? new TableParameter(param.getName(), defaultValueString, arg.getParameterVariable()) : new TableParameter(param.getName(), defaultValueString, Result.toLap((Object)arg.getValue()));
        return tableParameter;
    }

    private boolean isArgumentNameIndex(String argumentName) {
        try {
            Integer.parseInt(argumentName);
            return true;
        }
        catch (NumberFormatException ex) {
            return false;
        }
    }

    private int getArgumentNameIndex(String argumentName) {
        int paramterIndex = Integer.parseInt(argumentName);
        return paramterIndex;
    }

    private boolean isArgumentNameVariable(String argumentName) {
        return argumentName.startsWith("$");
    }

    @Override
    public String getColumnName(int column) {
        return columns[column];
    }

    @Override
    public int getColumnCount() {
        return columns.length;
    }

    @Override
    public int getRowCount() {
        return this.variables.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        TableParameter variable = this.variables.get(rowIndex);
        if (columnIndex == 0) {
            return variable.getName();
        }
        if (columnIndex == 1) {
            return variable.getDefaultValueString();
        }
        if (columnIndex == 2) {
            return variable.getArgumentString();
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        return true;
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        TableParameter variable = this.variables.get(rowIndex);
        String valueString = (String)value;
        if (columnIndex == 0) {
            variable.setName(valueString);
        } else if (columnIndex == 1) {
            try {
                variable.setDefaultValueString(valueString);
            }
            catch (ParseException ex) {
                return;
            }
        } else if (columnIndex == 2) {
            try {
                variable.setArgumentValueString(valueString);
            }
            catch (ParseException ex) {
                return;
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    public void deleteVariable(int deleteIndex) {
        this.variables.remove(deleteIndex);
        this.fireTableRowsDeleted(deleteIndex, deleteIndex);
    }

    public void addParameter(int addIndex, String parameterName, Object defaultValue) {
        TableParameter newVariable = new TableParameter(parameterName, Result.toLap((Object)defaultValue));
        this.variables.add(addIndex, newVariable);
        this.fireTableDataChanged();
    }

    public List<TableParameter> getParameters() {
        return Collections.unmodifiableList(this.variables);
    }
}

