/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.widget.editor;

import cz.cuni.amis.pogamut.sposh.elements.Arguments;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.FormalParameters;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.exceptions.CycleException;
import cz.cuni.amis.pogamut.sposh.exceptions.DuplicateNameException;
import cz.cuni.amis.pogamut.sposh.exceptions.InvalidNameException;
import cz.cuni.amis.pogamut.sposh.exceptions.MissingParameterException;
import cz.cuni.pogamut.shed.widget.editor.CEditor;
import cz.cuni.pogamut.shed.widget.editor.TableArgument;
import cz.cuni.pogamut.shed.widget.editor.TableParameter;
import java.awt.Rectangle;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.List;
import org.netbeans.api.visual.action.InplaceEditorProvider;
import org.netbeans.api.visual.widget.Widget;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;

public final class CEditorProvider
implements InplaceEditorProvider<CEditor> {
    private final Competence competence;
    private final TriggeredAction referencingAction;

    public CEditorProvider(Competence competence, TriggeredAction referencingAction) {
        this.competence = competence;
        this.referencingAction = referencingAction;
    }

    public void notifyOpened(InplaceEditorProvider.EditorController ec, Widget widget, CEditor c) {
    }

    private void notify(String message) {
        NotifyDescriptor.Message infoMessage = new NotifyDescriptor.Message((Object)message, 1);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)infoMessage);
    }

    public void notifyClosing(InplaceEditorProvider.EditorController ec, Widget widget, CEditor editor, boolean commit) {
        if (commit) {
            String newCName;
            String oldCName = this.competence.getName();
            if (!oldCName.equals(newCName = editor.getElementName())) {
                String errorMessage;
                try {
                    this.competence.rename(newCName);
                }
                catch (InvalidNameException ex) {
                    errorMessage = MessageFormat.format("Name \"{0}\" is not valid", newCName);
                    this.notify(errorMessage);
                }
                catch (CycleException ex) {
                    errorMessage = MessageFormat.format("Changing name to \"{0}\" would cause a cycle.", newCName);
                    this.notify(errorMessage);
                }
                catch (DuplicateNameException ex) {
                    errorMessage = MessageFormat.format("Name \"{0}\" is already used.", newCName);
                    this.notify(errorMessage);
                }
            }
            List<TableParameter> editorParams = editor.getParameters();
            FormalParameters newParams = new FormalParameters();
            for (TableParameter editorParam : editorParams) {
                newParams.add((Object)new FormalParameters.Parameter(editorParam.getName(), editorParam.getDefaultValue()));
            }
            try {
                this.competence.setParameters(newParams);
            }
            catch (MissingParameterException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            List<TableArgument> editorArgs = editor.getArguments();
            Arguments newArgs = new Arguments();
            for (TableArgument editorArg : editorArgs) {
                newArgs.add((Object)editorArg.createArgument());
            }
            for (TableParameter editorParam : editorParams) {
                if (!editorParam.isOverriden()) continue;
                newArgs.add((Object)editorParam.createOverrideArgument());
            }
            this.referencingAction.setArguments(newArgs);
        }
    }

    public CEditor createEditorComponent(InplaceEditorProvider.EditorController controller, Widget widget) {
        CEditor editor = new CEditor(this.competence, this.referencingAction, controller);
        return editor;
    }

    public Rectangle getInitialEditorComponentBounds(InplaceEditorProvider.EditorController controller, Widget widget, CEditor editor, Rectangle viewBounds) {
        return null;
    }

    public EnumSet<InplaceEditorProvider.ExpansionDirection> getExpansionDirections(InplaceEditorProvider.EditorController ec, Widget widget, CEditor c) {
        return EnumSet.of(InplaceEditorProvider.ExpansionDirection.BOTTOM, InplaceEditorProvider.ExpansionDirection.RIGHT);
    }
}

