/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.explorer;

import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.LapElementsFactory;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.exceptions.DuplicateNameException;
import cz.cuni.amis.pogamut.sposh.exceptions.FubarException;
import cz.cuni.pogamut.posh.explorer.Crawler;
import cz.cuni.pogamut.posh.explorer.ElementExplorer;
import cz.cuni.pogamut.posh.explorer.PGSupport;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import org.openide.util.datatransfer.ExTransferable;

final class CompetenceExplorer
extends ElementExplorer<Competence> {
    CompetenceExplorer(Crawler<Competence> crawler, PoshPlan plan) {
        super(crawler, plan);
    }

    @Override
    protected String getNewItemLabel() {
        return "New competence (drag and drop)";
    }

    @Override
    protected Transferable createNewItemTransferable() {
        return new ExTransferable.Single(Competence.dataFlavor){

            protected Object getData() throws IOException, UnsupportedFlavorException {
                String competenceName = PGSupport.getIdentifierFromDialog("Name of competence");
                if (competenceName == null) {
                    return null;
                }
                String elementName = PGSupport.getIdentifierFromDialog("Name of competence atom");
                if (elementName == null) {
                    return null;
                }
                try {
                    return LapElementsFactory.createCompetence((String)competenceName, (String[])new String[]{elementName});
                }
                catch (DuplicateNameException ex) {
                    throw new FubarException("Creating new competence with only one name, what duplicate?", (Throwable)ex);
                }
            }
        };
    }

    @Override
    protected void deleteItem(Competence competence) {
        boolean confirmed = PGSupport.confirm("Are you sure you want to delete competence " + competence.getName());
        if (confirmed) {
            this.plan.removeCompetence(competence);
        }
    }

    @Override
    protected String getItemDescription(Competence competence) {
        return "<html>Competence: " + competence.getName() + "<br/><pre>" + competence.toString() + "</pre></html>";
    }
}

