/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.widget.editor;

import cz.cuni.amis.pogamut.sposh.elements.Arguments;
import cz.cuni.amis.pogamut.sposh.elements.FormalParameters;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.exceptions.FubarException;
import cz.cuni.pogamut.shed.widget.editor.TableArgument;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.swing.table.AbstractTableModel;

class ArgumentsTableModel
extends AbstractTableModel {
    private final List<TableArgument> arguments = new LinkedList<TableArgument>();
    private static final String[] columns = new String[]{"Argument name", "Value"};

    public ArgumentsTableModel(FormalParameters params, Arguments args) {
        for (Arguments.Argument arg : args) {
            String argName = arg.getParameterName();
            if (!argName.startsWith("$")) continue;
            boolean argOverridesParam = false;
            for (FormalParameters.Parameter param : params) {
                String paramName = param.getName();
                if (!paramName.equals(argName)) continue;
                argOverridesParam = true;
            }
            if (argOverridesParam) continue;
            this.arguments.add(new TableArgument(arg));
        }
    }

    @Override
    public int getRowCount() {
        return this.arguments.size();
    }

    @Override
    public String getColumnName(int column) {
        return columns[column];
    }

    @Override
    public int getColumnCount() {
        return columns.length;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return true;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            return this.arguments.get(rowIndex).getName();
        }
        if (columnIndex == 1) {
            return this.arguments.get(rowIndex).getValueString();
        }
        throw new FubarException("Unexpected column index " + columnIndex);
    }

    @Override
    public void setValueAt(Object value, int rowIndex, int columnIndex) {
        TableArgument argument = this.arguments.get(rowIndex);
        String valueString = (String)value;
        if (columnIndex == 0) {
            argument.setName(valueString);
        } else if (columnIndex == 1) {
            try {
                argument.setValueString(valueString);
            }
            catch (ParseException ex) {
                return;
            }
        } else {
            throw new FubarException("Unexpected position " + rowIndex + " " + columnIndex);
        }
        this.fireTableCellUpdated(rowIndex, columnIndex);
    }

    public void deleteArgument(int deleteIndex) {
        this.arguments.remove(deleteIndex);
        this.fireTableRowsDeleted(deleteIndex, deleteIndex);
    }

    public void addArgument(int addIndex, String argName, Object value) {
        TableArgument newVariable = new TableArgument(argName, value);
        this.arguments.add(addIndex, newVariable);
        this.fireTableDataChanged();
    }

    public List<TableArgument> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }
}

