/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.presenter;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.FormalParameters;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshParser;
import cz.cuni.amis.pogamut.sposh.elements.PrimitiveCall;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.exceptions.CycleException;
import cz.cuni.amis.pogamut.sposh.exceptions.DuplicateNameException;
import cz.cuni.amis.pogamut.sposh.exceptions.InvalidNameException;
import cz.cuni.pogamut.shed.widget.editor.APEditorProvider;
import cz.cuni.pogamut.shed.widget.editor.CEditorProvider;
import java.io.Reader;
import java.io.StringReader;
import java.text.MessageFormat;
import org.netbeans.api.visual.action.InplaceEditorProvider;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.widget.Widget;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;

public class ShedInplaceEditorFactory {
    public static TextFieldInplaceEditor createSenseEditor(Sense sense) {
        return new SenseInplaceEditor(sense);
    }

    public static TextFieldInplaceEditor createDriveEditor(DriveElement drive) {
        return new DriveInplaceEditor(drive);
    }

    public static TextFieldInplaceEditor createActionEditor(TriggeredAction action) {
        return new ActionInplaceEditor(action);
    }

    public static TextFieldInplaceEditor createChoiceEditor(CompetenceElement choice) {
        return new ChoiceInplaceEditor(choice);
    }

    public static InplaceEditorProvider createActionPatternEditor(ActionPattern actionPattern, TriggeredAction referencingAction) {
        assert (actionPattern.getName().equals(referencingAction.getName()));
        return new APEditorProvider(actionPattern, referencingAction);
    }

    public static InplaceEditorProvider createCompetenceEditor(Competence competence, TriggeredAction referencingAction) {
        assert (competence.getName().equals(referencingAction.getName()));
        return new CEditorProvider(competence, referencingAction);
    }

    private static class ChoiceInplaceEditor
    implements TextFieldInplaceEditor {
        private final CompetenceElement choice;

        public ChoiceInplaceEditor(CompetenceElement choice) {
            this.choice = choice;
        }

        public boolean isEnabled(Widget widget) {
            return true;
        }

        public String getText(Widget widget) {
            return this.choice.getName();
        }

        private void notify(String message) {
            NotifyDescriptor.Message infoMessage = new NotifyDescriptor.Message((Object)message, 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)infoMessage);
        }

        public void setText(Widget widget, String newChoiceName) {
            try {
                this.choice.setName(newChoiceName);
            }
            catch (DuplicateNameException ex) {
                String message = MessageFormat.format("Choice name \"{0}\" already exists.", newChoiceName);
                this.notify(message);
            }
            catch (InvalidNameException ex) {
                String message = MessageFormat.format("Choice name \"{0}\" is not valid.", newChoiceName);
                this.notify(message);
            }
        }
    }

    private static class DriveInplaceEditor
    implements TextFieldInplaceEditor {
        private final DriveElement drive;

        public DriveInplaceEditor(DriveElement drive) {
            this.drive = drive;
        }

        public boolean isEnabled(Widget widget) {
            return true;
        }

        public String getText(Widget widget) {
            return this.drive.getName();
        }

        private void notify(String message) {
            NotifyDescriptor.Message infoMessage = new NotifyDescriptor.Message((Object)message, 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)infoMessage);
        }

        public void setText(Widget widget, String newDriveName) {
            try {
                this.drive.setDriveName(newDriveName);
            }
            catch (DuplicateNameException ex) {
                String message = MessageFormat.format("Drive with name \"{0}\" is already present.", newDriveName);
                this.notify(message);
            }
            catch (InvalidNameException ex) {
                String message = MessageFormat.format("Drive name \"{0}\" is not valid.", newDriveName);
                this.notify(message);
            }
        }
    }

    private static class SenseInplaceEditor
    implements TextFieldInplaceEditor {
        private final Sense sense;

        private SenseInplaceEditor(Sense sense) {
            this.sense = sense;
        }

        public boolean isEnabled(Widget widget) {
            return true;
        }

        public String getText(Widget widget) {
            String senseCall = this.sense.getSenseCall().toString();
            if (this.sense.getOperand() == Boolean.TRUE && this.sense.getPredicate() == Sense.Predicate.DEFAULT) {
                return senseCall;
            }
            String value = this.sense.getValueString();
            String predicate = this.sense.getPredicate().toString();
            return senseCall + ' ' + value + ' ' + predicate;
        }

        private void notify(String message) {
            NotifyDescriptor.Message infoMessage = new NotifyDescriptor.Message((Object)message, 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)infoMessage);
        }

        public void setText(Widget widget, String newSense) {
            try {
                this.sense.parseSense(newSense);
            }
            catch (ParseException ex) {
                String errorMessage = MessageFormat.format("Unable to parse the sense \"{0}\".\nError message: {1}.", newSense, ex.getMessage());
                this.notify(errorMessage);
            }
        }
    }

    private static class ActionInplaceEditor
    implements TextFieldInplaceEditor {
        private final TriggeredAction action;

        ActionInplaceEditor(TriggeredAction action) {
            this.action = action;
        }

        public boolean isEnabled(Widget widget) {
            return true;
        }

        public String getText(Widget widget) {
            return this.action.toString();
        }

        private void notify(String message) {
            NotifyDescriptor.Message infoMessage = new NotifyDescriptor.Message((Object)message, 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)infoMessage);
        }

        private FormalParameters getParameters() {
            PoshElement parent = this.action.getParent();
            assert (parent != null) : "I should never use variables in node that is not part of element";
            if (parent instanceof ActionPattern) {
                ActionPattern ap = (ActionPattern)parent;
                return ap.getParameters();
            }
            if (parent instanceof DriveElement) {
                return new FormalParameters();
            }
            if (parent instanceof CompetenceElement) {
                CompetenceElement cel = (CompetenceElement)parent;
                Competence competence = (Competence)cel.getParent();
                return competence.getParameters();
            }
            throw new IllegalStateException("Unexpected parent: " + parent.getClass().getCanonicalName());
        }

        private PrimitiveCall parseActionCall(String text) throws ParseException {
            PoshParser parser = new PoshParser((Reader)new StringReader(text));
            return parser.senseCall(this.getParameters());
        }

        public void setText(Widget widget, String input) {
            try {
                PrimitiveCall call = this.parseActionCall(input);
                this.action.setActionName(call.getName());
                this.action.setArguments(call.getParameters());
            }
            catch (InvalidNameException ex) {
                String errorMessage = MessageFormat.format("Action name \"{0}\" is not valid", input);
                this.notify(errorMessage);
            }
            catch (CycleException ex) {
                String errorMessage = MessageFormat.format("Action referencing to \"{0}\" would cause a cycle.", input);
                this.notify(errorMessage);
            }
            catch (ParseException ex) {
                String errorMessage = MessageFormat.format("Unable to parse input \"{0}\".\nError message: {1}", input, ex.getMessage());
                this.notify(errorMessage);
            }
        }
    }
}

