/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.shed.presenter;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.DriveCollection;
import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.LapElementsFactory;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.PoshPlan;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.Trigger;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.amis.pogamut.sposh.exceptions.CycleException;
import cz.cuni.amis.pogamut.sposh.exceptions.DuplicateNameException;
import cz.cuni.amis.pogamut.sposh.exceptions.FubarException;
import cz.cuni.amis.pogamut.sposh.exceptions.InvalidNameException;
import cz.cuni.pogamut.posh.widget.accept.AbstractAcceptAction;
import java.text.MessageFormat;

public class AcceptActionFactory {
    public static AbstractAcceptAction<Sense, DriveElement> createSense2Drive(DriveElement drive) {
        return new DriveAppendSenseAcceptAction(drive);
    }

    public static AbstractAcceptAction<Sense, Sense> createSense2Sense(Sense sense) {
        return new InsertSenseAcceptAction(sense);
    }

    public static AbstractAcceptAction<DriveElement, DriveElement> createDrive2Drive(DriveElement drive) {
        return new InsertDriveAcceptAction(drive);
    }

    public static AbstractAcceptAction<CompetenceElement, CompetenceElement> createChoice2Choice(CompetenceElement targetChoice) {
        return new InsertChoiceAcceptAction(targetChoice);
    }

    public static AbstractAcceptAction<Competence, TriggeredAction> createCompetence2Action(TriggeredAction targetAction) {
        return new CompetenceAcceptAction(targetAction);
    }

    public static AbstractAcceptAction<ActionPattern, TriggeredAction> createActionPatternAction(TriggeredAction targetAction) {
        return new ActionPatternAcceptAction(targetAction);
    }

    public static AbstractAcceptAction createAction2Action(TriggeredAction action) {
        return new ActionAcceptAction(action);
    }

    public static AbstractAcceptAction createSense2Choice(CompetenceElement targetChoice) {
        return new ChoiceAppendSenseAcceptAction(targetChoice);
    }

    private static class ChoiceAppendSenseAcceptAction
    extends AbstractAcceptAction<Sense, CompetenceElement> {
        public ChoiceAppendSenseAcceptAction(CompetenceElement targetChoice) {
            super(Sense.dataFlavor, targetChoice);
        }

        @Override
        public void performAction(Sense droppedSense) {
            PoshElement senseParent = droppedSense.getParent();
            if (senseParent != null) {
                droppedSense.removeFromParent();
            }
            ((CompetenceElement)this.dataNode).getTrigger().add(0, droppedSense);
        }
    }

    private static class ActionAcceptAction
    extends AbstractAcceptAction<TriggeredAction, TriggeredAction> {
        public ActionAcceptAction(TriggeredAction targetAction) {
            super(TriggeredAction.dataFlavor, targetAction);
        }

        @Override
        public void performAction(TriggeredAction droppedAction) {
            boolean actionMoveInAP;
            PoshElement droppedParent = droppedAction.getParent();
            boolean droppedFromAP = droppedParent instanceof ActionPattern;
            boolean droppedFromCE = droppedParent instanceof CompetenceElement;
            boolean droppedFromDE = droppedParent instanceof DriveElement;
            boolean droppedFromNowhere = droppedParent == null;
            PoshElement targetParent = ((TriggeredAction)this.dataNode).getParent();
            boolean targetInAP = ((TriggeredAction)this.dataNode).getParent() instanceof ActionPattern;
            boolean bl = actionMoveInAP = droppedFromAP && targetInAP && droppedParent == targetParent;
            if (actionMoveInAP) {
                ActionPattern actionPattern = (ActionPattern)((TriggeredAction)this.dataNode).getParent();
                int targetIndex = actionPattern.getChildDataNodes().indexOf(this.dataNode);
                actionPattern.moveChild(targetIndex, (PoshElement)droppedAction);
            } else if (droppedFromAP) {
                ActionPattern droppedActionPattern = (ActionPattern)droppedParent;
                droppedActionPattern.removeAction(droppedAction);
                try {
                    this.placeDroppedAction(droppedAction);
                }
                catch (CycleException ex) {
                    throw new FubarException("Cycle should never happen when dropping an action from AP. Report.", (Throwable)ex);
                }
            } else if (droppedFromCE || droppedFromDE || droppedFromNowhere) {
                try {
                    this.placeDroppedAction(droppedAction);
                }
                catch (CycleException ex) {
                    String errorMessage = MessageFormat.format("Referencing \"{0}\" would cause a cycle.", droppedAction.getName());
                    this.displayMessage(errorMessage, 0);
                }
            } else {
                throw new IllegalArgumentException("Unknown dropped parent " + droppedParent.getClass());
            }
        }

        private void placeDroppedAction(TriggeredAction droppedAction) throws CycleException {
            PoshElement targetParent = ((TriggeredAction)this.dataNode).getParent();
            boolean targetInAP = targetParent instanceof ActionPattern;
            boolean targetInCE = targetParent instanceof CompetenceElement;
            boolean targetInDE = targetParent instanceof DriveElement;
            if (targetInCE || targetInDE) {
                ((TriggeredAction)this.dataNode).synchronize(droppedAction);
            } else if (targetInAP) {
                ActionPattern targetActionPattern = (ActionPattern)targetParent;
                int targetIndex = targetActionPattern.getActions().indexOf(this.dataNode);
                TriggeredAction droppedActionCopy = LapElementsFactory.createAction((TriggeredAction)droppedAction);
                targetActionPattern.addAction(targetIndex, droppedActionCopy);
            } else {
                throw new IllegalArgumentException("Unknown target parent " + ((TriggeredAction)this.dataNode).getClass());
            }
        }
    }

    private static class ActionPatternAcceptAction
    extends AbstractAcceptAction<ActionPattern, TriggeredAction> {
        public ActionPatternAcceptAction(TriggeredAction targetAction) {
            super(ActionPattern.dataFlavor, targetAction);
        }

        @Override
        public void performAction(ActionPattern droppedActionPattern) {
            String actionPatternName = droppedActionPattern.getName();
            PoshPlan lapTree = ((TriggeredAction)this.dataNode).getRootNode();
            if (droppedActionPattern.getParent() == null) {
                try {
                    lapTree.addActionPattern(droppedActionPattern);
                }
                catch (DuplicateNameException ex) {
                    String errorMessage = MessageFormat.format("Action pattern with name \"{0}\" is already present in the plan.", actionPatternName);
                    this.displayMessage(errorMessage, 0);
                    return;
                }
                catch (CycleException ex) {
                    String errorMessage = MessageFormat.format("Adding an action pattern with name \"{0}\" would create a cycle.", actionPatternName);
                    this.displayMessage(errorMessage, 0);
                    return;
                }
            } else {
                assert (droppedActionPattern.getParent() == lapTree);
                assert (lapTree.getAP(actionPatternName) == droppedActionPattern);
            }
            try {
                ((TriggeredAction)this.dataNode).setActionName(actionPatternName);
            }
            catch (InvalidNameException ex) {
                String errorMessage = MessageFormat.format("Action can't have name \"{0}\", but the action pattern has it. This seriously shouldn't happen. Report.", actionPatternName);
                this.displayMessage(errorMessage, 0);
            }
            catch (CycleException ex) {
                String errorMessage = MessageFormat.format("Referencing the action pattern with name \"{0}\" would create a cycle.", actionPatternName);
                this.displayMessage(errorMessage, 0);
            }
        }
    }

    private static class CompetenceAcceptAction
    extends AbstractAcceptAction<Competence, TriggeredAction> {
        public CompetenceAcceptAction(TriggeredAction targetAction) {
            super(Competence.dataFlavor, targetAction);
        }

        @Override
        public void performAction(Competence droppedCompetence) {
            String competenceName = droppedCompetence.getName();
            PoshPlan lapTree = ((TriggeredAction)this.dataNode).getRootNode();
            if (droppedCompetence.getParent() == null) {
                try {
                    lapTree.addCompetence(droppedCompetence);
                }
                catch (DuplicateNameException ex) {
                    String errorMessage = MessageFormat.format("Competence with name \"{0}\" is already present in the plan.", competenceName);
                    this.displayMessage(errorMessage, 0);
                    return;
                }
                catch (CycleException ex) {
                    String errorMessage = MessageFormat.format("Adding a competence with name \"{0}\" would create a cycle.", competenceName);
                    this.displayMessage(errorMessage, 0);
                    return;
                }
            } else {
                assert (droppedCompetence.getParent() == lapTree);
                assert (lapTree.getC(competenceName) == droppedCompetence);
            }
            try {
                ((TriggeredAction)this.dataNode).setActionName(competenceName);
            }
            catch (InvalidNameException ex) {
                String errorMessage = MessageFormat.format("Action can't have name \"{0}\", but the competence has it. This seriously shouldn't happen. Report.", competenceName);
                this.displayMessage(errorMessage, 0);
            }
            catch (CycleException ex) {
                String errorMessage = MessageFormat.format("Referencing the competence with name \"{0}\" would create a cycle.", competenceName);
                this.displayMessage(errorMessage, 0);
            }
        }
    }

    private static class InsertChoiceAcceptAction
    extends AbstractAcceptAction<CompetenceElement, CompetenceElement> {
        public InsertChoiceAcceptAction(CompetenceElement targetChoice) {
            super(CompetenceElement.dataFlavor, targetChoice);
        }

        @Override
        public void performAction(CompetenceElement droppedChoice) {
            Competence droppedCompetence = (Competence)droppedChoice.getParent();
            Competence targetCompetence = (Competence)((CompetenceElement)this.dataNode).getParent();
            int targetIndex = targetCompetence.getChildDataNodes().indexOf(this.dataNode);
            if (droppedCompetence == targetCompetence) {
                targetCompetence.moveChild(targetIndex, (PoshElement)droppedChoice);
            } else {
                String droppedChoiceName = droppedChoice.getName();
                if (this.choiceNameIsUsed(targetCompetence, droppedChoiceName)) {
                    String errorMessage = MessageFormat.format("Choice with name \"{0}\" is already present in the competence \"{1}\"", droppedChoiceName, targetCompetence.getName());
                    this.displayMessage(errorMessage, 0);
                    return;
                }
                droppedCompetence.removeElement(droppedChoice);
                try {
                    targetCompetence.addElement(targetIndex, droppedChoice);
                }
                catch (DuplicateNameException ex) {
                    throw new FubarException("Thgis is checked before.", (Throwable)ex);
                }
            }
        }

        private boolean choiceNameIsUsed(Competence testedCompetence, String name) {
            for (CompetenceElement choice : testedCompetence.getChildDataNodes()) {
                if (!choice.getName().equals(name)) continue;
                return true;
            }
            return false;
        }
    }

    private static class InsertDriveAcceptAction
    extends AbstractAcceptAction<DriveElement, DriveElement> {
        public InsertDriveAcceptAction(DriveElement drive) {
            super(DriveElement.dataFlavor, drive);
        }

        @Override
        public void performAction(DriveElement droppedDrive) {
            DriveCollection droppedDC = (DriveCollection)droppedDrive.getParent();
            DriveCollection targetDC = (DriveCollection)((DriveElement)this.dataNode).getParent();
            assert (droppedDC == targetDC);
            int targetIndex = targetDC.getDrives().indexOf(this.dataNode);
            targetDC.moveChild(targetIndex, (PoshElement)droppedDrive);
        }
    }

    private static class InsertSenseAcceptAction
    extends AbstractAcceptAction<Sense, Sense> {
        private InsertSenseAcceptAction(Sense sense) {
            super(Sense.dataFlavor, sense);
        }

        @Override
        public void performAction(Sense droppedSense) {
            PoshElement targetSenseParent;
            PoshElement droppedSenseParent = droppedSense.getParent();
            if (droppedSenseParent == (targetSenseParent = ((Sense)this.dataNode).getParent())) {
                int targetIndex = ((Sense)this.dataNode).getTrigger().indexOf((Object)this.dataNode);
                Trigger targetTrigger = ((Sense)this.dataNode).getTrigger();
                targetTrigger.moveSense(targetIndex, droppedSense);
            } else if (droppedSenseParent == null) {
                Trigger targetTrigger = ((Sense)this.dataNode).getTrigger();
                int targetIndex = targetTrigger.indexOf((Object)this.dataNode);
                targetTrigger.add(targetIndex, droppedSense);
            } else {
                droppedSense.getTrigger().remove((Object)droppedSense);
                Trigger targetTrigger = ((Sense)this.dataNode).getTrigger();
                int targetIndex = targetTrigger.indexOf((Object)this.dataNode);
                targetTrigger.add(targetIndex, droppedSense);
            }
        }
    }

    private static class DriveAppendSenseAcceptAction
    extends AbstractAcceptAction<Sense, DriveElement> {
        public DriveAppendSenseAcceptAction(DriveElement targetDrive) {
            super(Sense.dataFlavor, targetDrive);
        }

        @Override
        public void performAction(Sense droppedSense) {
            PoshElement senseParent = droppedSense.getParent();
            if (senseParent != null) {
                droppedSense.removeFromParent();
            }
            ((DriveElement)this.dataNode).getTrigger().add(0, droppedSense);
        }
    }
}

