/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.explorer;

import cz.cuni.pogamut.posh.explorer.Crawler;
import cz.cuni.pogamut.posh.explorer.Explorer;
import cz.cuni.pogamut.posh.explorer.PGSupport;
import cz.cuni.pogamut.posh.explorer.PrimitiveData;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;

abstract class Explorers
extends Explorer<PrimitiveData> {
    protected Explorers(Crawler<PrimitiveData> crawler) {
        super(crawler);
    }

    @Override
    public boolean filter(String query, boolean caseSensitive, PrimitiveData item) {
        if (item.classFQN.contains(query)) {
            return false;
        }
        if (item.name != null && item.name.contains(query)) {
            return false;
        }
        for (String tag : item.tags) {
            if (!tag.contains(query)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected String getRenderedLabel(PrimitiveData item) {
        return (item.name != null ? item.name : item.classFQN.replaceFirst("^.*\\.", "")) + "(" + item.classFQN + ")";
    }

    @Override
    protected String getItemDescription(PrimitiveData item) {
        StringBuilder info = new StringBuilder();
        info.append("<html>Class: ");
        info.append(item.classFQN);
        if (item.name != null) {
            info.append("<br/>Name: ");
            info.append(item.name);
        }
        if (item.description != null) {
            info.append("<br/>Description: ");
            info.append(item.description);
        }
        if (item.tags.length > 0) {
            info.append("<br/>Tags: ");
            for (int tagIndex = 0; tagIndex < item.tags.length; ++tagIndex) {
                info.append(item.tags[tagIndex]);
                if (tagIndex == item.tags.length - 1) continue;
                info.append(',');
                info.append(' ');
            }
        }
        info.append("</html>");
        return info.toString();
    }

    @Override
    protected void displayItem(PrimitiveData item) {
        String javaFilePath = item.classFQN.replace('.', '/') + ".java";
        for (FileObject curRoot : GlobalPathRegistry.getDefault().getSourceRoots()) {
            EditorCookie ec;
            FileObject fileObject = curRoot.getFileObject(javaFilePath);
            if (fileObject == null) continue;
            DataObject dobj = null;
            try {
                dobj = DataObject.find((FileObject)fileObject);
            }
            catch (DataObjectNotFoundException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (dobj == null || (ec = (EditorCookie)dobj.getCookie(EditorCookie.class)) == null) continue;
            ec.open();
        }
    }

    @Override
    protected void deleteItem(PrimitiveData item) {
        PGSupport.message("Primitives can't be deleted this way, you have to delete the class in the project and press refresh.");
    }
}

