package cz.cuni.pogamut.shed.view;

import cz.cuni.pogamut.posh.PoshDataObject;
import java.awt.Image;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewElement;
import org.openide.util.HelpCtx;
import org.openide.windows.TopComponent;

/**
 * Basically a factory for creation of {@link LapTreeMVElement}.
 *
 * @author HonzaH
 */
public class LapTreeViewDesc implements MultiViewDescription {

    /**
     * Data object this the MVE should modify.
     */
    private final PoshDataObject dObj;

    public LapTreeViewDesc(PoshDataObject dObj) {
        this.dObj = dObj;
    }

    @Override
    public int getPersistenceType() {
        return TopComponent.PERSISTENCE_NEVER;
    }

    @Override
    public String getDisplayName() {
        return "Visual";
    }

    @Override
    public Image getIcon() {
        return null;
    }

    @Override
    public HelpCtx getHelpCtx() {
        return null;
    }

    @Override
    public String preferredID() {
        return "lap_tree_view" + dObj.getPrimaryFile().getPath();
    }

    @Override
    public MultiViewElement createElement() {
        return new LapTreeMVElement(dObj);
    }
}
