package cz.cuni.pogamut.shed.presenter;

import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.Competence;
import cz.cuni.amis.pogamut.sposh.elements.CompetenceElement;
import cz.cuni.amis.pogamut.sposh.elements.DriveCollection;
import cz.cuni.amis.pogamut.sposh.elements.DriveElement;
import cz.cuni.amis.pogamut.sposh.elements.LapChain;
import cz.cuni.amis.pogamut.sposh.elements.LapPath;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.Sense;
import cz.cuni.amis.pogamut.sposh.elements.Trigger;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.pogamut.shed.widget.ExpandedActionEnvelope;
import cz.cuni.pogamut.shed.widget.ShedActionsEnvelope;
import cz.cuni.pogamut.shed.widget.ShedChoiceEnvelope;
import cz.cuni.pogamut.shed.widget.ShedChoicesEnvelope;
import cz.cuni.pogamut.shed.widget.ShedSenseWidget;
import cz.cuni.pogamut.shed.widget.ShedTriggerEnvelope;
import cz.cuni.pogamut.shed.widget.ShedVariableWidget;
import cz.cuni.pogamut.shed.widget.ShedWidget;

/**
 * Interface for presenters of widgets. Presenters are responsible for
 * displaying changes of posh elements into the widgets.
 *
 * TODO: Once done with paths + checked, remove obsolete chain and eleemnts
 * parameters.
 *
 * Be careful when implementing the presenters, you can't store {@link LapPath}
 * in them, because stuff can move around.
 *
 * @author Honza
 */
public interface IPresenterFactory {

    /**
     * Create presenter for primitive action. It doesn;t have any children.
     */
    IPresenter createActionPresenter(LapPath actionPath, TriggeredAction action, ShedVariableWidget actionWidget, LapChain actionChain);

    // TODO: Is this even used? I can't seem to find any reference. Check and possibly remove.
    IPresenter createExpandedActionPresenter(TriggeredAction action, ExpandedActionEnvelope envelope, LapChain chain);

    /**
     * Create presenter for sense at @sensePath that will present the sense in
     * the @senseWidget.
     */
    IPresenter createSensePresenter(LapPath sensePath, Sense sense, ShedSenseWidget senseWidget, LapChain senseChain);

    /**
     * Create presenter for trigger, it is responsible for keepeing track of
     * added/moved/removed senses.
     *
     * @param parentChain Chain of the parent.
     * @return
     */
    <TRIGGER_PARENT extends PoshElement> IPresenter createTriggerPresenter(TRIGGER_PARENT parent, Trigger<TRIGGER_PARENT> trigger, ShedTriggerEnvelope triggerEnvelope, LapChain parentChain);

    IPresenter createDriveCollectionPresenter(LapPath driveCollectionPath, DriveCollection driveCollection);

    /**
     * Create presenter for action pattern widget. This doesn't affect anything
     * else(APs actions...), only the actionPatternWidget. The presenter should
     * update widget when its properties, e.g.g parameters are changed.
     *
     * @param actionPatternPath Path to the action pattern, path ends with
     * <tt>../A:?/AP:?</tt>
     */
    IPresenter createActionPatternPresenter(LapPath actionPatternPath, TriggeredAction referencingAction, ActionPattern actionPattern, ShedVariableWidget actionPatternWidget, LapChain chain);

    /**
     * Create presenter for competence widget. The presenter is responsible only
     * for the widget of competence, not for its choices ect. It should for
     * example update the widget when arguments or parameters of link are
     * changed.
     *
     * @param competencePath Path to the competence, path ends with
     * <tt>../A:?/C:?</tt>
     */
    IPresenter createCompetencePresenter(LapPath competencePath, TriggeredAction referencingAction, Competence competence, ShedVariableWidget competenceWidget, LapChain chain);

    /**
     * Create presenter for choice widget, only the widget, not its trigger nor
     * action. Basically it is responsible only for showing changes of choice
     * name in the widget.
     *
     * @param choicePath Path to the choice, it will end with
     * <tt>../A:?/C:?/CE:?</tt>
     */
    IPresenter createChoicePresenter(LapPath choicePath, CompetenceElement choice, ShedVariableWidget choiceWidget);

    /**
     * Create presenter for drive widget. It reflects only changes of drive
     * widget, not its trigger or action. Overall it only reflects chganges of
     * name.
     *
     * @param drivePath Path to drive, <tt>../DE:?</tt>
     */
    IPresenter createDrivePresenter(LapPath drivePath, DriveElement drive, ShedVariableWidget widget);

    /**
     * Create presenter that will take care about keeping adding/moving/removing
     * expanded actions in the {@link ShedActionsEnvelope} for {@link ActionPattern}.
     *
     * @param actionPatternPath Path to the action pattern, ends with
     * <tt>../AP:?</tt>.
     * @param actionPatternChain Chain to the @actionPattern of the actions.
     */
    IPresenter createActionsPresenter(LapPath actionPatternPath, ActionPattern actionPattern, ShedActionsEnvelope actionsEnvelope, LapChain actionPatternChainchain);

    /**
     * Create presenter responsible for adding, moving and removing {@link ShedChoiceEnvelope choices widgets}
     * in the {@link ShedChoicesEnvelope}.
     *
     * @param competencePath Path to the competence whose choices are managed.
     * Ends with <tt>../A:?/C:?</tt>.
     * @param competenceChain Chain to the @competence.
     */
    IPresenter createChoicesPresenter(LapPath competencePath, Competence competence, ShedChoicesEnvelope choicesEnvelope, LapChain competenceChainchain);
}
