/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.pogamut.posh.widget.accept;

import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.pogamut.posh.widget.PoshWidget;
import java.awt.Point;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.api.visual.action.AcceptProvider;
import org.netbeans.api.visual.action.ConnectorState;
import org.netbeans.api.visual.widget.Widget;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;

public abstract class AbstractAcceptAction<DROPPED extends PoshElement, TARGET extends PoshElement>
implements AcceptProvider {
    protected DataFlavor dataFlavor;
    protected TARGET dataNode;
    protected PoshWidget widget;
    protected static final Logger log = Logger.getLogger("AcceptAction");

    protected AbstractAcceptAction(DataFlavor dataFlavor, TARGET dataNode, PoshWidget widget) {
        this.dataFlavor = dataFlavor;
        this.dataNode = dataNode;
        this.widget = widget;
    }

    protected AbstractAcceptAction(DataFlavor dataFlavor, TARGET dataNode) {
        this(dataFlavor, dataNode, null);
    }

    public final ConnectorState isAcceptable(Widget arg0, Point arg1, Transferable transferable) {
        if (transferable.isDataFlavorSupported(this.dataFlavor)) {
            return ConnectorState.ACCEPT;
        }
        return ConnectorState.REJECT;
    }

    public final void accept(Widget widget, Point point, Transferable transferable) {
        try {
            PoshElement droppedData = (PoshElement)transferable.getTransferData(this.dataFlavor);
            if (droppedData != null) {
                this.performAction(droppedData);
            } else {
                StringBuilder sb = new StringBuilder();
                for (DataFlavor flavor : transferable.getTransferDataFlavors()) {
                    sb.append(' ');
                    sb.append(flavor);
                }
                log.warning("Recived transferable (flavor:" + sb + ") with an empty payload.");
            }
        }
        catch (UnsupportedFlavorException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    public final DataFlavor getDataFlavor() {
        return this.dataFlavor;
    }

    protected abstract void performAction(DROPPED var1);

    protected final int getIndexInList(List list, Object o) {
        int newlyAddedSenseIndex = 0;
        int index = 0;
        for (Object n : list) {
            if (n == o) {
                newlyAddedSenseIndex = index;
            }
            ++index;
        }
        return newlyAddedSenseIndex;
    }

    protected final void displayMessage(String message, int messageType) {
        NotifyDescriptor.Message error = new NotifyDescriptor.Message((Object)message, messageType);
        DialogDisplayer.getDefault().notify((NotifyDescriptor)error);
    }
}

