package cz.cuni.pogamut.posh.widget.kidview;

import cz.cuni.amis.pogamut.sposh.PoshTreeEvent;
import cz.cuni.amis.pogamut.sposh.elements.ActionPattern;
import cz.cuni.amis.pogamut.sposh.elements.ParseException;
import cz.cuni.amis.pogamut.sposh.elements.PoshElement;
import cz.cuni.amis.pogamut.sposh.elements.SolTime;
import cz.cuni.amis.pogamut.sposh.elements.SolTime.TimeUnits;
import cz.cuni.amis.pogamut.sposh.elements.TriggeredAction;
import cz.cuni.pogamut.posh.widget.accept.AbstractAcceptAction;
import cz.cuni.pogamut.posh.widget.*;
import cz.cuni.pogamut.posh.widget.accept.AcceptAP2TA;
import cz.cuni.pogamut.posh.widget.accept.AcceptComp2TA;
import cz.cuni.pogamut.posh.widget.accept.AcceptTA2TA;
import cz.cuni.pogamut.posh.widget.menuactions.AddTA2AP;
import cz.cuni.pogamut.posh.widget.menuactions.DeleteNodeAction;
import java.beans.PropertyChangeEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.netbeans.api.visual.action.ActionFactory;
import org.netbeans.api.visual.action.TextFieldInplaceEditor;
import org.netbeans.api.visual.widget.Widget;
import org.openide.nodes.Node.Property;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.Exceptions;

/**
 * Widget that is showing as AP, but it is a triggered action.
 * TriggerAction can be a multiple things and this widget is representing it as
 * action pattern.
 *
 * @author Honza
 */
public class SimpleRoleActionPatternWidget extends SimpleBasicWidget {

    ActionPattern apNode;

    public SimpleRoleActionPatternWidget(PoshScene poshScene, TriggeredAction dataNode, PoshWidget parent, ActionPattern apNode) {
        super(poshScene, dataNode, parent);

        this.apNode = apNode;
        this.apNode.addPoshTreeChangeListener(this);

        getActions().addAction(ActionFactory.createInplaceEditorAction(
                new APInplaceEditor(dataNode, apNode)));
    }

    /**
     * Create inplace editor that changes name of action patten and the action
     */
    protected static class APInplaceEditor implements TextFieldInplaceEditor {

        private TriggeredAction action;
        private ActionPattern ap;

        protected APInplaceEditor(TriggeredAction action, ActionPattern ap) {
            this.action = action;
            this.ap = ap;
        }

        @Override
        public boolean isEnabled(Widget widget) {
            return true;
        }

        @Override
        public String getText(Widget widget) {
            return action.getDisplayName();
        }

        @Override
        public void setText(Widget widget, String string) {
            String apName = ap.getNodeName();
            String actionName = action.getActionName();
            try {
                ap.setNodeName(string);
                action.setActionName(string);
            } catch (Exception ex) {
                try {
                    action.setActionName(actionName);
                    ap.setNodeName(apName);
                } catch (Exception ex1) {
                    // Shouldn't happen, but if it doesn, show exception
                    Exceptions.printStackTrace(ex1);
                }
            }
        }
    }

    @Override
    protected PropertyNode createPropertiesNode() {
        return new PropertyNode(apNode, this);
    }

    /**
     * Remove all widget children of Ap and add them.
     */
    public void regenerate() {
        deleteChildrenWidgets();
        createCh();
    }

    /**
     * Take all direct decending children widgets of this widget and
     * delete them from the scene.
     */
    private void deleteChildrenWidgets() {
        List<PoshWidget> children = this.getChildNodes();
        if (children == null) {
            children = new LinkedList<PoshWidget>();
        }

        for (PoshWidget widget : children) {
            getPoshScene().deletePoshWidget(widget);
        }
    }

    /**
     * Create children of AP. In most widgets, one widget is representing one node.
     * This one is representing AP and this function is regenerating AP structure to widgets.
     */
    private void createCh() {
        Queue<PoshWidget> fringe =
                new LinkedList<PoshWidget>(createWidgetChildren(this, apNode));

        while (!fringe.isEmpty()) {
            PoshWidget headWidget = fringe.poll();
            PoshElement headDataNode = headWidget.getDataNode();

            if (!(headDataNode instanceof TriggeredAction)) {
                fringe.addAll(createWidgetChildren(headWidget, headDataNode));
            }
        }
    }

    /**
     * Take all children of data node dn and notify widget w that every child
     * of data node is its child.
     *
     * @param w Widget we are going to notify
     * @param dn datanode from which we will get childre
     * @return list of children of widget after it was notified about all children of data node.
     */
    private List<PoshWidget> createWidgetChildren(PoshWidget w, PoshElement dn) {
        List<PoshElement> dataChildren = dn.getChildDataNodes();

        for (PoshElement dnch : dataChildren) {
            w.nodeChanged(PoshTreeEvent.NEW_CHILD_NODE, dnch);
        }

        return w.getChildNodes();
    }

    @Override
    protected PoshNodeType getType() {
        return PoshNodeType.ACTION_PATTERN;
    }

    @Override
    protected List<AbstractMenuAction> createMenuActions() {
        LinkedList<AbstractMenuAction> list = new LinkedList<AbstractMenuAction>();

        list.add(new AddTA2AP(apNode));

        // add delete action, if at least one action is available
        int numTAs = getDataNode().getParent().getNumberOfChildInstances(TriggeredAction.class);

        if (numTAs > 1) {
            list.add(new DeleteNodeAction(
                    "Delete action", getDataNode()));
        }

        return list;
    }

    /**
     * Create proper widget from child data node.
     *
     * @param dataNode DataNode that was added as child
     *                 to associated data node
     */
    @Override
    protected void addChildWidget(PoshElement dataNode) {
        if (dataNode instanceof TriggeredAction) {
            addTriggeredActionWidgets((TriggeredAction) dataNode);
        } else {
            throw new RuntimeException("Child of this type not permitted: " + dataNode.getClass().getName());
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals(TriggeredAction.taName)) {
            this.changeTriggeredActionWidgets((TriggeredAction) getDataNode());
            this.doRepaint();
        }
        if (evt.getPropertyName().equals(ActionPattern.apName)) {
            this.changeTriggeredActionWidgets((TriggeredAction) getDataNode());
            this.doRepaint();
        }
    }

    @Override
    protected List<AbstractAcceptAction> getAcceptProviders() {
        List<AbstractAcceptAction> list = new LinkedList<AbstractAcceptAction>();

        list.add(new AcceptTA2TA(getDataNode()));
        list.add(new AcceptAP2TA(getDataNode()));
        list.add(new AcceptComp2TA((TriggeredAction) getDataNode()));

        return list;
    }

    /**
     * Create combo box property editor. It has
     * array of T items that are used as possible values of property.
     * Should be mainly for enums.
     */
    public static class ComboBoxProperty<T> extends PropertySupport.Reflection<Integer> {

        /**
         * Class that is dummy property
         * @param <T>
         */
        private static class Items<T> {

            private T[] items;
            private Class tClass;
            private Object propertyObject;
            private String getter;
            private String setter;

            private Items(T[] list, Class tClass, Object propertyObject, String getter, String setter) {
                this(list, 0, tClass, propertyObject, getter, setter);
            }

            private Items(T[] list, int selected, Class tClass, Object propertyObject, String getter, String setter) {
                this.items = Arrays.copyOf(list, list.length);
                this.propertyObject = propertyObject;
                this.getter = getter;
                this.setter = setter;
            }

            public Integer getItemId() throws Exception {
                T currentItem = getProperty();
                for (int i = 0; i < items.length; ++i) {
                    if (items[i].equals(currentItem)) {
                        return i;
                    }
                }
                throw new IllegalStateException("Currently selected value is not in object.");
            }

            public void setItemId(Integer newItemId) throws Exception {
                if (newItemId == null) {
                    return;
                }
                if (newItemId.intValue() >= items.length) {
                    return;
                }
                if (newItemId.intValue() < 0) {
                    return;
                }
                setProperty(items[newItemId]);
            }

            private void setProperty(T newItem) throws Exception {
                propertyObject.getClass().getMethod(setter, tClass).invoke(propertyObject, newItem);
            }

            private T getProperty() throws Exception {
                return (T) propertyObject.getClass().getMethod(getter).invoke(propertyObject);
            }
        }

        public ComboBoxProperty(T[] items, Class tClass, Object propertyObject, String getter, String setter) throws NoSuchMethodException {
            super(new Items(items, tClass, propertyObject, getter, setter), Integer.class, "getItemId", "setItemId");

            int[] intValues = new int[items.length];
            String[] stringKeys = new String[items.length];

            for (int i = 0; i < items.length; ++i) {
                intValues[i] = i;
                stringKeys[i] = items[i].toString();
            }
            this.setValue("intValues", intValues);
            this.setValue("stringKeys", stringKeys);
        }
    }

    @Override
    protected Sheet createSheet() {
        Sheet sheet = Sheet.createDefault();
        Sheet.Set set = Sheet.createPropertiesSet();
        sheet.put(set);

        try {
            Property nameProp = new PropertySupport.Reflection<String>(apNode, String.class, "getNodeName", "setNodeName");
//            Property timeoutAmmountProp = new PropertySupport.Reflection<Double>(apNode, Double.class, "getNodeTimeoutAmmount", "setNodeTimeoutAmmount");
//            Property timeoutUnitsProp = new PropertySupport.Reflection<Integer>(apNode, Integer.class, "getNodeTimeoutUnits", "setNodeTimeoutUnits");
            Property commentProp = new PropertySupport.Reflection<String>(apNode, String.class, "getNodeComment", "setNodeComment");
            /*
            int[] intValues = new int[TimeUnits.values().length];
            String[] stringKeys = new String[TimeUnits.values().length];

            int index = 0;
            for (TimeUnits unit : TimeUnits.values()) {
            intValues[index] = unit.getId();
            stringKeys[index] = unit.toString();
            index++;
            }

            timeoutUnitsProp.setValue("intValues", intValues);
            timeoutUnitsProp.setValue("stringKeys", stringKeys);
             */
            nameProp.setName(ActionPattern.apName);
//            timeoutAmmountProp.setName(ActionPattern.apTimeoutAmmount);
//            timeoutUnitsProp.setName(ActionPattern.apTimeoutUnits);
            commentProp.setName(ActionPattern.apComment);

            nameProp.setDisplayName("Name of action pattern");
//            timeoutAmmountProp.setDisplayName("Ammount of timeout");
//            timeoutUnitsProp.setDisplayName("Units of timeout");
            commentProp.setDisplayName("Comment about node");

            commentProp.setShortDescription("It is difficult to keep track about what part of POSH plan does what and that is where comments come in.");

            set.put(new Property[]{nameProp, /*timeoutAmmountProp, timeoutUnitsProp,*/ commentProp});
        } catch (NoSuchMethodException ex) {
            Exceptions.printStackTrace(ex);
        }
        return sheet;
    }
}
