/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.sposh.context;

import cz.cuni.amis.pogamut.base.agent.navigation.IPathPlanner;
import cz.cuni.amis.pogamut.base.agent.state.level0.IAgentState;
import cz.cuni.amis.pogamut.base.agent.state.level1.IAgentStateDown;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.AnnotationListenerRegistrator;
import cz.cuni.amis.pogamut.base3d.worldview.IVisionWorldView;
import cz.cuni.amis.pogamut.sposh.context.IUT2004Context;
import cz.cuni.amis.pogamut.sposh.context.UT2004ContextBase;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.AdrenalineCombo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.AgentConfig;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Raycasting;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.UT2004Weaponry;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensomotoric.Weaponry;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.AgentStats;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.CTF;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Game;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.ItemDescriptors;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Items;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.NavPoints;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.NavigationGraphBuilder;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.PathBuilder;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Players;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.Senses;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.UT2004AgentInfo;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.UT2004Items;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.WeaponPrefs;
import cz.cuni.amis.pogamut.ut2004.agent.module.sensor.visibility.Visibility;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.IUT2004Navigation;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004AStarPathPlanner;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004MapTweaks;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.UT2004Navigation;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.astar.UT2004AStar;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.floydwarshall.FloydWarshallMap;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.levelGeometry.LevelGeometry;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.levelGeometry.LevelGeometryModule;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMesh;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.NavMeshModule;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing.IUT2004ServerProvider;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing.UT2004Draw;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing.UT2004ServerProvider;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathfollowing.NavMeshNavigation;
import cz.cuni.amis.pogamut.ut2004.bot.command.AdvancedLocomotion;
import cz.cuni.amis.pogamut.ut2004.bot.command.CompleteBotCommandsWrapper;
import cz.cuni.amis.pogamut.ut2004.bot.command.ImprovedShooting;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.teamcomm.bot.UT2004TCClient;
import cz.cuni.amis.utils.flag.FlagListener;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class UT2004Context<BOT extends UT2004Bot>
extends UT2004ContextBase<BOT>
implements IUT2004Context<BOT> {
    protected Random random = new Random(System.currentTimeMillis());
    protected IUT2004Navigation navigation;
    protected NavMeshNavigation nmNav;
    protected UT2004MapTweaks mapTweaks;
    protected Game game;
    protected AgentInfo info;
    protected Players players;
    protected ItemDescriptors descriptors;
    protected Items items;
    protected Senses senses;
    protected Weaponry weaponry;
    protected AgentConfig config;
    protected Raycasting raycasting;
    protected CompleteBotCommandsWrapper body;
    protected ImprovedShooting shoot;
    protected AdvancedLocomotion move;
    protected CTF ctf;
    protected AdrenalineCombo combo;
    protected UT2004AStarPathPlanner ut2004PathPlanner = null;
    protected NavigationGraphBuilder navBuilder = null;
    protected AnnotationListenerRegistrator listenerRegistrator;
    protected WeaponPrefs weaponPrefs;
    protected IVisionWorldView world;
    protected IAct act;
    protected AgentStats stats;
    protected FloydWarshallMap fwMap;
    protected Visibility visibility;
    protected NavPoints navPoints;
    protected UT2004AStar aStar;
    protected NavMeshModule navMeshModule;
    protected LevelGeometryModule levelGeometryModule;
    private IUT2004ServerProvider serverProvider;
    protected UT2004Draw draw;
    protected PathBuilder nmPathBuilder;
    protected UT2004TCClient tcClient;
    private FlagListener<IAgentState> botStateListener = new FlagListener<IAgentState>(){

        public void flagChanged(IAgentState changedValue) {
            if (changedValue instanceof IAgentStateDown) {
                UT2004Context.this.botAgentDown();
            }
        }
    };

    @Override
    protected void initialize() {
        ((UT2004Bot)this.bot).getState().addListener(this.botStateListener);
        this.world = ((UT2004Bot)this.bot).getWorldView();
        this.act = ((UT2004Bot)this.bot).getAct();
        this.initializeModules((UT2004Bot)this.bot);
        this.initializePathFinding((UT2004Bot)this.bot);
        this.initializeListeners((UT2004Bot)this.bot);
    }

    public UT2004Context(String name, BOT bot) {
        super(name, bot);
    }

    protected void initializeListeners(BOT bot) {
        this.listenerRegistrator = new AnnotationListenerRegistrator((Object)this, (IWorldView)this.getWorldView(), (Logger)bot.getLogger().getCategory("Listeners"));
        this.listenerRegistrator.addListeners();
    }

    protected void initializePathFinding(BOT bot) {
        this.ut2004PathPlanner = new UT2004AStarPathPlanner(bot);
        this.fwMap = new FloydWarshallMap(bot);
        this.items.setPathPlanner((IPathPlanner)this.fwMap);
        this.aStar = new UT2004AStar(bot);
        this.navigation = new UT2004Navigation(bot, this.info, this.move);
        this.nmNav = new NavMeshNavigation(bot, this.info, this.move, this.navMeshModule);
        this.nmPathBuilder = new PathBuilder(bot, this.info, (IPathPlanner)this.navMeshModule.getAStarPathPlanner());
    }

    @Override
    protected void initializeModules(BOT bot) {
        super.initializeModules(bot);
        this.game = new Game(bot);
        this.navPoints = new NavPoints(bot);
        this.players = new Players(bot);
        this.descriptors = new ItemDescriptors(bot);
        this.config = new AgentConfig(bot);
        this.raycasting = new Raycasting(bot);
        this.stats = new AgentStats(bot);
        this.navBuilder = new NavigationGraphBuilder(bot);
        this.mapTweaks = new UT2004MapTweaks(bot);
        this.info = new UT2004AgentInfo(bot, this.game);
        this.visibility = new Visibility(bot, this.info);
        this.ctf = new CTF(bot, this.info);
        this.weaponry = new UT2004Weaponry(bot, this.descriptors);
        this.items = new UT2004Items(bot, this.info, this.game, this.weaponry, null);
        this.senses = new Senses(bot, this.info, this.players);
        this.body = new CompleteBotCommandsWrapper(bot, this.weaponry, null);
        this.shoot = this.body.getImprovedShooting();
        this.move = this.body.getLocomotion();
        this.weaponPrefs = new WeaponPrefs(this.weaponry, bot);
        this.combo = new AdrenalineCombo(bot, this.info);
        this.serverProvider = new UT2004ServerProvider();
        this.navMeshModule = new NavMeshModule(this.serverProvider, (IWorldView)this.getWorldView(), bot.getLogger());
        this.levelGeometryModule = new LevelGeometryModule(this.serverProvider, (IWorldView)this.getWorldView(), bot.getLogger());
        this.draw = new UT2004Draw((Logger)bot.getLogger().getCategory("Draw"), this.serverProvider);
        this.tcClient = new UT2004TCClient(bot, (IWorldView)bot.getWorldView());
    }

    @Override
    public void mapInfoObtainedInternal() {
        super.mapInfoObtainedInternal();
        this.mapTweaks.tweak(this.navBuilder);
    }

    @Override
    public void finishControllerInitialization() {
        if (this.navBuilder.isUsed()) {
            this.log.info("Navigation graph has been altered by 'navBuilder', triggering recomputation of Floyd-Warshall path matrix...");
            Level oldLevel = this.fwMap.getLog().getLevel();
            this.fwMap.getLog().setLevel(Level.FINER);
            this.fwMap.refreshPathMatrix();
            this.fwMap.getLog().setLevel(oldLevel);
            this.aStar.mapChanged();
        }
        if (this.navMeshModule.isInitialized()) {
            this.log.info("Navigation mesh available; switching to nmNav by default setting: navigation = nmNav");
            this.navigation = this.nmNav;
        }
    }

    public UT2004Draw getDraw() {
        return this.draw;
    }

    public Random getRandom() {
        return this.random;
    }

    public UT2004AStar getAStar() {
        return this.aStar;
    }

    public Game getGame() {
        return this.game;
    }

    public AgentInfo getInfo() {
        return this.info;
    }

    public NavPoints getNavPoints() {
        return this.navPoints;
    }

    public Players getPlayers() {
        return this.players;
    }

    public ItemDescriptors getDescriptors() {
        return this.descriptors;
    }

    public Items getItems() {
        return this.items;
    }

    public Senses getSenses() {
        return this.senses;
    }

    public Weaponry getWeaponry() {
        return this.weaponry;
    }

    public AgentConfig getConfig() {
        return this.config;
    }

    public Raycasting getRaycasting() {
        return this.raycasting;
    }

    public CompleteBotCommandsWrapper getBody() {
        return this.body;
    }

    public ImprovedShooting getShoot() {
        return this.shoot;
    }

    public AdvancedLocomotion getMove() {
        return this.move;
    }

    public UT2004AStarPathPlanner getUT2004AStarPathPlanner() {
        return this.ut2004PathPlanner;
    }

    public AdrenalineCombo getCombo() {
        return this.combo;
    }

    public NavigationGraphBuilder getNavBuilder() {
        return this.navBuilder;
    }

    public UT2004MapTweaks getMapTweaks() {
        return this.mapTweaks;
    }

    public WeaponPrefs getWeaponPrefs() {
        return this.weaponPrefs;
    }

    public IVisionWorldView getWorld() {
        return this.world;
    }

    public AgentStats getStats() {
        return this.stats;
    }

    public FloydWarshallMap getFwMap() {
        return this.fwMap;
    }

    public IUT2004Navigation getNavigation() {
        return this.navigation;
    }

    public NavMeshNavigation getNMNav() {
        return this.nmNav;
    }

    public Visibility getVisibility() {
        return this.visibility;
    }

    public NavMeshModule getNavMeshModule() {
        return this.navMeshModule;
    }

    public NavMesh getNavMesh() {
        if (!this.navMeshModule.isInitialized()) {
            this.log.warning("NavMeshModule has not been initialized (yet?)! You are either calling this method too early or missing .navmesh file in the local directory of your bot!");
        }
        return this.navMeshModule.getNavMesh();
    }

    public LevelGeometryModule getLevelGeometryModule() {
        return this.levelGeometryModule;
    }

    public LevelGeometry getLevelGeometry() {
        if (!this.levelGeometryModule.isInitialized()) {
            this.log.warning("LevelGeometryModule has not been initialized (yet?)! You are either calling this method too early or missing .obj, .scale, .center files in the local directory of your bot!");
        }
        return this.levelGeometryModule.getLevelGeometry();
    }

    public PathBuilder getNMPathBuilder() {
        if (!this.navMeshModule.isInitialized()) {
            this.log.warning("NavMesh has not been initialized (yet?)! You are either calling this method too early or missing .navmesh file in the local directory of your bot!");
        }
        return this.nmPathBuilder;
    }

    public CTF getCTF() {
        return this.ctf;
    }

    public UT2004TCClient getTCClient() {
        return this.tcClient;
    }

    protected void botAgentDown() {
        if (this.serverProvider != null) {
            this.serverProvider.killServer();
        }
    }
}

