/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.vip.observer;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.ut2004.agent.params.UT2004AgentParameters;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.ConfigurationObserver;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.InitializeObserver;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BotKilled;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Spawn;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.UT2004WorldView;
import cz.cuni.amis.pogamut.ut2004.observer.impl.UT2004Observer;
import cz.cuni.amis.pogamut.ut2004.vip.observer.CSObserverParams;

public class CSObserver
extends UT2004Observer {
    private boolean observing = false;
    private boolean botAlive = false;
    private IWorldEventListener<BotKilled> botKilled = new IWorldEventListener<BotKilled>(){

        public void notify(BotKilled event) {
            CSObserver.this.botKilled(event);
        }
    };
    private IWorldEventListener<Spawn> botSpawned = new IWorldEventListener<Spawn>(){

        public void notify(Spawn event) {
            CSObserver.this.botSpwaned(event);
        }
    };
    private IWorldObjectEventListener<Self, WorldObjectUpdatedEvent<Self>> selfListener = new IWorldObjectEventListener<Self, WorldObjectUpdatedEvent<Self>>(){

        public void notify(WorldObjectUpdatedEvent<Self> event) {
            CSObserver.this.selfUpdated((Self)event.getObject());
        }
    };

    @Inject
    public CSObserver(UT2004AgentParameters params, IComponentBus bus, IAgentLogger agentLogger, UT2004WorldView worldView, IAct act) {
        super(params, bus, agentLogger, worldView, act);
        if (!(params instanceof CSObserverParams)) {
            throw new RuntimeException("VIPObserver must be instantiated with VIPObserverParams not " + params.getClass().getSimpleName() + ".");
        }
        this.getLogger().addDefaultConsoleHandler();
    }

    public CSObserverParams getParams() {
        return (CSObserverParams)super.getParams();
    }

    protected void startAgent() {
        super.startAgent();
        ((UT2004WorldView)this.getWorldView()).addEventListener(Spawn.class, this.botSpawned);
        ((UT2004WorldView)this.getWorldView()).addEventListener(BotKilled.class, this.botKilled);
        ((UT2004WorldView)this.getWorldView()).addObjectListener(Self.class, WorldObjectUpdatedEvent.class, this.selfListener);
        this.configureObserver();
        this.observing = true;
    }

    protected void killAgent() {
        this.observing = false;
        super.killAgent();
    }

    public void configureObserver() {
        this.getAct().act((CommandMessage)new InitializeObserver().setId(this.getParams().getBotIdToObserve()));
        this.getAct().act((CommandMessage)new ConfigurationObserver().setAll(Boolean.valueOf(true)).setUpdate(Double.valueOf(0.5)).setSelf(Boolean.valueOf(true)).setAsync(Boolean.valueOf(true)).setGame(Boolean.valueOf(false)).setSee(Boolean.valueOf(false)).setSpecial(Boolean.valueOf(false)));
        this.getAct().act((CommandMessage)new ConfigurationObserver().setUpdate(Double.valueOf(0.5)));
        this.log.info("START OBSERVING: " + this.getParams().getBotIdToObserve());
    }

    protected void selfUpdated(Self self) {
        this.botAlive = true;
    }

    protected void botSpwaned(Spawn event) {
        this.botAlive = true;
    }

    protected void botKilled(BotKilled event) {
        this.botAlive = false;
    }

    public boolean isBotAlive() {
        return this.botAlive;
    }

    public boolean isObserving() {
        return this.observing;
    }
}

