/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.tournament.deathmatch;

import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.ut2004.tournament.deathmatch.UT2004DeathMatch;
import cz.cuni.amis.pogamut.ut2004.tournament.deathmatch.UT2004DeathMatchConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.deathmatch.UT2004DeathMatchResult;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004BotConfig;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.exception.PogamutException;
import java.io.File;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import org.apache.commons.io.FileUtils;

public class UT2004DeathMatch1v1
implements Callable<UT2004DeathMatchResult>,
Runnable {
    private int fragLimit;
    private int timeLimitInMinutes;
    private String matchName;
    private String bot1Name;
    private Integer bot1Skill;
    private String bot1Skin;
    private String bot1JarPath;
    private String bot2Name;
    private Integer bot2Skill;
    private String bot2Skin;
    private String bot2JarPath;
    private String unrealHome;
    private String mapName;
    private String outputDir;
    private LogCategory log;
    private UT2004DeathMatchResult result = null;
    private boolean humanLikeLogEnabled = false;
    private Throwable exception;

    public UT2004DeathMatch1v1() {
        this.log = new LogCategory(this.getMatchName());
    }

    public UT2004DeathMatch1v1(String matchName) {
        this.matchName = matchName;
        this.log = new LogCategory(this.getMatchName());
    }

    public UT2004DeathMatch1v1(String unrealHome, String mapName, String bot1Name, String bot1JarPath, String bot2Name, String bot2JarPath) {
        this(unrealHome, mapName, bot1Name, null, null, bot1JarPath, bot2Name, null, null, bot2JarPath);
    }

    public UT2004DeathMatch1v1(String unrealHome, String mapName, String bot1Name, Integer bot1Skill, String bot1Skin, String bot1JarPath, String bot2Name, Integer bot2Skill, String bot2Skin, String bot2JarPath) {
        this.unrealHome = unrealHome;
        this.mapName = mapName;
        this.bot1Name = bot1Name;
        this.bot1Skill = bot1Skill;
        this.bot1Skin = bot1Skin;
        this.bot1JarPath = bot1JarPath;
        this.bot2Name = bot2Name;
        this.bot2Skill = bot2Skill;
        this.bot2Skin = bot2Skin;
        this.bot2JarPath = bot2JarPath;
        this.matchName = bot1Name + "-vs-" + bot2Name;
        this.outputDir = "results" + File.separator + "matches";
        this.fragLimit = 20;
        this.timeLimitInMinutes = 20;
        this.log = new LogCategory(this.getMatchName());
    }

    public LogCategory getLog() {
        return this.log;
    }

    public int getFragLimit() {
        return this.fragLimit;
    }

    public int getTimeLimitInMinutes() {
        return this.timeLimitInMinutes;
    }

    public String getMatchName() {
        return this.matchName;
    }

    public String getBot1Name() {
        return this.bot1Name;
    }

    public Integer getBot1Skill() {
        return this.bot1Skill;
    }

    public String getBot1Skin() {
        return this.bot1Skin;
    }

    public String getBot1JarPath() {
        return this.bot1JarPath;
    }

    public String getBot2Name() {
        return this.bot2Name;
    }

    public Integer getBot2Skill() {
        return this.bot2Skill;
    }

    public String getBot2Skin() {
        return this.bot2Skin;
    }

    public String getBot2JarPath() {
        return this.bot2JarPath;
    }

    public String getUnrealHome() {
        return this.unrealHome;
    }

    public String getMapName() {
        return this.mapName;
    }

    public String getOutputDir() {
        return this.outputDir;
    }

    public UT2004DeathMatchResult getResult() {
        return this.result;
    }

    public Throwable getException() {
        return this.exception;
    }

    public void setLog(LogCategory log) {
        this.log = log;
    }

    public UT2004DeathMatch1v1 setFragLimit(int fragLimit) {
        this.fragLimit = fragLimit;
        return this;
    }

    public UT2004DeathMatch1v1 setTimeLimitInMinutes(int timeLimitInMinutes) {
        this.timeLimitInMinutes = timeLimitInMinutes;
        return this;
    }

    public UT2004DeathMatch1v1 setMatchName(String matchName) {
        this.matchName = matchName;
        return this;
    }

    public UT2004DeathMatch1v1 setBot1Name(String bot1Name) {
        this.bot1Name = bot1Name;
        return this;
    }

    public UT2004DeathMatch1v1 setBot1Skill(Integer skill) {
        this.bot1Skill = skill;
        return this;
    }

    public UT2004DeathMatch1v1 setBot1Skin(String skin) {
        this.bot1Skin = skin;
        return this;
    }

    public UT2004DeathMatch1v1 setBot1JarPath(String bot1JarPath) {
        this.bot1JarPath = bot1JarPath;
        return this;
    }

    public UT2004DeathMatch1v1 setBot2Skill(Integer skill) {
        this.bot2Skill = skill;
        return this;
    }

    public UT2004DeathMatch1v1 setBot2Skin(String skin) {
        this.bot2Skin = skin;
        return this;
    }

    public UT2004DeathMatch1v1 setBot2Name(String bot2Name) {
        this.bot2Name = bot2Name;
        return this;
    }

    public UT2004DeathMatch1v1 setBot2JarPath(String bot2JarPath) {
        this.bot2JarPath = bot2JarPath;
        return this;
    }

    public UT2004DeathMatch1v1 setUnrealHome(String unrealHome) {
        this.unrealHome = unrealHome;
        return this;
    }

    public UT2004DeathMatch1v1 setMapName(String mapName) {
        this.mapName = mapName;
        return this;
    }

    public UT2004DeathMatch1v1 setOutputDir(String outputDir) {
        this.outputDir = outputDir;
        return this;
    }

    public UT2004DeathMatch1v1 setHumanLikeLogEnabled(boolean humanLikeLogEnabled) {
        this.humanLikeLogEnabled = humanLikeLogEnabled;
        return this;
    }

    public void cleanUp() {
        try {
            FileUtils.deleteQuietly((File)new File(this.getOutputDir() + File.separator + this.getMatchName()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected UT2004DeathMatchConfig configure1Vs1() {
        UT2004DeathMatchConfig matchConfig = new UT2004DeathMatchConfig();
        matchConfig.setMatchId(this.getMatchName());
        matchConfig.setOutputDirectory(new File(this.getOutputDir() == null ? "results" + File.separator + "matches" : this.getOutputDir()));
        matchConfig.setFragLimit(this.getFragLimit());
        matchConfig.setTimeLimit(this.getTimeLimitInMinutes());
        matchConfig.setHumanLikeLogEnabled(this.humanLikeLogEnabled);
        matchConfig.getUccConf().setStartOnUnusedPort(true);
        matchConfig.getUccConf().setUnrealHome(this.getUnrealHome());
        matchConfig.getUccConf().setGameType("BotDeathMatch");
        matchConfig.getUccConf().setMapName(this.getMapName());
        UT2004BotConfig botConfig = new UT2004BotConfig();
        botConfig.setBotId(this.getBot1Name());
        if (this.getBot1Skill() != null) {
            botConfig.setDesiredSkill(this.getBot1Skill());
        }
        if (this.getBot1Skin() != null) {
            botConfig.setSkin(this.getBot1Skin());
        }
        botConfig.setPathToBotJar(this.getBot1JarPath());
        botConfig.setTeamNumber(255);
        botConfig.setRedirectStdErr(true);
        botConfig.setRedirectStdOut(true);
        matchConfig.addBot(botConfig);
        botConfig = new UT2004BotConfig();
        botConfig.setBotId(this.getBot2Name());
        if (this.getBot2Skill() != null) {
            botConfig.setDesiredSkill(this.getBot2Skill());
        }
        if (this.getBot2Skin() != null) {
            botConfig.setSkin(this.getBot2Skin());
        }
        botConfig.setPathToBotJar(this.getBot2JarPath());
        botConfig.setTeamNumber(255);
        botConfig.setRedirectStdErr(true);
        botConfig.setRedirectStdOut(true);
        matchConfig.addBot(botConfig);
        return matchConfig;
    }

    public UT2004DeathMatch createMatch() {
        this.log.info("Configuring match: " + this.getMatchName());
        UT2004DeathMatchConfig matchConfig = this.configure1Vs1();
        UT2004DeathMatch match = new UT2004DeathMatch(matchConfig, this.log);
        match.validate();
        return match;
    }

    @Override
    public void run() {
        try {
            this.cleanUp();
            UT2004DeathMatch match = this.createMatch();
            this.log.info("Executing match: " + this.getMatchName());
            this.result = match.execute();
            this.log.info("Match " + this.getMatchName() + " result: " + this.result);
            this.log.info("---/// MATCH OK ///---");
        }
        catch (Exception e) {
            if (this.log != null && this.log.isLoggable(Level.SEVERE)) {
                this.log.severe(ExceptionToString.process((String)("Failed to execute the match: " + this.getMatchName() + "."), (Throwable)e));
            }
            this.exception = e;
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new PogamutException("Failed to execute the match: " + this.getMatchName(), (Throwable)e, (Object)this);
        }
    }

    @Override
    public UT2004DeathMatchResult call() throws Exception {
        this.run();
        return this.getResult();
    }
}

