/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.tournament.capturetheflag;

import cz.cuni.amis.pogamut.ut2004.tournament.GameBots2004Ini;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004BotConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004MatchConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004NativeBotConfig;
import cz.cuni.amis.pogamut.ut2004.utils.UCCWrapper;
import cz.cuni.amis.utils.Const;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.token.IToken;
import java.io.File;
import java.util.Map;

public class UT2004CaptureTheFlagConfig
extends UT2004MatchConfig {
    protected int scoreLimit = 20;
    protected int timeLimitInMin = 20;

    public UT2004CaptureTheFlagConfig() {
        this.getGb2004Ini().setCTFScoreLimit(this.scoreLimit);
        this.getGb2004Ini().setCTFTimeLimit(this.timeLimitInMin);
        this.getUccConf().setGameType("BotCTFGame");
    }

    public UT2004CaptureTheFlagConfig(UT2004CaptureTheFlagConfig orig) {
        super(orig);
        this.setScoreLimit(orig.getScoreLimit());
        this.setTimeLimit(orig.getTimeLimit());
    }

    public int getScoreLimit() {
        return this.scoreLimit;
    }

    public int getTimeLimit() {
        return this.timeLimitInMin;
    }

    @Override
    public UT2004CaptureTheFlagConfig clearBots() {
        super.clearBots();
        return this;
    }

    @Override
    public UT2004CaptureTheFlagConfig clearNativeBots() {
        super.clearNativeBots();
        return this;
    }

    @Override
    public UT2004CaptureTheFlagConfig setOutputDirectory(File outputDirectory) {
        super.setOutputDirectory(outputDirectory);
        return this;
    }

    public UT2004CaptureTheFlagConfig setScoreLimit(int scoreLimit) {
        if (scoreLimit <= 0) {
            throw new PogamutException("Score limit can't be " + scoreLimit + " <= 0.", (Object)this);
        }
        this.scoreLimit = scoreLimit;
        this.getGb2004Ini().setCTFScoreLimit(scoreLimit);
        return this;
    }

    public UT2004CaptureTheFlagConfig setTimeLimit(int timeLimitInMinutes) {
        if (timeLimitInMinutes < 1) {
            throw new PogamutException("Time limit can't be " + timeLimitInMinutes + " < 1 min.", (Object)this);
        }
        this.timeLimitInMin = timeLimitInMinutes;
        this.getGb2004Ini().setCTFTimeLimit(timeLimitInMinutes);
        return this;
    }

    @Override
    public UT2004CaptureTheFlagConfig setUccConf(UCCWrapper.UCCWrapperConf uccConf) {
        super.setUccConf(uccConf);
        return this;
    }

    @Override
    public UT2004CaptureTheFlagConfig setGb2004Ini(GameBots2004Ini gb2004Ini) {
        super.setGb2004Ini(gb2004Ini);
        if (this.getGb2004Ini() != null) {
            if (this.getGb2004Ini().getDMFragLimit() != null) {
                this.scoreLimit = this.getGb2004Ini().getCTFScoreLimit();
            } else {
                this.getGb2004Ini().setDMFragLimit(this.scoreLimit);
            }
            if (this.getGb2004Ini().getDMTimeLimit() != null) {
                this.timeLimitInMin = this.getGb2004Ini().getCTFTimeLimit();
            } else {
                this.getGb2004Ini().setDMTimeLimit(this.timeLimitInMin);
            }
        }
        return this;
    }

    @Override
    public UT2004CaptureTheFlagConfig setBots(Map<IToken, UT2004BotConfig> bots) {
        super.setBots(bots);
        return this;
    }

    @Override
    public UT2004CaptureTheFlagConfig setNativeBots(Map<IToken, UT2004NativeBotConfig> nativeBots) {
        super.setNativeBots(nativeBots);
        return this;
    }

    @Override
    public UT2004CaptureTheFlagConfig addBot(UT2004BotConfig ... bots) {
        super.addBot(bots);
        return this;
    }

    @Override
    public UT2004MatchConfig setBot(UT2004BotConfig ... bots) {
        super.setBot(bots);
        return this;
    }

    @Override
    public UT2004CaptureTheFlagConfig addNativeBot(UT2004NativeBotConfig ... bots) {
        super.addNativeBot(bots);
        return this;
    }

    @Override
    public UT2004MatchConfig setNativeBot(UT2004NativeBotConfig ... bots) {
        super.setNativeBot(bots);
        return this;
    }

    @Override
    protected void validateInner() {
        super.validateInner();
        if (this.scoreLimit <= 0) {
            this.validationError = true;
            this.validationBuffer.append(Const.NEW_LINE);
            this.validationBuffer.append("ScoreLimit = " + this.scoreLimit + " <= 0");
        }
        if (this.timeLimitInMin < 1) {
            this.validationError = true;
            this.validationBuffer.append(Const.NEW_LINE);
            this.validationBuffer.append("TimeLimit = " + this.timeLimitInMin + " < 1 min.");
        }
        if (this.getGb2004Ini().getDMFragLimit() <= 0) {
            this.validationError = true;
            this.validationBuffer.append(Const.NEW_LINE);
            this.validationBuffer.append("GameBots2004.ini ScoreLimit = " + this.getGb2004Ini().getCTFScoreLimit() + " <= 0.");
        }
        if (this.getGb2004Ini().getDMTimeLimit() < 1) {
            this.validationError = true;
            this.validationBuffer.append(Const.NEW_LINE);
            this.validationBuffer.append("GameBots2004.ini TimeLimit = " + this.getGb2004Ini().getCTFTimeLimit() + " < 1 min.");
        }
    }
}

