/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.tournament.utils;

import cz.cuni.amis.utils.Const;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class MatchLogReader {
    public MatchLogReaderResult read(File logFile, String ... playerIds) {
        return this.read(logFile, Arrays.asList(playerIds));
    }

    public MatchLogReaderResult read(File logFile, List<String> playerIds) {
        MatchLogReaderResult result = new MatchLogReaderResult();
        ArrayList<Pattern> linePatterns = new ArrayList<Pattern>(playerIds.size());
        ArrayList<Pattern> endLinePatterns = new ArrayList<Pattern>(playerIds.size());
        for (String playerId : playerIds) {
            linePatterns.add(Pattern.compile(playerId + "-[0-9]+-StdOut"));
            endLinePatterns.add(Pattern.compile(playerId + "-[0-9]+-StdOut \\]$"));
            result.results.put(playerId, new PlayerLogResult(playerId));
        }
        boolean[] logicEx = new boolean[playerIds.size()];
        Arrays.fill(logicEx, false);
        int[] fatalErrorEvent = new int[playerIds.size()];
        Arrays.fill(fatalErrorEvent, 0);
        Object[] currExceptions = new String[playerIds.size()];
        Arrays.fill(currExceptions, "");
        BufferedReader reader = null;
        ZipInputStream zippedIS = null;
        try {
            if (logFile.getName().toLowerCase().endsWith(".zip")) {
                zippedIS = new ZipInputStream(new FileInputStream(logFile));
                ZipEntry zipEntry = zippedIS.getNextEntry();
                reader = new BufferedReader(new InputStreamReader(zippedIS));
            } else {
                reader = new BufferedReader(new InputStreamReader(new FileInputStream(logFile)));
            }
            int playerIndex = -1;
            int otherIndex = -1;
            while (reader.ready()) {
                String line = reader.readLine();
                String team = null;
                for (int i = 0; i < linePatterns.size(); ++i) {
                    Pattern pattern = (Pattern)linePatterns.get(i);
                    if (!pattern.matcher(line).find()) continue;
                    otherIndex = playerIndex;
                    playerIndex = i;
                    team = playerIds.get(i);
                    break;
                }
                if (team == null) continue;
                if (line.endsWith(" FatalErrorEvent[")) {
                    int n = playerIndex;
                    fatalErrorEvent[n] = fatalErrorEvent[n] + 1;
                }
                if (fatalErrorEvent[playerIndex] <= 0) continue;
                if (!((String)currExceptions[playerIndex]).isEmpty()) {
                    int n = playerIndex;
                    currExceptions[n] = (String)currExceptions[n] + Const.NEW_LINE;
                }
                int n = playerIndex;
                currExceptions[n] = (String)currExceptions[n] + line;
                if (!((Pattern)endLinePatterns.get(playerIndex)).matcher(line).find()) continue;
                int n2 = playerIndex;
                fatalErrorEvent[n2] = fatalErrorEvent[n2] - 1;
                if (fatalErrorEvent[playerIndex] > 0) continue;
                fatalErrorEvent[playerIndex] = 0;
                if (this.isBotException((String)currExceptions[playerIndex])) {
                    result.results.get(team).addException((String)currExceptions[playerIndex]);
                }
                currExceptions[playerIndex] = "";
            }
            for (playerIndex = 0; playerIndex < currExceptions.length; ++playerIndex) {
                if (((String)currExceptions[playerIndex]).isEmpty()) continue;
                if (this.isBotException((String)currExceptions[playerIndex])) {
                    result.results.get(playerIds.get(playerIndex)).addException((String)currExceptions[playerIndex]);
                }
                currExceptions[playerIndex] = "";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Failed to probe log file at: " + logFile.getAbsolutePath());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception exception) {}
            }
            if (zippedIS != null) {
                try {
                    zippedIS.close();
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    private boolean isBotException(String exception) {
        if (exception.contains("class cz.cuni.amis.utils.exception.PogamutIOException: java.net.SocketException: Connection reset by peer: socket write error")) {
            return false;
        }
        if (exception.contains("UT2004Parser: Can't parse next message: java.net.SocketException: Connection reset")) {
            return false;
        }
        return !exception.contains("Message:    agent kill() requested");
    }

    public static void main(String[] args) {
        String team1 = "DenisJudin";
        String team2 = "JanHolan";
        File file = new File("d:\\Workspaces\\MFF\\NAIL068-UmeleBytosti\\Lectures\\AB2019-Labs\\Lab-06-TDM\\Students\\_Results\\1-DM-Rankin-FE\\Match-DenisJudin-vs-JanHolan-1-DM-Rankin-FE\\match-Match-DenisJudin-vs-JanHolan-1-DM-Rankin-FE.log");
        MatchLogReader reader = new MatchLogReader();
        MatchLogReaderResult result = reader.read(file, team1, team2);
        System.out.println(result.results.get(team1));
        System.out.println(result.results.get(team2));
    }

    public static class MatchLogReaderResult {
        public Map<String, PlayerLogResult> results = new HashMap<String, PlayerLogResult>();
    }

    public static class PlayerLogResult {
        public String playerId;
        public String exceptions = "";
        public boolean exception = false;

        public PlayerLogResult(String playerId) {
            this.playerId = playerId;
        }

        public boolean isException() {
            return this.exception;
        }

        public void addException(String exception) {
            this.exception = true;
            if (!this.exceptions.isEmpty()) {
                this.exceptions = this.exceptions + Const.NEW_LINE;
            }
            this.exceptions = this.exceptions + exception;
        }

        public String toString() {
            return "PlayerLogResult[playerId=" + this.playerId + ",exception=" + this.exception + (this.exception ? "\n" + this.exceptions : "") + "\n]";
        }
    }
}

