/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.tournament.tdm.table.report.one;

import cz.cuni.amis.pogamut.ut2004.tournament.tdm.table.report.one.TDMOneMatchResult;
import cz.cuni.amis.pogamut.ut2004.tournament.tdm.table.report.one.TDMOneMatchTableTeamResult;
import cz.cuni.amis.pogamut.ut2004.tournament.utils.CSV;
import cz.cuni.amis.pogamut.ut2004.tournament.utils.MatchLogReader;
import cz.cuni.amis.utils.ExceptionToString;
import cz.cuni.amis.utils.FileAppender;
import cz.cuni.amis.utils.collections.MyCollections;
import cz.cuni.amis.utils.maps.HashMapMap;
import cz.cuni.amis.utils.maps.LazyMap;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class TDMOneMatchTableResults {
    public String mapName;
    public int mapNumber;
    public Map<String, TDMOneMatchTableTeamResult> teams = new LazyMap<String, TDMOneMatchTableTeamResult>(){

        protected TDMOneMatchTableTeamResult create(String key) {
            return new TDMOneMatchTableTeamResult(key);
        }
    };
    public HashMapMap<String, String, TDMOneMatchResult> results = new HashMapMap();

    public TDMOneMatchTableResults(String mapName, int mapNumber) {
        this.mapName = mapName;
        this.mapNumber = mapNumber;
    }

    protected void info(String msg) {
        System.out.println("[INFO] " + msg);
    }

    protected void warn(String msg) {
        System.out.println("[WARN] " + msg);
    }

    protected void error(String msg) {
        System.out.println("[ERROR] " + msg);
    }

    public TDMOneMatchResult getMatchResult(String plr1, String plr2) {
        if (plr1.compareToIgnoreCase(plr2) > 0) {
            String temp = plr2;
            plr2 = plr1;
            plr1 = temp;
        }
        return (TDMOneMatchResult)this.results.get((Object)plr1, (Object)plr2);
    }

    public TDMOneMatchResult addResult(String team1, String team2, int score1, int score2, MatchLogReader.MatchLogReaderResult log) {
        if (team1.compareToIgnoreCase(team2) == 0) {
            throw new RuntimeException("Could not add result for " + team1 + " vs. " + team2 + " as their names are the same!");
        }
        if (team1.compareToIgnoreCase(team2) > 0) {
            String temp = team2;
            team2 = team1;
            team1 = temp;
            int tempI = score2;
            score2 = score1;
            score1 = tempI;
        }
        TDMOneMatchTableTeamResult team1Result = this.teams.get(team1);
        TDMOneMatchTableTeamResult team2Result = this.teams.get(team2);
        TDMOneMatchResult result = new TDMOneMatchResult(team1, team2, score1, score2, log.results.get(team1).isException(), log.results.get(team2).isException(), log.results.get((Object)team1).exceptions, log.results.get((Object)team2).exceptions);
        TDMOneMatchResult old = (TDMOneMatchResult)this.results.put((Object)team1, (Object)team2, (Object)result);
        if (old != null) {
            throw new RuntimeException("There are more than one result for " + team1 + " vs. " + team2 + "! First result [" + old.score1 + ":" + old.score2 + "], second result [" + score1 + ":" + score2 + "].");
        }
        team1Result.result(result);
        team2Result.result(result);
        return result;
    }

    public List<TDMOneMatchTableTeamResult> resolve() {
        int end;
        this.info("RESOLVING TABLE");
        List results = MyCollections.asList(this.teams.values());
        Collections.sort(results, new Comparator<TDMOneMatchTableTeamResult>(){

            @Override
            public int compare(TDMOneMatchTableTeamResult o1, TDMOneMatchTableTeamResult o2) {
                if (o1.wins == o2.wins) {
                    TDMOneMatchResult result = TDMOneMatchTableResults.this.getMatchResult(o1.team, o2.team);
                    if (result == null) {
                        return 0;
                    }
                    return result.getScore(o2.team) - result.getScore(o1.team);
                }
                return o2.wins - o1.wins;
            }
        });
        int i = 0;
        while (i < results.size()) {
            int j;
            int start = i;
            end = results.size() - 1;
            for (j = i + 1; j < results.size(); ++j) {
                if (((TDMOneMatchTableTeamResult)results.get((int)i)).wins == ((TDMOneMatchTableTeamResult)results.get((int)j)).wins) continue;
                end = j - 1;
                break;
            }
            i = end + 1;
            if (start == end) {
                ((TDMOneMatchTableTeamResult)results.get((int)start)).position = start + 1;
                continue;
            }
            if (start + 1 == end) {
                TDMOneMatchTableTeamResult result1 = (TDMOneMatchTableTeamResult)results.get(start);
                TDMOneMatchTableTeamResult result2 = (TDMOneMatchTableTeamResult)results.get(start + 1);
                String player1 = ((TDMOneMatchTableTeamResult)results.get((int)start)).team;
                String player2 = ((TDMOneMatchTableTeamResult)results.get((int)(start + 1))).team;
                TDMOneMatchResult match = this.getMatchResult(player1, player2);
                if (match != null) {
                    if (match.isWin(player1)) {
                        result1.position = start + 1;
                        result2.position = start + 2;
                        continue;
                    }
                    if (match.isWin(player2)) {
                        result1.position = start + 2;
                        result2.position = start + 1;
                        continue;
                    }
                }
                result1.position = end + 1;
                result2.position = end + 1;
            }
            for (j = start; j <= end; ++j) {
                ((TDMOneMatchTableTeamResult)results.get((int)j)).position = end + 1;
            }
        }
        int start = 0;
        while (start < results.size()) {
            int position = ((TDMOneMatchTableTeamResult)results.get((int)start)).position;
            for (end = start + 1; end < results.size() && position == ((TDMOneMatchTableTeamResult)results.get((int)end)).position; ++end) {
            }
            if (start == --end) {
                ++start;
                continue;
            }
            boolean dominating = false;
            for (int candidate = start; candidate <= end; ++candidate) {
                boolean candidateDominating = true;
                TDMOneMatchTableTeamResult result = (TDMOneMatchTableTeamResult)results.get(candidate);
                String candidatePlr = result.team;
                for (int other = start; other <= end; ++other) {
                    String otherPlr;
                    TDMOneMatchResult match;
                    if (candidate == other || (match = this.getMatchResult(candidatePlr, otherPlr = ((TDMOneMatchTableTeamResult)results.get((int)other)).team)) == null || match.isWin(candidatePlr)) continue;
                    candidateDominating = false;
                    break;
                }
                if (!candidateDominating) continue;
                if (candidate != start) {
                    TDMOneMatchTableTeamResult candidateResult = (TDMOneMatchTableTeamResult)results.get(candidate);
                    TDMOneMatchTableTeamResult startResult = (TDMOneMatchTableTeamResult)results.get(start);
                    results.set(start, candidateResult);
                    results.set(candidate, startResult);
                }
                ((TDMOneMatchTableTeamResult)results.get((int)start)).position -= end - start;
                dominating = true;
                break;
            }
            if (dominating) {
                ++start;
                continue;
            }
            start = end + 1;
        }
        return results;
    }

    public void probeResults(File dir) {
        this.probeResults(dir);
    }

    public void probeResults(File dir, boolean recursive) {
        boolean processed = false;
        for (File file : dir.listFiles()) {
            if (!file.exists() || !file.isFile()) continue;
            try {
                if (!this.probeCompleteResult(file)) continue;
                processed = true;
                break;
            }
            catch (Exception e) {
                FileAppender.appendToFile((File)new File("dir", "TDM-Report.warnings"), (String)ExceptionToString.process((String)("Exception while processing: " + file.getAbsolutePath()), (Throwable)e));
                throw new RuntimeException("Failed to process file: " + file.getAbsolutePath(), e);
            }
        }
        if (processed) {
            return;
        }
        for (File file : dir.listFiles()) {
            if (!file.exists() || !file.isFile()) continue;
            try {
                if (!this.probeLogResult(file)) continue;
                processed = true;
                break;
            }
            catch (Exception e) {
                FileAppender.appendToFile((File)new File("dir", "TDM-Report.warnings"), (String)ExceptionToString.process((String)("Exception while processing: " + file.getAbsolutePath()), (Throwable)e));
                throw new RuntimeException("Failed to process file: " + file.getAbsolutePath(), e);
            }
        }
        if (processed) {
            return;
        }
        for (File file : dir.listFiles()) {
            if (!file.exists() || !file.isDirectory() || !recursive) continue;
            this.probeResults(file, recursive);
        }
    }

    private boolean probeCompleteResult(File resultFile) throws FileNotFoundException, IOException {
        if (!(resultFile.exists() && resultFile.isFile() && resultFile.getAbsolutePath().toLowerCase().endsWith("-result.csv"))) {
            return false;
        }
        this.info("Found result file: " + resultFile.getAbsolutePath());
        File teamScoresFile = new File(resultFile.getAbsolutePath().replace("-result.csv", "-team-scores.csv"));
        if (!teamScoresFile.exists()) {
            this.error("Cannot locate team-scores file at: " + teamScoresFile);
            return false;
        }
        this.info("Found team-scores file: " + teamScoresFile.getAbsolutePath());
        CSV resultCSV = new CSV(resultFile, ";", true);
        if (resultCSV.rows.size() != 1) {
            this.warn("-- Result file contains invalid number of data rows (" + resultCSV.rows.size() + "), ignoring.");
            return false;
        }
        File logFile = new File(resultFile.getAbsolutePath().replace("-result.csv", ".log"));
        if (logFile.exists()) {
            this.info("Found non-zipped log file, zipping: " + logFile.getAbsolutePath());
            this.zipLogFile(logFile);
        }
        if (!(logFile = new File(resultFile.getAbsolutePath().replace("-result.csv", ".log.zip"))).exists()) {
            this.error("Cannot locate zipped-log file at: " + logFile);
            return false;
        }
        this.info("Found zipped-log file: " + logFile.getAbsolutePath());
        if (!resultCSV.keys.contains("Winner")) {
            this.warn("-- Result file does not contain column 'Winner'. Ignoring.");
            return false;
        }
        String winner = resultCSV.rows.get(0).getString("Winner");
        if (winner.toLowerCase().contains("failure")) {
            this.error("-- Result file is indicating that the match has FAILED!");
            return false;
        }
        CSV teamScoresCSV = new CSV(teamScoresFile, ";", true);
        if (teamScoresCSV.rows.size() != 2) {
            this.warn("-- Team scores contains invalid number of data rows (" + teamScoresCSV.rows.size() + "), ignoring.");
            return false;
        }
        File botScoresFile = new File(resultFile.getAbsolutePath().replace("-result.csv", "-bot-scores.csv"));
        if (!botScoresFile.exists()) {
            this.error("Cannot locate bot-scores file at: " + botScoresFile.getAbsolutePath());
            return false;
        }
        this.info("Found bot-scores file: " + botScoresFile.getAbsolutePath());
        CSV botScoresCSV = null;
        try {
            botScoresCSV = new CSV(botScoresFile, ";", true);
            if (!botScoresCSV.keys.contains("team")) {
                this.warn("-- Bot-scores file does not contain column 'team'. Ignoring.");
                botScoresCSV = null;
            }
            if (!botScoresCSV.keys.contains("botId")) {
                this.warn("-- Bot-scores file does not contain column 'botId'. Ignoring.");
                botScoresCSV = null;
            }
            if (!botScoresCSV.keys.contains("score")) {
                this.warn("-- Bot-scores file does not contain column 'score'. Ignoring.");
                botScoresCSV = null;
            }
        }
        catch (Exception e) {
            this.warn("  -- cannot load CSV? Ignoring.");
            botScoresCSV = null;
        }
        String team1 = teamScoresCSV.rows.get(0).getString("teamId");
        String team2 = teamScoresCSV.rows.get(1).getString("teamId");
        if (team1.compareTo(team2) > 0) {
            String temp = team2;
            team2 = team1;
            team1 = temp;
        }
        this.extractResults(team1, team2, resultFile, resultCSV, teamScoresFile, teamScoresCSV, botScoresFile, botScoresCSV, logFile);
        return true;
    }

    private boolean probeLogResult(File resultFile) {
        Pattern p;
        Matcher m;
        if (!resultFile.getAbsolutePath().toLowerCase().endsWith(".log") && !resultFile.getAbsolutePath().toLowerCase().endsWith(".zip")) {
            return false;
        }
        if (resultFile.getAbsolutePath().endsWith(".log") && resultFile.exists()) {
            this.info("Found non-zipped log file, zipping: " + resultFile.getAbsolutePath());
            this.zipLogFile(resultFile);
        }
        if (!resultFile.getAbsolutePath().endsWith(".zip")) {
            File logFile = new File(resultFile.getAbsolutePath() + ".zip");
            if (!logFile.exists()) {
                return false;
            }
            resultFile = logFile;
        }
        if (!(m = (p = Pattern.compile("^match-Match-(.*)-vs-(.*)-[0-9]+-")).matcher(resultFile.getName())).find()) {
            return false;
        }
        String team1 = m.group(1);
        String team2 = m.group(2);
        MatchLogReader.MatchLogReaderResult log = new MatchLogReader().read(resultFile, team1, team2);
        if (log.results.get(team1).isException() || log.results.get(team2).isException()) {
            this.addResult(team1, team2, 0, 0, log);
            return true;
        }
        return false;
    }

    private void zipLogFile(File logFile) {
        try {
            int length;
            File targetFile = new File(logFile.getAbsolutePath() + ".zip");
            FileOutputStream fos = new FileOutputStream(targetFile);
            ZipOutputStream zipOut = new ZipOutputStream(fos);
            FileInputStream fis = new FileInputStream(logFile);
            ZipEntry zipEntry = new ZipEntry(logFile.getName());
            zipOut.putNextEntry(zipEntry);
            byte[] bytes = new byte[1024];
            while ((length = fis.read(bytes)) >= 0) {
                zipOut.write(bytes, 0, length);
            }
            zipOut.close();
            fis.close();
            fos.close();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to zip log file.", e);
        }
        logFile.delete();
    }

    private void extractResults(String team1, String team2, File resultFile, CSV resultCSV, File teamScoresFile, CSV teamScoresCSV, File botScoresFile, CSV botScoresCSV, File logFileZip) {
        CSV.CSVRow row;
        int i;
        int score1 = 0;
        int score2 = 0;
        if (teamScoresCSV != null) {
            for (i = 0; i < teamScoresCSV.rows.size(); ++i) {
                row = teamScoresCSV.rows.get(i);
                String team = row.getString("teamId");
                int score = row.getInt("score");
                if (team.equals(team1)) {
                    score1 += score;
                }
                if (!team.equals(team2)) continue;
                score2 += score;
            }
        } else if (botScoresCSV != null) {
            for (i = 0; i < botScoresCSV.rows.size(); ++i) {
                row = botScoresCSV.rows.get(i);
                String team = row.getString("team");
                String botId = row.getString("botId");
                int score = row.getInt("score");
                if (team.equals(team1)) {
                    score1 += score;
                }
                if (!team.equals(team2)) continue;
                score2 += score;
            }
        } else {
            throw new RuntimeException("No bot-scores and no team-scores CSVs! Cannot determine scores.");
        }
        this.info("-- reading zipped log file...");
        MatchLogReader.MatchLogReaderResult log = new MatchLogReader().read(logFileZip, team1, team2);
        TDMOneMatchResult result = this.addResult(team1, team2, score1, score2, log);
        this.info("-- " + result.toString());
    }
}

