/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.tournament.tdm.table.report.one;

import cz.cuni.amis.pogamut.ut2004.tournament.tdm.table.report.one.TDMOneMatchResult;
import cz.cuni.amis.pogamut.ut2004.tournament.tdm.table.report.one.TDMOneMatchTableResults;
import cz.cuni.amis.pogamut.ut2004.tournament.tdm.table.report.one.TDMOneMatchTableTeamResult;
import cz.cuni.amis.pogamut.ut2004.tournament.utils.ExcelReport;
import cz.cuni.amis.utils.FileAppender;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import jxl.write.WritableCell;
import jxl.write.WritableSheet;
import jxl.write.biff.WritableWorkbookImpl;

public class TDMOneMatchExcelReport
extends ExcelReport {
    private File resultDir;
    private File outputFile;
    private String mapName;
    private int mapNumber;
    private TDMOneMatchTableResults table;
    private List<TDMOneMatchTableTeamResult> teams;

    public TDMOneMatchExcelReport(File resultDir, File outputFile, String mapName, int mapNumber) {
        this.resultDir = resultDir;
        this.outputFile = outputFile;
        this.mapName = mapName;
        this.mapNumber = mapNumber;
    }

    public synchronized TDMOneMatchTableResults generate() {
        this.table = this.gatherResults(this.resultDir);
        this.teams = this.table.resolve();
        this.produceExcel(this.outputFile);
        return this.table;
    }

    private TDMOneMatchTableResults gatherResults(File resultDir) {
        this.info("GATHERING RESULTS");
        TDMOneMatchTableResults results = new TDMOneMatchTableResults(this.mapName, this.mapNumber);
        results.probeResults(resultDir, true);
        return results;
    }

    @Override
    protected void produceExcel(File outputFile, WritableWorkbookImpl workbook, WritableSheet sheet) throws Exception {
        this.info("OUTPUTING RESULTS");
        for (TDMOneMatchTableTeamResult team : this.teams) {
            this.info("-- " + team.position + ". " + team.team + " (W" + team.wins + ":D" + team.draws + ":L" + team.loses + ":E" + team.exceptions + ") (F" + team.frags + ":D" + team.deaths + ")");
        }
        ArrayList<TDMOneMatchTableTeamResult> teamsAlpha = new ArrayList<TDMOneMatchTableTeamResult>(this.teams);
        Collections.sort(teamsAlpha, new Comparator<TDMOneMatchTableTeamResult>(){

            @Override
            public int compare(TDMOneMatchTableTeamResult o1, TDMOneMatchTableTeamResult o2) {
                return o1.team.compareTo(o2.team);
            }
        });
        this.info("CREATING EXCEL FILE");
        sheet.addCell((WritableCell)this.newStringCell("A", 0, "TeamDeathMatch Tournament"));
        sheet.addCell((WritableCell)this.newStringCell("A", 1, "Table"));
        sheet.addCell((WritableCell)this.newStringCell("A", 2, ""));
        sheet.addCell(this.center((WritableCell)this.newStringCell("A", 3, "No.")));
        sheet.addCell(this.center((WritableCell)this.newStringCell("B", 3, "Participant")));
        sheet.addCell(this.center((WritableCell)this.newStringCell("C", 3, "Frags")));
        sheet.addCell(this.center((WritableCell)this.newStringCell("D", 3, ":")));
        sheet.addCell(this.center((WritableCell)this.newStringCell("E", 3, "Deaths")));
        sheet.addCell(this.center((WritableCell)this.newStringCell("F", 3, "#Wins")));
        sheet.addCell(this.center((WritableCell)this.newStringCell("G", 3, "#Draws")));
        sheet.addCell(this.center((WritableCell)this.newStringCell("H", 3, "#Loses")));
        sheet.addCell(this.center((WritableCell)this.newStringCell("I", 3, "#Exceptions")));
        int col = 0;
        int row = 3;
        for (TDMOneMatchTableTeamResult team : this.teams) {
            sheet.addCell(this.center((WritableCell)this.newIntCell("A", ++row, team.position)));
            sheet.addCell((WritableCell)this.newStringCell("B", row, team.team));
            sheet.addCell(this.center((WritableCell)this.newIntCell("C", row, team.frags)));
            sheet.addCell(this.center((WritableCell)this.newStringCell("D", row, ":")));
            sheet.addCell(this.center((WritableCell)this.newIntCell("E", row, team.deaths)));
            sheet.addCell(this.center((WritableCell)this.newIntCell("F", row, team.wins)));
            sheet.addCell(this.center((WritableCell)this.newIntCell("G", row, team.draws)));
            sheet.addCell(this.center((WritableCell)this.newIntCell("H", row, team.loses)));
            sheet.addCell(this.center((WritableCell)this.newIntCell("I", row, team.exceptions)));
        }
        int startCol = 10;
        int startRow = 3;
        col = startCol + 1;
        row = startRow;
        sheet.addCell((WritableCell)this.newStringCell(col++, row, "TABLE"));
        for (TDMOneMatchTableTeamResult player : teamsAlpha) {
            sheet.addCell((WritableCell)this.newStringCell(col++, row, ""));
            sheet.addCell(this.center(this.textVertical((WritableCell)this.newStringCell(col++, row, player.team))));
            sheet.addCell((WritableCell)this.newStringCell(col++, row, ""));
        }
        sheet.addCell(this.center(this.textVertical((WritableCell)this.newStringCell(col++, row, "Frags"))));
        sheet.addCell(this.center(this.textVertical((WritableCell)this.newStringCell(col++, row, ""))));
        sheet.addCell(this.center(this.textVertical((WritableCell)this.newStringCell(col++, row, "Deaths"))));
        sheet.addCell(this.center(this.textVertical((WritableCell)this.newStringCell(col++, row, "Wins"))));
        sheet.addCell(this.center(this.textVertical((WritableCell)this.newStringCell(col++, row, "Draws"))));
        sheet.addCell(this.center(this.textVertical((WritableCell)this.newStringCell(col++, row, "Loses"))));
        sheet.addCell(this.center(this.textVertical((WritableCell)this.newStringCell(col++, row, "Exceptions"))));
        for (TDMOneMatchTableTeamResult player1 : teamsAlpha) {
            File exceptions = new File(outputFile.getAbsolutePath() + "." + player1.team + ".errors");
            col = startCol + 1;
            sheet.addCell((WritableCell)this.newStringCell(col++, ++row, player1.team));
            for (TDMOneMatchTableTeamResult player2 : teamsAlpha) {
                if (player1 == player2) {
                    sheet.addCell((WritableCell)this.newStringCell(col++, row, ""));
                    sheet.addCell(this.center((WritableCell)this.newStringCell(col++, row, "X")));
                    sheet.addCell((WritableCell)this.newStringCell(col++, row, ""));
                    continue;
                }
                TDMOneMatchResult match = this.table.getMatchResult(player1.team, player2.team);
                if (match == null) {
                    sheet.addCell(this.center((WritableCell)this.newStringCell(col++, row, "x")));
                    sheet.addCell(this.center((WritableCell)this.newStringCell(col++, row, ":")));
                    sheet.addCell(this.center((WritableCell)this.newStringCell(col++, row, "x")));
                    continue;
                }
                if (match.isException(player1.team)) {
                    sheet.addCell(this.center((WritableCell)this.newStringCell(col++, row, "E")));
                    FileAppender.appendToFile((File)exceptions, (String)match.getExceptionsTrace(player1.team));
                } else {
                    sheet.addCell(this.center((WritableCell)this.newIntCell(col++, row, match.getScore(player1.team))));
                }
                sheet.addCell(this.center((WritableCell)this.newStringCell(col++, row, ":")));
                if (match.isException(player2.team)) {
                    sheet.addCell(this.center((WritableCell)this.newStringCell(col++, row, "E")));
                    continue;
                }
                sheet.addCell(this.center((WritableCell)this.newIntCell(col++, row, match.getScore(player2.team))));
            }
            sheet.addCell(this.center((WritableCell)this.newIntCell(col++, row, player1.frags)));
            sheet.addCell(this.center((WritableCell)this.newStringCell(col++, row, ":")));
            sheet.addCell(this.center((WritableCell)this.newIntCell(col++, row, player1.deaths)));
            sheet.addCell(this.center((WritableCell)this.newIntCell(col++, row, player1.wins)));
            sheet.addCell(this.center((WritableCell)this.newIntCell(col++, row, player1.draws)));
            sheet.addCell(this.center((WritableCell)this.newIntCell(col++, row, player1.loses)));
            sheet.addCell(this.center((WritableCell)this.newIntCell(col++, row, player1.exceptions)));
        }
    }

    public static void main(String[] args) {
        File resultDir = new File("d:\\Workspaces\\MFF\\NAIL068-UmeleBytosti\\Lectures\\AB2018-Labs\\Lab-06-TDM\\Students\\_Results\\1-DM-Rankin-FE\\");
        File outputFile = new File(resultDir, "Result.xls");
        new TDMOneMatchExcelReport(resultDir, outputFile, "DM-Rankin-FE", 1).generate();
        System.out.println("---// DONE //---");
    }
}

