/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */
package cz.cuni.amis.pogamut.ut2004.ut2004testfw.config;

import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004BotConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004MatchConfig;
import cz.cuni.amis.pogamut.ut2004.tournament.match.UT2004NativeBotConfig;

/**
 *
 * @author tommasino
 */
public class BotTemplate {

    /**
     * @parameter
     */
    private String id;
    /**
     * @parameter
     */
    private String type;
    /**
     * @parameter
     */
    private String path;
    /**
     * @parameter
     */
    private int skillLevel;
    /**
     * @parameter
     */
    private boolean observe;

    /**
     *
     * @return
     */
    public boolean observe() {
        return observe;
    }

    /**
     *
     * @return
     */
    public String getId() {
        return id;
    }

    /**
     *
     * @param config
     * @param i
     * @param team
     */
    public void addBot(UT2004MatchConfig config, int i, int team) {
        if (type.equals("native")) {
            config.addNativeBot(createNativeBot(i, team));
        } else {
            config.addBot(createBot(i, team));
        }
    }

    /**
     *
     * @param pos
     * @param team
     * @return
     */
    private UT2004BotConfig createBot(int pos, int team) {
        UT2004BotConfig botConfig;
        botConfig = new UT2004BotConfig();
        botConfig.setBotId(id + pos);
        botConfig.setPathToBotJar(path);
        botConfig.setTeamNumber(team);
        botConfig.setRedirectStdErr(true);
        botConfig.setRedirectStdOut(true);
        return botConfig;
    }

    /**
     *
     * @param pos
     * @param team
     * @return
     */
    private UT2004NativeBotConfig createNativeBot(int pos, int team) {
        UT2004NativeBotConfig nativeBotConfig;
        nativeBotConfig = new UT2004NativeBotConfig();
        nativeBotConfig.setBotId(id + pos);
        nativeBotConfig.setSkillLevel(skillLevel);
        nativeBotConfig.setTeamNumber(team);
        return nativeBotConfig;
    }
}
