/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

package cz.cuni.amis.pogamut.ut2004.ut2004testfw;

import cz.cuni.amis.pogamut.ut2004.tournament.deathmatch.UT2004DeathMatch;
import cz.cuni.amis.pogamut.ut2004.tournament.deathmatch.UT2004DeathMatch1v1;
import cz.cuni.amis.pogamut.ut2004.ut2004testfw.measure.IMeasure;
import cz.cuni.amis.pogamut.ut2004.ut2004testfw.utils.CsvReader;
import cz.cuni.amis.pogamut.ut2004.ut2004testfw.utils.CsvReader.CsvRow;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;

/**
 *
 * @author tommasino
 */
public class MatchesExecutor {

    private ArrayList<MatchConfig> matchSets;
    private ArrayList<IMeasure> measures;
    private String utPath;
    private String botPath;
    private String botName;
    private String outputDirectory;
    private int testId;

    public MatchesExecutor(ArrayList<MatchConfig> matchSets,
            ArrayList<IMeasure> measures,
            String utPath,
            String botPath,
            String botName,
            String outputDirectory
            ){
        this.botName=botName;
        this.botPath=botPath;
        this.matchSets=matchSets;
        this.measures=measures;
        this.outputDirectory=outputDirectory;
        this.utPath = utPath;
        testId = generateTestId();
    }
    

    public UT2004DeathMatch createMatch(MatchConfig config) {
        UT2004DeathMatch1v1 dm = new UT2004DeathMatch1v1(
                utPath,
                config.getMap(),
                botName,
                botPath,
                "Oponent",
                config.getOponentPath());
        dm.setFragLimit(config.getFragLimit());
        dm.setTimeLimitInMinutes(config.getFragLimit());
        return dm.createMatch();
    }

    private void analyzeMatch(int run, UT2004DeathMatch match, MatchConfig config, String outputPath){
        for(IMeasure measure : measures){
            System.out.println(measure.getName());
            measure.init();
            File[] candidates = match.getOutputPath("bots").listFiles();
            ArrayList<File> reports = new ArrayList<File>();
            for(File can : candidates)
                if(can.getName().matches(botName+"_[0-9]{3}\\.csv"))
                    reports.add(can);
            Collections.sort(reports,new Comparator<File>() {
                @Override
                public int compare(File t, File t1) {
                    return (int)(t1.lastModified()-t.lastModified());
                }
            });
            File report = reports.get(0);
            Logger.getLogger(PerformanceReport.class.getName()).log(Level.INFO, "Reading report "+report.getName());
            try {
                CsvReader reader = new CsvReader(report.getAbsolutePath(), ";");
                CsvRow row;
                while((row = reader.readRow())!=null)
                    measure.next(row);
            } catch (FileNotFoundException ex) {
                Logger.getLogger(PerformanceReport.class.getName()).log(Level.SEVERE, null, ex);
            } catch (IOException ex) {
                Logger.getLogger(PerformanceReport.class.getName()).log(Level.SEVERE, null, ex);
            }
            try {
                BufferedWriter out = new BufferedWriter(new FileWriter(outputPath, true));
                out.write(testId+";"+measure.getName()+";"+config.getId()+";"+run+";"+measure.getMeasure()+"\n");
                out.close();
            } catch (IOException ex) {
                Logger.getLogger(PerformanceReport.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    @SuppressWarnings("SleepWhileHoldingLock")
    public void executeMatches(){
        System.out.println("Testing bot: " + botName + "(" + botPath + ")");
        for(MatchConfig config : matchSets){
            for(int i = 0; i < config.getRuns(); i++){
                try{
                    final UT2004DeathMatch match = createMatch(config);
                    match.getLog().setLevel(Level.SEVERE);
                    match.getLog().addConsoleHandler();
                    match.cleanUp();
                            match.run();
                    /*Runnable matchRun = new Runnable(){
                        @Override
                        public void run() {
                        }
                    };
                    Thread matchThread = new Thread(matchRun);
                    matchThread.start();
                    Thread.sleep((TIMEOUT+1)*60000);
                    if(matchThread.isAlive()){
                        matchThread.interrupt();
                        i--;
                        continue;
                    }*/
                    analyzeMatch(i, match, config, outputDirectory+File.separator+"results");
                    File[] output = match.getOutputPath("bots").listFiles();
                    for(File res : output)
                        res.delete();
                }catch(Exception e){
                    i--;
                }
            }
        }
    }

    /**
     * Generates an id of the test, if there was no test before, the id is 1, otherwise it increments the last test id.
     * @return the test id
     */
    private int generateTestId(){
        File idFile = new File(outputDirectory + File.separator + "id");
        int id=-1;
        if(!idFile.exists())
            id = 1;
        else{
            BufferedReader reader = null;
            try {
                reader = new BufferedReader(new FileReader(idFile));
                id = Integer.parseInt(reader.readLine())+1;
            } catch (FileNotFoundException ex) {
                id = 1;
                Logger.getLogger(MatchesExecutor.class.getName()).log(Level.SEVERE, null, ex);
            } catch (IOException ex){
                id = 1;
                Logger.getLogger(MatchesExecutor.class.getName()).log(Level.SEVERE, null, ex);
            } finally {
                if(reader!=null){
                    try {
                        reader.close();
                    } catch (IOException ex) {
                    }
                }
            }
        }
        BufferedWriter out = null;
        try {
            out = new BufferedWriter(new FileWriter(idFile, false));
            out.write(id+"\n");
        } catch (IOException ex) {
            Logger.getLogger(MatchesExecutor.class.getName()).log(Level.SEVERE, null, ex);
        } finally {
            if(out!=null){
                try {
                    out.close();
                } catch (IOException ex) {
                }
            }
        }
        File resultFile = new File(outputDirectory + File.separator + "results");
        if(!resultFile.exists()){
            out = null;
            try {
                out = new BufferedWriter(new FileWriter(resultFile, false));
                out.write("testId;measureName;matchId;runId;measureResult\n");
            } catch (IOException ex) {
                Logger.getLogger(MatchesExecutor.class.getName()).log(Level.SEVERE, null, ex);
            } finally {
                if(out!=null){
                    try {
                        out.close();
                    } catch (IOException ex) {
                    }
                }
            }
        }
        return id;
    }
}
