/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.teamcomm.bot;

import cz.cuni.amis.pogamut.base.agent.IEmbodiedAgent;
import cz.cuni.amis.pogamut.base.agent.module.SensomotoricModule;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.event.IWorldEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.bot.impl.UT2004Bot;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.BeginMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.EndMessage;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Self;
import cz.cuni.amis.pogamut.ut2004.teamcomm.bot.TCEvents;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.client.TCMinaClient;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.messages.TCMessage;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.messages.TCMessageData;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.model.TCChannel;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.model.TCTeam;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.server.messages.TCInfoStatus;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.server.messages.TCInfoTeamChannelBotJoined;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.server.messages.TCInfoTeamChannelBotLeft;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.server.messages.TCInfoTeamChannelCreated;
import cz.cuni.amis.pogamut.ut2004.teamcomm.mina.server.messages.TCInfoTeamChannelDestroyed;
import cz.cuni.amis.pogamut.ut2004.teamcomm.server.protocol.TCControlMessagesTranslator;
import cz.cuni.amis.pogamut.ut2004.teamcomm.server.protocol.messages.TCControlServerAlive;
import cz.cuni.amis.utils.exception.PogamutException;
import cz.cuni.amis.utils.flag.Flag;
import cz.cuni.amis.utils.token.IToken;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class UT2004TCClient
extends SensomotoricModule<UT2004Bot> {
    private UT2004Bot bot;
    private IWorldView botWorldView;
    private IWorldView teamWorldView;
    private IWorldObjectEventListener<Self, WorldObjectUpdatedEvent<Self>> selfListener = new IWorldObjectEventListener<Self, WorldObjectUpdatedEvent<Self>>(){

        public void notify(WorldObjectUpdatedEvent<Self> event) {
            UT2004TCClient.this.selfUpdate(event);
        }
    };
    private IWorldEventListener<BeginMessage> beginMessageListener = new IWorldEventListener<BeginMessage>(){

        public void notify(BeginMessage event) {
            UT2004TCClient.this.beginMessage(event);
        }
    };
    private IWorldEventListener<EndMessage> endMessageListener = new IWorldEventListener<EndMessage>(){

        public void notify(EndMessage event) {
            UT2004TCClient.this.endMessage(event);
        }
    };
    private IWorldEventListener<TCMessage> tcMessageListener = new IWorldEventListener<TCMessage>(){

        public void notify(TCMessage event) {
            UT2004TCClient.this.tcMessage(event);
        }
    };
    private List<TCMessage> current = new ArrayList<TCMessage>();
    private List<TCMessage> incoming = new ArrayList<TCMessage>();
    private TCControlMessagesTranslator tcTranslator;
    private TCEvents tcEvents;
    private Self self;
    private long simTime;
    private TCMinaClient minaClient = null;

    public UT2004TCClient(UT2004Bot bot, IWorldView teamWorldView) {
        super((IEmbodiedAgent)bot);
        this.botWorldView = bot.getWorldView();
        this.teamWorldView = teamWorldView;
        this.tcTranslator = new TCControlMessagesTranslator(this.botWorldView, false);
        this.tcTranslator.enable();
        this.tcEvents = new TCEvents((IWorldView)((UT2004Bot)this.agent).getWorldView()){

            @Override
            public void tcControlServerAlive(TCControlServerAlive event) {
                UT2004TCClient.this.tcControlServerAlive(event);
            }
        };
        this.tcEvents.enableTCEvents();
        bot.getWorldView().addObjectListener(Self.class, WorldObjectUpdatedEvent.class, this.selfListener);
        bot.getWorldView().addEventListener(BeginMessage.class, this.beginMessageListener);
        bot.getWorldView().addEventListener(EndMessage.class, this.endMessageListener);
        this.teamWorldView.addEventListener(TCMessage.class, this.tcMessageListener);
    }

    public boolean isConnected() {
        TCMinaClient mClient = this.minaClient;
        if (mClient == null) {
            return false;
        }
        return (Boolean)mClient.getConnected().getFlag();
    }

    public Flag<Boolean> getConnectedFlag() {
        TCMinaClient mClient = this.minaClient;
        if (mClient == null) {
            return null;
        }
        return mClient.getConnected();
    }

    public boolean isConnected(UnrealId botId) {
        TCMinaClient mClient = this.minaClient;
        if (mClient == null) {
            return false;
        }
        return mClient.isConnected(botId);
    }

    public boolean isConnected(Player bot) {
        TCMinaClient mClient = this.minaClient;
        if (mClient == null) {
            return false;
        }
        return mClient.isConnected(bot);
    }

    public boolean isConnectedToMyTeam(UnrealId botId) {
        TCMinaClient mClient = this.minaClient;
        if (mClient == null) {
            return false;
        }
        return mClient.isConnectedToMyTeam(botId);
    }

    public boolean isConnectedToMyTeam(Player bot) {
        TCMinaClient mClient = this.minaClient;
        if (mClient == null) {
            return false;
        }
        return mClient.isConnectedToMyTeam(bot);
    }

    public boolean isConnectedToChannel(UnrealId botId, int channelId) {
        TCMinaClient mClient = this.minaClient;
        if (mClient == null) {
            return false;
        }
        return mClient.isConnectedToChannel(botId, channelId);
    }

    public boolean isConnectedToChannel(Player bot, int channelId) {
        TCMinaClient mClient = this.minaClient;
        if (mClient == null) {
            return false;
        }
        return mClient.isConnectedToChannel(bot, channelId);
    }

    public boolean isChannelExist(int channelId) {
        TCMinaClient mClient = this.minaClient;
        if (mClient == null) {
            return false;
        }
        return mClient.isChannelExist(channelId);
    }

    public Set<UnrealId> getConnectedAllBots() {
        TCMinaClient mClient = this.minaClient;
        if (mClient == null) {
            return new HashSet<UnrealId>();
        }
        return mClient.getConnectedAllBots();
    }

    public Set<UnrealId> getConnectedTeamBots() {
        TCMinaClient mClient = this.minaClient;
        if (mClient == null) {
            return new HashSet<UnrealId>();
        }
        return mClient.getConnectedTeamBots();
    }

    public Set<UnrealId> getConnectedChannelBots(int channelId) {
        TCMinaClient mClient = this.minaClient;
        if (mClient == null) {
            return new HashSet<UnrealId>();
        }
        return mClient.getConnectedChannelBots(channelId);
    }

    public TCTeam getTeam() {
        TCMinaClient mClient = this.minaClient;
        if (mClient == null) {
            return null;
        }
        return mClient.getTeam();
    }

    public TCChannel getChannel(int channelId) {
        TCMinaClient mClient = this.minaClient;
        if (mClient == null) {
            return null;
        }
        return mClient.getChannel(channelId);
    }

    public TCMinaClient.RequestFuture<TCInfoTeamChannelCreated> requestCreateChannel() {
        TCMinaClient mClient = this.minaClient;
        if (mClient == null) {
            return null;
        }
        return mClient.requestCreateChannel();
    }

    public TCMinaClient.RequestFuture<TCInfoTeamChannelDestroyed> requestDestroyChannel(int channelId) {
        TCMinaClient mClient = this.minaClient;
        if (mClient == null) {
            return null;
        }
        return mClient.requestDestroyChannel(channelId);
    }

    public TCMinaClient.RequestFuture<TCInfoStatus> requestGetStatus() {
        TCMinaClient mClient = this.minaClient;
        if (mClient == null) {
            return null;
        }
        return mClient.requestGetStatus();
    }

    public TCMinaClient.RequestFuture<TCInfoTeamChannelBotJoined> requestJoinChannel(int channelId) {
        TCMinaClient mClient = this.minaClient;
        if (mClient == null) {
            return null;
        }
        return mClient.requestJoinChannel(channelId);
    }

    public TCMinaClient.RequestFuture<TCInfoTeamChannelBotLeft> requestLeaveChannel(int channelId) {
        TCMinaClient mClient = this.minaClient;
        if (mClient == null) {
            return null;
        }
        return mClient.requestLeaveChannel(channelId);
    }

    private boolean sendSanityCheck(TCMessageData data) {
        if (data == null) {
            this.log.warning("data is null, cannot send");
            return false;
        }
        if (data.getMessageType() == null) {
            this.log.warning("data.getMessageType() is null, cannot send");
            return false;
        }
        if (this.minaClient == null) {
            this.log.warning("minaClient is NULL, cannot send: " + data);
            return false;
        }
        if (!((Boolean)this.minaClient.getConnected().getFlag()).booleanValue()) {
            this.log.warning("minaClient is NOT connected, cannot send: " + data);
            return false;
        }
        return true;
    }

    private boolean sendSanityCheck(IToken messageType, Serializable data) {
        if (messageType == null) {
            this.log.warning("messageType is null, cannot send");
            return false;
        }
        if (data == null) {
            this.log.warning("data is null, cannot send");
            return false;
        }
        if (this.minaClient == null) {
            this.log.warning("minaClient is NULL, cannot send: " + data);
            return false;
        }
        if (!((Boolean)this.minaClient.getConnected().getFlag()).booleanValue()) {
            this.log.warning("minaClient is NOT connected, cannot send: " + data);
            return false;
        }
        return true;
    }

    public boolean sendToAll(IToken messageType, Serializable data) {
        if (!this.sendSanityCheck(messageType, data)) {
            return false;
        }
        return this.minaClient.sendToAll(messageType, data);
    }

    public boolean sendToAll(TCMessageData data) {
        if (!this.sendSanityCheck(data)) {
            return false;
        }
        data.setSimTime(this.getSimTime());
        return this.sendToAll(data.getMessageType(), data);
    }

    public boolean sendToTeam(IToken messageType, Serializable data) {
        if (!this.sendSanityCheck(messageType, data)) {
            return false;
        }
        return this.minaClient.sendToTeam(messageType, data);
    }

    public boolean sendToTeam(TCMessageData data) {
        if (!this.sendSanityCheck(data)) {
            return false;
        }
        data.setSimTime(this.getSimTime());
        return this.sendToTeam(data.getMessageType(), data);
    }

    public boolean sendToChannel(int channelId, IToken messageType, Serializable data) {
        if (!this.sendSanityCheck(messageType, data)) {
            return false;
        }
        return this.minaClient.sendToChannel(channelId, messageType, data);
    }

    public boolean sendToChannel(int channelId, TCMessageData data) {
        if (!this.sendSanityCheck(data)) {
            return false;
        }
        data.setSimTime(this.getSimTime());
        return this.sendToChannel(channelId, data.getMessageType(), data);
    }

    public boolean sendToBot(UnrealId bot, IToken messageType, Serializable data) {
        if (!this.sendSanityCheck(messageType, data)) {
            return false;
        }
        return this.minaClient.sendPrivate(bot, messageType, data);
    }

    public boolean sendToBot(UnrealId bot, TCMessageData data) {
        if (!this.sendSanityCheck(data)) {
            return false;
        }
        data.setSimTime(this.getSimTime());
        return this.sendToBot(bot, data.getMessageType(), data);
    }

    public boolean sendToAllOthers(IToken messageType, Serializable data) {
        if (!this.sendSanityCheck(messageType, data)) {
            return false;
        }
        return this.minaClient.sendToAllOthers(messageType, data);
    }

    public boolean sendToAllOthers(TCMessageData data) {
        if (!this.sendSanityCheck(data)) {
            return false;
        }
        data.setSimTime(this.getSimTime());
        return this.sendToAllOthers(data.getMessageType(), data);
    }

    public boolean sendToTeamOthers(IToken messageType, Serializable data) {
        if (!this.sendSanityCheck(messageType, data)) {
            return false;
        }
        return this.minaClient.sendToTeamOthers(messageType, data);
    }

    public boolean sendToTeamOthers(TCMessageData data) {
        if (!this.sendSanityCheck(data)) {
            return false;
        }
        data.setSimTime(this.getSimTime());
        return this.sendToTeamOthers(data.getMessageType(), data);
    }

    public boolean sendToChannelOthers(int channelId, IToken messageType, Serializable data) {
        if (!this.sendSanityCheck(messageType, data)) {
            return false;
        }
        return this.minaClient.sendToChannelOthers(channelId, messageType, data);
    }

    public boolean sendToChannelOthers(int channelId, TCMessageData data) {
        if (!this.sendSanityCheck(data)) {
            return false;
        }
        data.setSimTime(this.getSimTime());
        return this.sendToChannelOthers(channelId, data.getMessageType(), data);
    }

    public List<TCMessage> getMessages() {
        return this.current;
    }

    public UnrealId getBotId() {
        if (this.self == null) {
            throw new PogamutException("Could not retrieve BotId, self is NULL.", this.log, (Object)this);
        }
        return this.self.getBotId();
    }

    public int getBotTeam() {
        if (this.self == null) {
            throw new PogamutException("Could not retrieve bot Team, self is NULL.", this.log, (Object)this);
        }
        return this.self.getTeam();
    }

    public long getSimTime() {
        return this.simTime;
    }

    protected void selfUpdate(WorldObjectUpdatedEvent<Self> event) {
        this.self = (Self)event.getObject();
        if (this.minaClient == null) {
            return;
        }
        if (((Boolean)this.minaClient.getConnected().getFlag()).booleanValue()) {
            return;
        }
        if (((Boolean)this.minaClient.getConnecting().getFlag()).booleanValue()) {
            return;
        }
        this.minaClient.connect();
    }

    protected void beginMessage(BeginMessage event) {
        this.simTime = event.getSimTime();
    }

    protected void endMessage(EndMessage event) {
        this.current.clear();
        List<TCMessage> temp = this.current;
        this.current = this.incoming;
        this.incoming = temp;
    }

    protected void tcControlServerAlive(TCControlServerAlive event) {
        if (this.minaClient == null) {
            if (this.self != null) {
                this.minaClient = new TCMinaClient(this, new InetSocketAddress(event.getHost(), (int)event.getPort()), this.teamWorldView, this.log);
                if (((Boolean)this.minaClient.getConnected().getFlag()).booleanValue()) {
                    return;
                }
                if (((Boolean)this.minaClient.getConnecting().getFlag()).booleanValue()) {
                    return;
                }
                this.minaClient.connect();
            }
        } else if (!event.getHost().equals(this.minaClient.getHost()) || event.getPort().intValue() != this.minaClient.getPort()) {
            this.log.warning("There are multiple TC server connected to the UT2004, currently using " + this.minaClient.getHost() + ":" + this.minaClient.getPort() + ", the other server is listening at " + event.getHost() + ":" + event.getPort());
            return;
        }
    }

    protected void tcMessage(TCMessage event) {
        this.incoming.add(event);
    }

    protected void cleanUp() {
        if (this.minaClient != null) {
            this.minaClient.stop();
            this.minaClient = null;
            this.self = null;
            this.simTime = -1L;
        }
        super.cleanUp();
    }
}

