/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.hideandseek.server;

import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.PlayerMessage;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.HSBotState;
import cz.cuni.amis.pogamut.ut2004.utils.UnrealUtils;
import cz.cuni.amis.utils.maps.LazyMap;
import java.util.Map;

public class HSBotRecord<PLAYER_CONTAINER> {
    private final UnrealId botId;
    private long initTime;
    private long finishTime = -1L;
    private boolean spawned = true;
    private HSBotState botState = HSBotState.RUNNER;
    private int seekerCount = 0;
    private int runnerCount = 0;
    private int score = 0;
    private int runnerCapturedBySeekerScore = 0;
    private Map<UnrealId, Integer> runnerCapturedBySeekerCount = new LazyMap<UnrealId, Integer>(){

        protected Integer create(UnrealId key) {
            return 0;
        }
    };
    private int runnerSpottedBySeekerScore = 0;
    private Map<UnrealId, Integer> runnerSpottedBySeekerCount = new LazyMap<UnrealId, Integer>(){

        protected Integer create(UnrealId key) {
            return 0;
        }
    };
    private int runnerFoulScore = 0;
    private Map<UnrealId, Integer> runnerFoulCount = new LazyMap<UnrealId, Integer>(){

        protected Integer create(UnrealId key) {
            return 0;
        }
    };
    private int runnerSafeScore = 0;
    private Map<UnrealId, Integer> runnerSafeCount = new LazyMap<UnrealId, Integer>(){

        protected Integer create(UnrealId key) {
            return 0;
        }
    };
    private int runnerSurvivedScore = 0;
    private Map<UnrealId, Integer> runnerSurvivedCount = new LazyMap<UnrealId, Integer>(){

        protected Integer create(UnrealId key) {
            return 0;
        }
    };
    private int seekerCapturedRunnerScore = 0;
    private Map<UnrealId, Integer> seekerCapturedRunnerCount = new LazyMap<UnrealId, Integer>(){

        protected Integer create(UnrealId key) {
            return 0;
        }
    };
    private int seekerLetRunnerSurviveScore = 0;
    private Map<UnrealId, Integer> seekerLetRunnerSurviveCount = new LazyMap<UnrealId, Integer>(){

        protected Integer create(UnrealId key) {
            return 0;
        }
    };
    private int seekerLetRunnerEscapeScore = 0;
    private Map<UnrealId, Integer> seekerLetRunnerEscapeCount = new LazyMap<UnrealId, Integer>(){

        protected Integer create(UnrealId key) {
            return 0;
        }
    };
    private int seekerSpottedRunnerScore = 0;
    private Map<UnrealId, Integer> seekerSpottedRunnerCount = new LazyMap<UnrealId, Integer>(){

        protected Integer create(UnrealId key) {
            return 0;
        }
    };
    private int seekerFoulScore = 0;
    private int seekerFoulCount;
    private double timeAtRestrictedArea;
    private boolean inGame = false;
    private PLAYER_CONTAINER player;

    public HSBotRecord(UnrealId botId) {
        this.botId = botId;
    }

    public long getInitTime() {
        return this.initTime;
    }

    public void setInitTime(long initTime) {
        this.initTime = initTime;
    }

    public long getFinishTime() {
        return this.finishTime;
    }

    public void setFinishTime(long finishTime) {
        this.finishTime = finishTime;
    }

    public HSBotState getBotState() {
        return this.botState;
    }

    public void setBotState(HSBotState botState) {
        this.botState = botState;
    }

    public boolean isInGame() {
        return this.inGame;
    }

    public void setInGame(boolean inGame) {
        this.inGame = inGame;
    }

    public boolean isSpawned() {
        return this.spawned;
    }

    public void setSpawned(boolean spawned) {
        this.spawned = spawned;
    }

    public UnrealId getBotId() {
        return this.botId;
    }

    public boolean isBot() {
        return UnrealUtils.isBotId((UnrealId)this.botId);
    }

    public String getBotName() {
        if (this.player instanceof PlayerMessage) {
            return ((PlayerMessage)this.player).getName();
        }
        if (this.player instanceof Player) {
            return ((Player)this.player).getName();
        }
        return null;
    }

    public int getSeekerCount() {
        return this.seekerCount;
    }

    public int getRunnerCount() {
        return this.runnerCount;
    }

    public int getScore() {
        return this.score;
    }

    public void setScore(int value) {
        this.score = value;
    }

    public int getRunnerCapturedBySeekerScore() {
        return this.runnerCapturedBySeekerScore;
    }

    public Map<UnrealId, Integer> getRunnerCapturedBySeekerCount() {
        return this.runnerCapturedBySeekerCount;
    }

    public int getRunnerSpottedBySeekerScore() {
        return this.runnerSpottedBySeekerScore;
    }

    public Map<UnrealId, Integer> getRunnerSpottedBySeekerCount() {
        return this.runnerSpottedBySeekerCount;
    }

    public int getRunnerFoulScore() {
        return this.runnerFoulScore;
    }

    public Map<UnrealId, Integer> getRunnerFoulCount() {
        return this.runnerFoulCount;
    }

    public int getRunnerSafeScore() {
        return this.runnerSafeScore;
    }

    public Map<UnrealId, Integer> getRunnerSafeCount() {
        return this.runnerSafeCount;
    }

    public int getRunnerSurvivedScore() {
        return this.runnerSurvivedScore;
    }

    public Map<UnrealId, Integer> getRunnerSurvivedCount() {
        return this.runnerSurvivedCount;
    }

    public int getSeekerCapturedRunnerScore() {
        return this.seekerCapturedRunnerScore;
    }

    public Map<UnrealId, Integer> getSeekerCapturedRunnerCount() {
        return this.seekerCapturedRunnerCount;
    }

    public int getSeekerLetRunnerEscapeScore() {
        return this.seekerLetRunnerEscapeScore;
    }

    public Map<UnrealId, Integer> getSeekerLetRunnerEscapeCount() {
        return this.seekerLetRunnerEscapeCount;
    }

    public int getSeekerLetRunnerSurviveScore() {
        return this.seekerLetRunnerSurviveScore;
    }

    public Map<UnrealId, Integer> getSeekerLetRunnerSurviveCount() {
        return this.seekerLetRunnerSurviveCount;
    }

    public int getSeekerSpottedRunnerScore() {
        return this.seekerSpottedRunnerScore;
    }

    public Map<UnrealId, Integer> getSeekerSpottedRunnerCount() {
        return this.seekerSpottedRunnerCount;
    }

    public double getTimeAtRestrictedArea() {
        return this.timeAtRestrictedArea;
    }

    public void setTimeAtRestrictedArea(double timeAtRestrictedArea) {
        this.timeAtRestrictedArea = timeAtRestrictedArea;
    }

    public void setSeekerForThisRound() {
        this.botState = HSBotState.SEEKER;
        ++this.seekerCount;
    }

    public void setRunnerForThisRound() {
        this.botState = HSBotState.RUNNER;
        ++this.runnerCount;
    }

    public void runnerCapturedBySeeker(int scoreDelta, UnrealId seekerId) {
        if (this.botState == HSBotState.SEEKER) {
            throw new RuntimeException("SEEKER cannot be captured!");
        }
        this.botState = HSBotState.RUNNER_CAPTURED;
        this.score += scoreDelta;
        this.runnerCapturedBySeekerScore += scoreDelta;
        this.runnerCapturedBySeekerCount.put(seekerId, this.runnerCapturedBySeekerCount.get(seekerId) + 1);
    }

    public void runnerFauled(int scoreDelta, UnrealId seekerId) {
        if (this.botState == HSBotState.SEEKER) {
            throw new RuntimeException("SEEKER cannot be runner-fauled!");
        }
        this.botState = HSBotState.RUNNER_FAULED;
        this.score += scoreDelta;
        this.runnerFoulScore += scoreDelta;
        this.runnerFoulCount.put(seekerId, this.runnerFoulCount.get(seekerId) + 1);
    }

    public void runnerSafe(int scoreDelta, UnrealId seekerId) {
        if (this.botState == HSBotState.SEEKER) {
            throw new RuntimeException("SEEKER cannot be safe!");
        }
        this.botState = HSBotState.RUNNER_SAFE;
        this.score += scoreDelta;
        this.runnerSafeScore += scoreDelta;
        this.runnerSafeCount.put(seekerId, this.runnerSafeCount.get(seekerId) + 1);
    }

    public void runnerSpottedBySeeker(int scoreDelta, UnrealId seekerId) {
        if (this.botState == HSBotState.SEEKER) {
            throw new RuntimeException("SEEKER cannot be spotted!");
        }
        this.botState = HSBotState.RUNNER_SPOTTED;
        this.score += scoreDelta;
        this.runnerSpottedBySeekerScore += scoreDelta;
        this.runnerSpottedBySeekerCount.put(seekerId, this.runnerSpottedBySeekerCount.get(seekerId) + 1);
    }

    public void runnerSurvived(int scoreDelta, UnrealId seekerId) {
        if (this.botState == HSBotState.SEEKER) {
            throw new RuntimeException("SEEKER cannot survive!");
        }
        this.botState = HSBotState.RUNNER_SURVIVED;
        this.score += scoreDelta;
        this.runnerSurvivedScore += scoreDelta;
        this.runnerSurvivedCount.put(seekerId, this.runnerSurvivedCount.get(seekerId) + 1);
    }

    public void seekerCapturedRunner(int scoreDelta, UnrealId runnerId) {
        if (this.botState != HSBotState.SEEKER) {
            throw new RuntimeException("RUNNER cannot capture!");
        }
        this.score += scoreDelta;
        this.seekerCapturedRunnerScore += scoreDelta;
        this.seekerCapturedRunnerCount.put(runnerId, this.seekerCapturedRunnerCount.get(runnerId) + 1);
    }

    public void seekerLetRunnerEscape(int scoreDelta, UnrealId runnerId) {
        if (this.botState != HSBotState.SEEKER) {
            throw new RuntimeException("RUNNER cannot let other runner escape!");
        }
        this.score += scoreDelta;
        this.seekerLetRunnerEscapeScore += scoreDelta;
        this.seekerLetRunnerEscapeCount.put(runnerId, this.seekerLetRunnerEscapeCount.get(runnerId) + 1);
    }

    public void seekerLetRunnerSurvive(int scoreDelta, UnrealId runnerId) {
        if (this.botState != HSBotState.SEEKER) {
            throw new RuntimeException("RUNNER cannot let other runner survive!");
        }
        this.score += scoreDelta;
        this.seekerLetRunnerSurviveScore += scoreDelta;
        this.seekerLetRunnerSurviveCount.put(runnerId, this.seekerLetRunnerSurviveCount.get(runnerId) + 1);
    }

    public void seekerSpottedRunner(int scoreDelta, UnrealId runnerId) {
        if (this.botState != HSBotState.SEEKER) {
            throw new RuntimeException("RUNNER cannot spot other runners!");
        }
        this.score += scoreDelta;
        this.seekerSpottedRunnerScore += scoreDelta;
        this.seekerSpottedRunnerCount.put(runnerId, this.seekerSpottedRunnerCount.get(runnerId) + 1);
    }

    public void seekerFauled(int scoreDelta, UnrealId seekerId) {
        if (this.botState == HSBotState.SEEKER_FOULED) {
            return;
        }
        if (this.botState != HSBotState.SEEKER) {
            throw new RuntimeException(this.botState.name() + " cannot be seeker-fauled!");
        }
        this.botState = HSBotState.SEEKER_FOULED;
        this.score += scoreDelta;
        this.seekerFoulScore += scoreDelta;
        ++this.seekerFoulCount;
    }

    public void reset() {
        this.initTime = System.currentTimeMillis();
        this.finishTime = -1L;
        this.botState = HSBotState.RUNNER;
        this.spawned = true;
        this.runnerCount = 0;
        this.seekerCount = 0;
        this.score = 0;
        this.runnerCapturedBySeekerCount.clear();
        this.runnerCapturedBySeekerScore = 0;
        this.runnerFoulCount.clear();
        this.runnerFoulScore = 0;
        this.runnerSafeCount.clear();
        this.runnerSafeScore = 0;
        this.runnerSpottedBySeekerCount.clear();
        this.runnerSpottedBySeekerScore = 0;
        this.runnerSurvivedCount.clear();
        this.runnerSurvivedScore = 0;
        this.seekerCapturedRunnerCount.clear();
        this.seekerCapturedRunnerScore = 0;
        this.seekerLetRunnerEscapeCount.clear();
        this.seekerLetRunnerEscapeScore = 0;
        this.seekerLetRunnerSurviveCount.clear();
        this.seekerLetRunnerSurviveScore = 0;
        this.seekerSpottedRunnerCount.clear();
        this.seekerSpottedRunnerScore = 0;
        this.seekerFoulCount = 0;
        this.seekerFoulScore = 0;
    }

    public PLAYER_CONTAINER getPlayer() {
        return this.player;
    }

    public void setPlayer(PLAYER_CONTAINER player) {
        this.player = player;
    }
}

