/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.hideandseek.protocol;

import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.hideandseek.protocol.messages.HSGameStart;
import java.util.Formatter;

public class HSGameConfig {
    private int observerPort = 3002;
    private String targetMap;
    private Location safeArea;
    private int roundCount;
    private double roundTimeUT;
    private double hideTimeUT;
    private double restrictedAreaTimeUT;
    private int safeAreaRadius;
    private int restrictedAreaRadius;
    private int spotTimeMillis = 600;
    private int spawnRadiusForRunners = 100;
    private boolean fixedSeeker;
    private String fixedSeekerName;
    private int runnerCaptured = -10;
    private int runnerFouled = -1000;
    private int runnerSafe = 100;
    private int runnerSpotted = 0;
    private int runnerSurvived = 50;
    private int seekerSpottedRunner = 20;
    private int seekerCapturedRunner = 100;
    private int seekerLetRunnerSurvive = -10;
    private int seekerLetRunnerEscape = -20;

    public HSGameConfig() {
    }

    public HSGameConfig(HSGameStart msg) {
        this.hideTimeUT = msg.getHideTimeUT();
        this.restrictedAreaRadius = msg.getRestrictedAreaRadius();
        this.restrictedAreaTimeUT = msg.getRestrictedAreaTimeUT();
        this.roundCount = msg.getRoundCount();
        this.roundTimeUT = msg.getRoundTimeUT();
        this.safeArea = msg.getSafeArea();
        this.safeAreaRadius = msg.getSafeAreaRadius();
        this.fixedSeeker = msg.getFixedSeeker();
        this.fixedSeekerName = msg.getFixedSeekerName();
        this.readScoring(msg.getScoring());
    }

    public int getObserverPort() {
        return this.observerPort;
    }

    public void setObserverPort(int observerPort) {
        this.observerPort = observerPort;
    }

    public String getTargetMap() {
        return this.targetMap;
    }

    public void setTargetMap(String targetMap) {
        this.targetMap = targetMap;
    }

    public int getRoundCount() {
        return this.roundCount;
    }

    public void setRoundCount(int roundCount) {
        this.roundCount = roundCount;
    }

    public double getRoundTimeUT() {
        return this.roundTimeUT;
    }

    public void setRoundTimeUT(double roundTimeUT) {
        this.roundTimeUT = roundTimeUT;
    }

    public double getHideTimeUT() {
        return this.hideTimeUT;
    }

    public void setHideTimeUT(double hideTimeUT) {
        this.hideTimeUT = hideTimeUT;
    }

    public double getRestrictedAreaTimeUT() {
        return this.restrictedAreaTimeUT;
    }

    public void setRestrictedAreaTimeUT(double restrictedAreaTimeUT) {
        this.restrictedAreaTimeUT = restrictedAreaTimeUT;
    }

    public Location getSafeArea() {
        return this.safeArea;
    }

    public void setSafeArea(Location safeArea) {
        this.safeArea = safeArea;
    }

    public int getSafeAreaRadius() {
        return this.safeAreaRadius;
    }

    public void setSafeAreaRadius(int safeAreaRadius) {
        this.safeAreaRadius = safeAreaRadius;
    }

    public int getRestrictedAreaRadius() {
        return this.restrictedAreaRadius;
    }

    public void setRestrictedAreaRadius(int restrictedAreaRadius) {
        this.restrictedAreaRadius = restrictedAreaRadius;
    }

    public boolean isFixedSeeker() {
        return this.fixedSeeker;
    }

    public void setFixedSeeker(boolean fixedSeeker) {
        this.fixedSeeker = fixedSeeker;
    }

    public String getFixedSeekerName() {
        return this.fixedSeekerName;
    }

    public void setFixedSeekerName(String fixedSeekerName) {
        this.fixedSeekerName = fixedSeekerName;
    }

    public int getSpotTimeMillis() {
        return this.spotTimeMillis;
    }

    public void setSpotTimeMillis(int spotTimeMillis) {
        this.spotTimeMillis = spotTimeMillis;
    }

    public int getSpawnRadiusForRunners() {
        return this.spawnRadiusForRunners;
    }

    public void setSpawnRadiusForRunners(int spawnRadiusForRunners) {
        this.spawnRadiusForRunners = spawnRadiusForRunners;
    }

    public int getRunnerCaptured() {
        return this.runnerCaptured;
    }

    public void setRunnerCaptured(int runnerCaptured) {
        this.runnerCaptured = runnerCaptured;
    }

    public int getRunnerFouled() {
        return this.runnerFouled;
    }

    public void setRunnerFouled(int runnerFouled) {
        this.runnerFouled = runnerFouled;
    }

    public int getRunnerSafe() {
        return this.runnerSafe;
    }

    public void setRunnerSafe(int runnerSafe) {
        this.runnerSafe = runnerSafe;
    }

    public int getRunnerSpotted() {
        return this.runnerSpotted;
    }

    public void setRunnerSpotted(int runnerSpotted) {
        this.runnerSpotted = runnerSpotted;
    }

    public int getRunnerSurvived() {
        return this.runnerSurvived;
    }

    public void setRunnerSurvived(int runnerSurvived) {
        this.runnerSurvived = runnerSurvived;
    }

    public int getSeekerSpottedRunner() {
        return this.seekerSpottedRunner;
    }

    public void setSeekerSpottedRunner(int seekerSpottedRunner) {
        this.seekerSpottedRunner = seekerSpottedRunner;
    }

    public int getSeekerCapturedRunner() {
        return this.seekerCapturedRunner;
    }

    public void setSeekerCapturedRunner(int seekerCapturedRunner) {
        this.seekerCapturedRunner = seekerCapturedRunner;
    }

    public int getSeekerLetRunnerSurvive() {
        return this.seekerLetRunnerSurvive;
    }

    public void setSeekerLetRunnerSurvive(int seekerLetRunnerSurvive) {
        this.seekerLetRunnerSurvive = seekerLetRunnerSurvive;
    }

    public int getSeekerLetRunnerEscape() {
        return this.seekerLetRunnerEscape;
    }

    public void setSeekerLetRunnerEscape(int seekerLetRunnerEscape) {
        this.seekerLetRunnerEscape = seekerLetRunnerEscape;
    }

    public String writeScoring() {
        return this.runnerCaptured + ";" + this.runnerFouled + ";" + this.runnerSafe + ";" + this.runnerSpotted + ";" + this.runnerSurvived + ";" + this.seekerSpottedRunner + ";" + this.seekerCapturedRunner + ";" + this.seekerLetRunnerSurvive + ";" + this.seekerLetRunnerEscape + ";" + this.spotTimeMillis + ";" + this.spawnRadiusForRunners + ";" + this.targetMap;
    }

    public void readScoring(String scoring) {
        String[] scores = scoring.split(";");
        if (scores.length != 12) {
            throw new RuntimeException("Invalid scoring string, does not contain 8 numbers separated by ';', string: '" + scoring + "'.");
        }
        this.runnerCaptured = Integer.parseInt(scores[0]);
        this.runnerFouled = Integer.parseInt(scores[1]);
        this.runnerSafe = Integer.parseInt(scores[2]);
        this.runnerSpotted = Integer.parseInt(scores[3]);
        this.runnerSurvived = Integer.parseInt(scores[4]);
        this.seekerSpottedRunner = Integer.parseInt(scores[5]);
        this.seekerCapturedRunner = Integer.parseInt(scores[6]);
        this.seekerLetRunnerSurvive = Integer.parseInt(scores[7]);
        this.seekerLetRunnerEscape = Integer.parseInt(scores[8]);
        this.spotTimeMillis = Integer.parseInt(scores[9]);
        this.spawnRadiusForRunners = Integer.parseInt(scores[10]);
        this.targetMap = scores[11];
    }

    public String getCSVHeader() {
        return "Map;FixedSeeker;FixedSeekerName;RoundCount;RoundTimeSecs;HideTimeSecs;RestrictedAreaTimeSecs;SafeArea;SafeAreaRadius;RestrictedAreaRadius;SpotTimeMillis;SpawnRadiusForRunners;ScoreRunnerCaptured;ScoreRunnerSpotted;ScoreRunnerSafe;ScoreRunnerSurvived;ScoreRunnerFouled;ScoreSeekerCapturedRunner;ScoreSeekerSpottedRunner;ScoreSeekerLetRunnerSurvive;ScoreSeekerLetRunnerEscape";
    }

    public void formatCSVLine(Formatter writer) {
        writer.format("%s;", this.targetMap);
        writer.format("%s;", String.valueOf(this.fixedSeeker));
        writer.format("%s;", String.valueOf(this.fixedSeekerName));
        writer.format("%d;", this.roundCount);
        writer.format("%.3f;", this.roundTimeUT);
        writer.format("%.3f;", this.hideTimeUT);
        writer.format("%.3f;", this.restrictedAreaTimeUT);
        writer.format("%s;", this.safeArea == null ? "null" : this.safeArea.toString().replaceAll(";", "|"));
        writer.format("%d;", this.safeAreaRadius);
        writer.format("%d;", this.restrictedAreaRadius);
        writer.format("%d;", this.spotTimeMillis);
        writer.format("%d;", this.spawnRadiusForRunners);
        writer.format("%d;", this.runnerCaptured);
        writer.format("%d;", this.runnerSpotted);
        writer.format("%d;", this.runnerSafe);
        writer.format("%d;", this.runnerSurvived);
        writer.format("%d;", this.runnerFouled);
        writer.format("%d;", this.seekerCapturedRunner);
        writer.format("%d;", this.seekerSpottedRunner);
        writer.format("%d;", this.seekerLetRunnerSurvive);
        writer.format("%d", this.seekerLetRunnerEscape);
    }
}

