/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.hideandseek.observer;

import com.google.inject.Inject;
import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.messages.CommandMessage;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectUpdatedEvent;
import cz.cuni.amis.pogamut.base.component.bus.IComponentBus;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.ut2004.agent.params.UT2004AgentParameters;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.ConfigurationObserver;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbcommands.InitializeObserver;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.Player;
import cz.cuni.amis.pogamut.ut2004.communication.worldview.UT2004WorldView;
import cz.cuni.amis.pogamut.ut2004.hideandseek.observer.HSObserverParams;
import cz.cuni.amis.pogamut.ut2004.observer.impl.UT2004Observer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HSObserver
extends UT2004Observer {
    private boolean observing = false;
    private IWorldObjectEventListener<Player, WorldObjectUpdatedEvent<Player>> playerUpdatedListener = new IWorldObjectEventListener<Player, WorldObjectUpdatedEvent<Player>>(){

        public void notify(WorldObjectUpdatedEvent<Player> event) {
            HSObserver.this.playerUpdated(event);
        }
    };
    private Map<Player, Long> visibleSinceMillis = new HashMap<Player, Long>();

    @Inject
    public HSObserver(UT2004AgentParameters params, IComponentBus bus, IAgentLogger agentLogger, UT2004WorldView worldView, IAct act) {
        super(params, bus, agentLogger, worldView, act);
        if (!(params instanceof HSObserverParams)) {
            throw new RuntimeException("HSObserver must be instantiated with HSObserverParams not " + params.getClass().getSimpleName() + ".");
        }
        this.getLogger().addDefaultConsoleHandler();
    }

    public HSObserverParams getParams() {
        return (HSObserverParams)super.getParams();
    }

    protected void startAgent() {
        super.startAgent();
        ((UT2004WorldView)this.getWorldView()).addObjectListener(Player.class, WorldObjectUpdatedEvent.class, this.playerUpdatedListener);
        this.configureObserver();
    }

    public void configureObserver() {
        this.getAct().act((CommandMessage)new InitializeObserver().setId(this.getParams().getBotIdToObserve()));
        this.getAct().act((CommandMessage)new ConfigurationObserver().setAll(Boolean.valueOf(true)).setUpdate(Double.valueOf(0.21)).setSelf(Boolean.valueOf(false)).setAsync(Boolean.valueOf(false)).setGame(Boolean.valueOf(false)).setSee(Boolean.valueOf(true)).setSpecial(Boolean.valueOf(false)));
        this.log.info("START OBSERVING: " + this.getParams().getBotIdToObserve());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void playerUpdated(WorldObjectUpdatedEvent<Player> event) {
        Player player = (Player)event.getObject();
        if (player.isVisible()) {
            Map<Player, Long> map = this.visibleSinceMillis;
            synchronized (map) {
                if (this.visibleSinceMillis.containsKey(player)) {
                    return;
                }
                this.visibleSinceMillis.put(player, System.currentTimeMillis());
            }
        }
        Map<Player, Long> map = this.visibleSinceMillis;
        synchronized (map) {
            if (this.visibleSinceMillis.containsKey(player)) {
                this.visibleSinceMillis.remove(player);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Player> getPlayersVisibleMoreThanMillis(long millis) {
        ArrayList<Player> result = new ArrayList<Player>(this.visibleSinceMillis.size());
        long currTime = System.currentTimeMillis();
        Map<Player, Long> map = this.visibleSinceMillis;
        synchronized (map) {
            for (Map.Entry<Player, Long> entry : this.visibleSinceMillis.entrySet()) {
                double visibleFor = currTime - entry.getValue();
                if (!(visibleFor > (double)millis)) continue;
                result.add(entry.getKey());
            }
        }
        return result;
    }
}

