package cz.cuni.amis.pogamut.sposh.usar2004.senses;

import cz.cuni.amis.pogamut.sposh.context.USAR2004Context;
import cz.cuni.amis.pogamut.sposh.engine.VariableContext;
import cz.cuni.amis.pogamut.sposh.executor.PrimitiveInfo;
import cz.cuni.amis.pogamut.sposh.executor.StateSense;

/**
 * Sense for checking the battery level.
 *
 * @author vejmanm
 */
@PrimitiveInfo(name = "BatteryLeft", description = "How much battery time is left for the robot to operate?")
public class BatteryLeft extends StateSense<USAR2004Context, Integer>
{
    public BatteryLeft(USAR2004Context ctx)
    {
        super("BatteryLeft", ctx);
    }

    @Override
    public Integer query(VariableContext params)
    {
        return ctx.getBatteryLeft();
    }
}
