package cz.cuni.amis.pogamut.sposh.context;

import java.util.Random;
import java.util.logging.Level;

import cz.cuni.amis.pogamut.base.communication.command.IAct;
import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.AnnotationListenerRegistrator;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.EventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectClassEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectClassListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.listener.annotation.ObjectListener;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.usar2004.agent.USAR2004Bot;
import cz.cuni.amis.pogamut.usar2004.agent.USAR2004BotController;
import cz.cuni.amis.pogamut.usar2004.agent.module.datatypes.VehicleType;
import cz.cuni.amis.pogamut.usar2004.agent.module.master.StateMasterModule;
import cz.cuni.amis.pogamut.usar2004.agent.module.sensor.SuperSensor;
import cz.cuni.amis.pogamut.usar2004.agent.module.state.SuperState;

import java.util.List;

/**
 * Primitive State Context for UT2004.
 *
 * @author Honza
 */
public class USAR2004Context<BOT extends USAR2004Bot> extends Context<BOT> implements IUSAR2004Context<BOT>
{
    /**
     * Random number generator that is usually useful to have during decision
     * making.
     */
    protected Random random = new Random(System.currentTimeMillis());
    /**
     * Alias for user's log.
     */
    protected LogCategory log = null;
    /**
     * Listener registrator that probes declared methods for the presence of {@link EventListener}, {@link ObjectClassEventListener},
     * {@link ObjectClassListener}, {@link ObjectEventListener} and {@link ObjectListener}
     * annotations and automatically registers them as listeners on a specific
     * events. <p><p> Note that this registrator is usable for 'this' object
     * only! It will work only for 'this' object.
     */
    protected AnnotationListenerRegistrator listenerRegistrator;
    /**
     * Shortcut for the {@link UT2004BotModuleController#getWorldView()}.
     */
    protected IWorldView world;
    /**
     * Shortcut for the {@link UT2004BotModuleController#getAct()}.
     */
    protected IAct act;

    public USAR2004Context(String name, BOT bot)
    {
        super(name, bot);
        log = bot.getLogger().getCategory(USAR2004BotController.USER_LOG_CATEGORY_ID);
        log.setLevel(Level.ALL);
    }

    /**
     * Called after the construction of the {@link UT2004Behaviour} before the
     * GameBots2004 greets the bot even before
     * {@link UT2004Behaviour#prepareBehaviour(UT2004Bot)} method. <p><p>
     * <b>NOTE:</b> This is Pogamut's developers reserved method - do not
     * override it and if you do, always use 'super' to call parent's
     * initializeBehaviour.
     */
    protected void initialize()
    {
        initializeModules(bot);
        initializeListeners(bot);
    }

    /**
     * Initializes {@link UT2004Behaviour#listenerRegistrator} and calls {@link AnnotationListenerRegistrator#addListeners()}
     * method to probe all declared methods for event-annotation presence.
     *
     * @param bot
     */
    protected void initializeListeners(BOT bot)
    {
        listenerRegistrator = new AnnotationListenerRegistrator(this, getWorldView(), bot.getLogger().getCategory("Listeners"));
        listenerRegistrator.addListeners();
    }

    /**
     * Initializes memory/command modules of the bot.
     *
     * @param bot
     */
    protected void initializeModules(BOT bot)
    {
        world = getWorldView();
        act = getAct();

        //added
        stateModule = StateMasterModule.getModuleInstance(bot);
        System.out.println("initModules-from init");

        //
    }

    /**
     * Called after the behaviour construction to initialize user's data
     * structures.
     *
     * @param bot
     */
    protected void prepareBehaviour(BOT bot)
    {
        System.out.println("prepareBeh");
    }

    /**
     * Called after {@link UT2004Behaviour#botFirstSpawn(GameInfo, ConfigChange, InitedMessage, Self)}
     * as a hook for Pogamut's core developers to finalize initialization of
     * various modules. <p><p> <b>NOTE:</b> This is Pogamut's developers
     * reserved method - do not override it and if you do, always use 'super' to
     * call parent's finishControllerInitialization.
     */
    @Override
    public void finishInitialization()
    {
        System.out.println("finishInit");
    }

    /**
     * This method is called before the SPOSH iteration is invoked. You may
     * clear previous-state variables here.
     */
    public void logicIteration()
    {
        System.out.println("logicIter");
    }
    //<editor-fold defaultstate="collapsed" desc="State module related methods">
    /**
     * State module should be handy any time dealing with robots. Not only is
     * the logic method triggered by state messages but they really provide
     * essentials such as time, type of the robot and the battery left.
     */
    protected StateMasterModule stateModule;

    public StateMasterModule getStateModule()
    {
        return stateModule;
    }

    /**
     * If state module is ready and has acquired a message already, it returns
     * the battery left. Note that this method returns the first state message
     * if ready. So this works propperly for single robot session.
     *
     * @return Returns battery left.
     */
    public int getBatteryLeft()
    {
        if(!stateModule.isReady())
        {
            return -1;
        }
        List<SuperState> states = stateModule.getStatesByClass(SuperState.class);
        return states.get(0).getBattery();
    }

    /**
     * If state module is ready and has acquired a message already, it returns
     * the time since the server has started. Note that this method returns the
     * first state message if ready. So this works propperly for single robot
     * session.
     *
     * @return Returns time since.
     */
    public double getTime()
    {
        if(!stateModule.isReady())
        {
            return -1;
        }
        List<SuperState> states = stateModule.getStatesByClass(SuperState.class);
        return states.get(0).getTime();
    }

    //</editor-fold>
    public IWorldView getWorldView()
    {
        return bot.getWorldView();
    }

    public IAct getAct()
    {
        return bot.getAct();
    }

    public Random getRandom()
    {
        return random;
    }

    public LogCategory getLog()
    {
        return log;
    }

    public AnnotationListenerRegistrator getListenerRegistrator()
    {
        return listenerRegistrator;
    }

    public IWorldView getWorld()
    {
        return world;
    }
}
