class SpyVsSpyBotConnection extends BotConnection;

static function SendNotifyDoorStateChanged(string doorFrom, string doorTo, bool opened){
        local string message;

	message = "DOORSTATECHANGED {DoorFrom " $ doorFrom $ "} {DoorTo " $ doorTo $ "} {Opened " $ opened $ "}";

        SendMessageToAll(message);
}


function ProcessRegularAction(string cmdType)
{
	switch(cmdType){
			/* This is our custom command name*/
			case "CHANGEDOOR":
				ReceivedChangeDoorState();
			break;
		default:
			super.ProcessRegularAction(cmdType);
	}

}

function ReceivedChangeDoorState(){
    local Sequence GameSeq;
    local array<SequenceObject> AllDoorEvents;
    local array<int> ActivateIndices;
    local int i;
	local string doorFrom;
	local string doorTo;
	local bool open;
	local bool result;
	local SeqEvent_ExternalDoorStateChange doorChangeEvent;

	doorFrom = GetArgVal("DoorFrom");
	doorTo = GetArgVal("DoorTo");
	open = bool(GetArgVal("Open"));

    //`log("Interrupt " $ doorFrom $ " " $ doorTo $ " " $ open);


    GameSeq = WorldInfo.GetGameSequence();
    if (GameSeq != None)
    {

        // find all instance of our event
        GameSeq.FindSeqObjectsByClass(class'SeqEvent_ExternalDoorStateChange', true, AllDoorEvents);

        //choose the right activation link number
        if(open){
                ActivateIndices[0] = 0; 
        } else {
                ActivateIndices[0] = 1;
        }
        for (i = 0; i < AllDoorEvents.Length; i++)
        {
			doorChangeEvent = SeqEvent_ExternalDoorStateChange(AllDoorEvents[i]);
			if( (doorChangeEvent.DoorFrom == doorFrom && doorChangeEvent.DoorTo == doorTo) 
				|| (doorChangeEvent.DoorFrom == doorTo && doorChangeEvent.DoorTo == doorFrom)
				){
				result = doorChangeEvent.CheckActivate(WorldInfo, None, false, ActivateIndices);
				//`log("Activated " $ doorChangeEvent $ " " $ ActivateIndices[0] $ " " $ result);
			}
        }
    }
}


