/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathPlanner.polygonPathFunnel;

import com.google.common.collect.Lists;
import cz.cuni.amis.pogamut.base3d.worldview.object.ILocated;
import cz.cuni.amis.pogamut.base3d.worldview.object.Location;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshBoundary;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathPlanner.polygonPathFunnel.Funnel;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathPlanner.polygonPathFunnel.FunnelDebug;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathPlanner.polygonPathFunnel.FunnelRay;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.pathPlanner.polygonPathFunnel.FunnelZone;
import java.util.ArrayList;
import java.util.List;
import math.geom3d.plane.Plane3D;
import math.geom3d.plane.Plane3DCoordinateSubsystem;

public class PolygonPathSmoothingFunnelAlgorithm {
    public static final Plane3DCoordinateSubsystem xyPlaneSubsystem = Plane3D.xyPlane.getCoordinateSubsystem();

    public static List<ILocated> findShortestPathCrossings(ILocated leadIn, List<NavMeshBoundary> boundaries, ILocated leadOut) {
        ArrayList crossings = Lists.newArrayList();
        if (boundaries.isEmpty()) {
            return crossings;
        }
        FunnelDebug.debugFunnel_DrawInit(leadIn, boundaries, leadOut);
        Funnel gatewayFunnel = Funnel.createFromBoundary(leadIn, boundaries.get(0), 0);
        FunnelDebug.debugFunnel_drawGateway(gatewayFunnel);
        int index = 1;
        while (index < boundaries.size()) {
            block19: {
                Funnel newGatewayFunnel = Funnel.createFromBoundary(gatewayFunnel.getVantagePoint(), boundaries.get(index), index);
                FunnelRay newLeftRay = newGatewayFunnel.getLeftRay();
                FunnelRay newRightRay = newGatewayFunnel.getRightRay();
                FunnelDebug.debugFunnel_NextStep(gatewayFunnel, newGatewayFunnel, leadIn, boundaries, leadOut, crossings);
                FunnelZone newLeftRayZone = gatewayFunnel.determineZone(newLeftRay.getCrossing().getLocation().asPoint3D());
                switch (newLeftRayZone) {
                    case INSIDE: {
                        gatewayFunnel = new Funnel(newLeftRay, gatewayFunnel.getRightRay());
                        break;
                    }
                    case OUTSIDE_LEFT: {
                        break;
                    }
                    case OUTSIDE_RIGHT: {
                        Location crossing = gatewayFunnel.getRightRay().getCrossing();
                        crossings.add(crossing);
                        FunnelDebug.debugFunnel_NewCrossing(crossing);
                        index = gatewayFunnel.getRightRay().getIndex() + 1;
                        while (index < boundaries.size() && (crossing.equals((Object)boundaries.get(index).getSourceVertex()) || crossing.equals((Object)boundaries.get(index).getDestinationVertex()))) {
                            ++index;
                        }
                        if (index >= boundaries.size()) break;
                        gatewayFunnel = Funnel.createFromBoundary((ILocated)crossing, boundaries.get(index), index);
                        break block19;
                    }
                    default: {
                        throw new AssertionError((Object)"Unrecognized FunnelZone.");
                    }
                }
                FunnelZone newRightRayZone = gatewayFunnel.determineZone(newRightRay.getCrossing().getLocation().asPoint3D());
                switch (newRightRayZone) {
                    case INSIDE: {
                        gatewayFunnel = new Funnel(gatewayFunnel.getLeftRay(), newRightRay);
                        break;
                    }
                    case OUTSIDE_LEFT: {
                        Location crossing = gatewayFunnel.getLeftRay().getCrossing();
                        FunnelDebug.debugFunnel_NewCrossing(crossing);
                        crossings.add(crossing);
                        index = gatewayFunnel.getLeftRay().getIndex() + 1;
                        while (index < boundaries.size() && (crossing.equals((Object)boundaries.get(index).getSourceVertex()) || crossing.equals((Object)boundaries.get(index).getDestinationVertex()))) {
                            ++index;
                        }
                        if (index >= boundaries.size()) break;
                        gatewayFunnel = Funnel.createFromBoundary((ILocated)crossing, boundaries.get(index), index);
                        break;
                    }
                    case OUTSIDE_RIGHT: {
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"Unrecognized FunnelZone.");
                    }
                }
            }
            ++index;
        }
        switch (gatewayFunnel.determineZone(leadOut.getLocation().asPoint3D())) {
            case OUTSIDE_LEFT: {
                FunnelDebug.debugFunnel_NewCrossing(gatewayFunnel.getLeftRay().getCrossing());
                crossings.add(gatewayFunnel.getLeftRay().getCrossing());
                break;
            }
            case OUTSIDE_RIGHT: {
                FunnelDebug.debugFunnel_NewCrossing(gatewayFunnel.getRightRay().getCrossing());
                crossings.add(gatewayFunnel.getRightRay().getCrossing());
                break;
            }
            case INSIDE: {
                break;
            }
            default: {
                throw new AssertionError((Object)"Unrecognized FunnelZone.");
            }
        }
        return crossings;
    }
}

