/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.analysis.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.analysis.internal.NavMeshBoundaryInfo;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.analysis.internal.PolygonAnalysis;
import java.util.ArrayList;
import java.util.HashMap;

public class LineSegmentAnalysis {
    protected HashMap<Integer, HashMap<Integer, Integer>> vertexIncidenceMatrix = Maps.newHashMap();
    protected HashMap<Integer, PolygonInfo> polygonIdToInfoMap = Maps.newHashMap();
    protected HashMap<Integer, VertexInfo> vertexIdToInfoMap = Maps.newHashMap();

    public LineSegmentAnalysis(PolygonAnalysis polygonAnalysis) {
        HashMap lineSegmentToEdgeInfoMap = Maps.newHashMap();
        HashMap lineSegmentToBoundaryMap = Maps.newHashMap();
        for (int polygonId : polygonAnalysis.allPolygonIds) {
            this.getPolygonInfo(polygonId);
            PolygonAnalysis.PolygonInfo polygonInfo = polygonAnalysis.polygonIdToInfoMap.get(polygonId);
            ArrayList<Integer> vertexIds = polygonInfo.vertexIds;
            int vertexIndex = 0;
            while (vertexIndex < vertexIds.size()) {
                int vertexIdA = vertexIds.get(vertexIndex);
                int vertexIdB = vertexIds.get((vertexIndex + 1) % vertexIds.size());
                int edgeIndex = vertexIndex;
                this.getVertexInfo((int)vertexIdA).edgeIds.add(polygonInfo.edgeIds.get(edgeIndex));
                this.getVertexInfo((int)vertexIdB).edgeIds.add(polygonInfo.edgeIds.get(edgeIndex));
                this.incrementIncidency(vertexIdA, vertexIdB);
                LineSegment lineSegment = vertexIdA < vertexIdB ? new LineSegment(vertexIdA, vertexIdB) : new LineSegment(vertexIdB, vertexIdA);
                PolygonEdgeInfo curEdgeInfo = new PolygonEdgeInfo(polygonId, edgeIndex);
                if (lineSegmentToEdgeInfoMap.containsKey(lineSegment)) {
                    assert (!lineSegmentToBoundaryMap.containsKey(lineSegment)) : "Edge shared by three poligons.";
                    PolygonEdgeInfo adjEdgeInfo = (PolygonEdgeInfo)lineSegmentToEdgeInfoMap.get(lineSegment);
                    NavMeshBoundaryInfo boundary = new NavMeshBoundaryInfo(vertexIdA, vertexIdB, curEdgeInfo.polygonId, curEdgeInfo.edgeIndex, adjEdgeInfo.polygonId, adjEdgeInfo.edgeIndex);
                    lineSegmentToBoundaryMap.put(lineSegment, boundary);
                    this.getPolygonInfo((int)curEdgeInfo.polygonId).adjPolygonIdToBoundaryInfoMap.put(adjEdgeInfo.polygonId, boundary);
                    this.getPolygonInfo((int)adjEdgeInfo.polygonId).adjPolygonIdToBoundaryInfoMap.put(curEdgeInfo.polygonId, boundary);
                    this.getPolygonInfo((int)curEdgeInfo.polygonId).edgeIndexToBoundaryInfoMap.put(curEdgeInfo.edgeIndex, boundary);
                    this.getPolygonInfo((int)adjEdgeInfo.polygonId).edgeIndexToBoundaryInfoMap.put(adjEdgeInfo.edgeIndex, boundary);
                } else {
                    lineSegmentToEdgeInfoMap.put(lineSegment, curEdgeInfo);
                }
                ++vertexIndex;
            }
        }
        for (Integer vertexId : polygonAnalysis.allVertexIds) {
            this.vertexIdToInfoMap.put(vertexId, new VertexInfo());
        }
        block3: for (Integer vertexId : polygonAnalysis.allVertexIds) {
            for (Integer incidenceCount : this.getIncidence(vertexId).values()) {
                assert (incidenceCount >= 0 && incidenceCount <= 2);
                if (incidenceCount != 1) continue;
                this.getVertexInfo((int)vertexId.intValue()).isOnWalkableAreaEdge = true;
                continue block3;
            }
        }
    }

    public Integer getIncidency(int vertexAId, int vertexBId) {
        HashMap<Integer, Integer> incidencyOfA = this.getIncidence(vertexAId);
        if (!incidencyOfA.containsKey(vertexBId)) {
            return 0;
        }
        return incidencyOfA.get(vertexBId);
    }

    protected void incrementIncidency(int vertexIdA, int vertexIdB) {
        int previousIncidency = this.getIncidency(vertexIdA, vertexIdB);
        this.getIncidence(vertexIdA).put(vertexIdB, previousIncidency + 1);
        this.getIncidence(vertexIdB).put(vertexIdA, previousIncidency + 1);
    }

    public HashMap<Integer, Integer> getIncidence(int vertexId) {
        if (!this.vertexIncidenceMatrix.containsKey(vertexId)) {
            this.vertexIncidenceMatrix.put(vertexId, new HashMap());
        }
        return this.vertexIncidenceMatrix.get(vertexId);
    }

    public PolygonInfo getPolygonInfo(int polygonId) {
        if (!this.polygonIdToInfoMap.containsKey(polygonId)) {
            this.polygonIdToInfoMap.put(polygonId, new PolygonInfo());
        }
        return this.polygonIdToInfoMap.get(polygonId);
    }

    public VertexInfo getVertexInfo(int vertexId) {
        if (!this.vertexIdToInfoMap.containsKey(vertexId)) {
            this.vertexIdToInfoMap.put(vertexId, new VertexInfo());
        }
        return this.vertexIdToInfoMap.get(vertexId);
    }

    protected static class LineSegment {
        protected int vertexAId;
        protected int vertexBId;

        public LineSegment(int vertexAId, int vertexBId) {
            this.vertexAId = vertexAId;
            this.vertexBId = vertexBId;
        }

        public int getVertexAId() {
            return this.vertexAId;
        }

        public int getVertexBId() {
            return this.vertexBId;
        }

        public int hashCode() {
            return this.vertexAId + 2 * this.vertexBId;
        }

        public boolean equals(Object other) {
            if (other instanceof LineSegment) {
                LineSegment otherLineSegment = (LineSegment)other;
                return this.vertexAId == otherLineSegment.vertexAId && this.vertexBId == otherLineSegment.vertexBId;
            }
            return false;
        }
    }

    protected static class PolygonEdgeInfo {
        public int polygonId;
        public int edgeIndex;

        public PolygonEdgeInfo(int polygonId, int edgeIndex) {
            this.polygonId = polygonId;
            this.edgeIndex = edgeIndex;
        }
    }

    public static class PolygonInfo {
        public HashMap<Integer, NavMeshBoundaryInfo> edgeIndexToBoundaryInfoMap = Maps.newHashMap();
        public HashMap<Integer, NavMeshBoundaryInfo> adjPolygonIdToBoundaryInfoMap = Maps.newHashMap();
    }

    public static class VertexInfo {
        public boolean isOnWalkableAreaEdge = false;
        public ArrayList<Integer> edgeIds = Lists.newArrayList();
    }
}

