/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.unreal.communication.messages.UnrealId;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.analysis.NavMeshAnalysis;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.file.RawNavMeshFile;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.INavMeshAtom;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshPolygon;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.NavMeshVertex;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.OffMeshPoint;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.node.internal.NavMeshNavGraphGlue;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.NavPoint;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import math.bsp.IConstBspTree;
import math.geom2d.line.StraightLine2D;

public class NavMesh
implements Serializable {
    public static String pureMeshReadDir = "navmesh";
    public static String processedMeshDir = "navmesh";
    private static final long serialVersionUID = 1L;
    protected transient Logger log;
    protected NavMeshNavGraphGlue navGraphGlue = null;
    protected Set<NavMeshVertex> vertices = null;
    protected Set<NavMeshPolygon> polygons = null;
    protected Set<OffMeshPoint> offMeshPoints = null;
    protected Set<INavMeshAtom> atoms = null;
    protected transient HashMap<NavPoint, OffMeshPoint> navPointToOffMeshPointMap = null;
    protected IConstBspTree<ArrayList<NavMeshPolygon>, StraightLine2D> xyProjectionBsp = null;

    public NavMesh(Logger log) {
        this.log = log;
        if (this.log == null) {
            this.log = new LogCategory("NavMesh");
        }
    }

    public void setLog(Logger log) {
        this.log = log;
    }

    public boolean isLoaded() {
        return this.polygons != null;
    }

    public Set<NavMeshPolygon> getPolygons() {
        return Collections.unmodifiableSet(this.polygons);
    }

    public Set<NavMeshVertex> getVertices() {
        return Collections.unmodifiableSet(this.vertices);
    }

    public Set<OffMeshPoint> getOffMeshPoints() {
        return Collections.unmodifiableSet(this.offMeshPoints);
    }

    public Set<INavMeshAtom> getAtoms() {
        return Collections.unmodifiableSet(this.atoms);
    }

    public OffMeshPoint getOffMeshPointsByNavPoint(NavPoint navPoint) {
        return this.getNavPointToOffMeshPointMap().get(navPoint.getId());
    }

    public IConstBspTree<ArrayList<NavMeshPolygon>, StraightLine2D> getXyProjectionBsp() {
        return this.xyProjectionBsp;
    }

    protected HashMap<NavPoint, OffMeshPoint> getNavPointToOffMeshPointMap() {
        if (this.navPointToOffMeshPointMap == null) {
            this.navPointToOffMeshPointMap = Maps.newHashMap();
            for (OffMeshPoint offMeshPoint : this.offMeshPoints) {
                this.navPointToOffMeshPointMap.put(offMeshPoint.getNavPoint(), offMeshPoint);
            }
        }
        return this.navPointToOffMeshPointMap;
    }

    protected void setNavGraph(Function<UnrealId, NavPoint> navGraphView) {
        this.navGraphGlue.setNavGraph(navGraphView);
    }

    protected void load(Map<UnrealId, NavPoint> navGraph, String mapName) throws IOException {
        String rawNavMeshFileName = String.valueOf(pureMeshReadDir) + "/" + mapName + ".navmesh";
        RawNavMeshFile rawNavMeshFile = new RawNavMeshFile(new File(rawNavMeshFileName));
        NavMeshAnalysis navMeshAnalysis = new NavMeshAnalysis(rawNavMeshFile, navGraph, this.log);
        this.navGraphGlue = navMeshAnalysis.getNavGraphGlue();
        this.vertices = navMeshAnalysis.getVertices();
        this.polygons = navMeshAnalysis.getPolygons();
        this.offMeshPoints = navMeshAnalysis.getOffMeshPoints();
        this.atoms = new HashSet<INavMeshAtom>();
        this.atoms.addAll(this.polygons);
        this.atoms.addAll(this.offMeshPoints);
        this.xyProjectionBsp = navMeshAnalysis.getXyProjectionBsp();
    }

    protected void copyFrom(NavMesh navMesh) {
        this.navGraphGlue = navMesh.navGraphGlue;
        this.vertices = new HashSet<NavMeshVertex>(navMesh.vertices);
        this.polygons = new HashSet<NavMeshPolygon>(navMesh.polygons);
        this.offMeshPoints = new HashSet<OffMeshPoint>(navMesh.offMeshPoints);
        this.atoms = new HashSet<INavMeshAtom>(navMesh.atoms);
        this.navPointToOffMeshPointMap = navMesh.navPointToOffMeshPointMap != null ? new HashMap<NavPoint, OffMeshPoint>(navMesh.navPointToOffMeshPointMap) : null;
        this.xyProjectionBsp = navMesh.xyProjectionBsp;
    }

    protected void clear() {
        this.log.warning("NavMesh has been cleared...");
        this.navGraphGlue = null;
        this.vertices = null;
        this.polygons = null;
        this.offMeshPoints = null;
        this.atoms = null;
        this.navPointToOffMeshPointMap = null;
        this.xyProjectionBsp = null;
    }
}

