/*
 * Decompiled with CFR 0.152.
 */
package cz.cuni.amis.pogamut.ut2004.agent.navigation.levelGeometry;

import cz.cuni.amis.pogamut.base.communication.worldview.IWorldView;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEvent;
import cz.cuni.amis.pogamut.base.communication.worldview.object.IWorldObjectEventListener;
import cz.cuni.amis.pogamut.base.communication.worldview.object.event.WorldObjectFirstEncounteredEvent;
import cz.cuni.amis.pogamut.base.utils.logging.IAgentLogger;
import cz.cuni.amis.pogamut.base.utils.logging.LogCategory;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.levelGeometry.LevelGeometry;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.levelGeometry.LevelGeometryCache;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing.IUT2004ServerProvider;
import cz.cuni.amis.pogamut.ut2004.agent.navigation.navmesh.drawing.LevelGeometryDraw;
import cz.cuni.amis.pogamut.ut2004.communication.messages.gbinfomessages.GameInfo;
import java.util.logging.Logger;

public class LevelGeometryModule {
    private Logger log;
    protected boolean autoLoad = true;
    private boolean loaded = false;
    private String loadedForMap = null;
    private LevelGeometry levelGeometry;
    private LevelGeometryDraw draw;
    private IWorldObjectEventListener<GameInfo, IWorldObjectEvent<GameInfo>> gameInfoListener = new IWorldObjectEventListener<GameInfo, IWorldObjectEvent<GameInfo>>(){

        public void notify(IWorldObjectEvent<GameInfo> event) {
            LevelGeometryModule.this.autoLoad((GameInfo)event.getObject());
        }
    };

    public LevelGeometryModule(IUT2004ServerProvider serverProvider, IWorldView worldView, IAgentLogger logger) {
        this.log = logger == null ? new LogCategory("LevelGeometry") : logger.getCategory("LevelGeometry");
        worldView.addObjectListener(GameInfo.class, WorldObjectFirstEncounteredEvent.class, this.gameInfoListener);
        GameInfo info = (GameInfo)worldView.getSingle(GameInfo.class);
        if (info != null) {
            this.autoLoad(info);
        }
        this.draw = new LevelGeometryDraw(null, this.log, serverProvider);
    }

    public void setAutoLoad(boolean autoLoad) {
        this.autoLoad = autoLoad;
    }

    private void clear() {
        this.log.warning("LevelGeometry has been cleared...");
        this.levelGeometry = null;
        this.loaded = false;
        this.loadedForMap = null;
    }

    private boolean loadLevelGeometry(String mapName) {
        this.levelGeometry = LevelGeometryCache.getLevelGeometry(mapName);
        if (this.levelGeometry == null) {
            this.log.warning("COULD NOT INITIALIZE FOR MAP: " + mapName);
            return false;
        }
        this.log.info("INITIALIZED FOR MAP: " + mapName);
        return true;
    }

    private void autoLoad(GameInfo info) {
        if (!this.autoLoad) {
            this.log.warning("Auto-loading of the module is disabled...");
            return;
        }
        if (info == null) {
            this.log.severe("Could not load for 'null' GameInfo!");
            return;
        }
        String mapName = info.getLevel();
        this.load(mapName);
    }

    public void load(String mapName) {
        if (this.loaded) {
            if (this.loadedForMap == null) {
                this.clear();
            } else if (this.loadedForMap.equals(mapName)) {
                return;
            }
        }
        this.log.warning("Initializing LevelGeometry for: " + mapName);
        if (this.loadLevelGeometry(mapName)) {
            this.draw.setLevelGeometry(this.levelGeometry);
            this.loaded = true;
            this.loadedForMap = mapName;
            return;
        }
        this.loaded = false;
        this.loadedForMap = null;
    }

    public boolean isInitialized() {
        return this.levelGeometry != null && this.levelGeometry.isLoaded();
    }

    public LevelGeometry getLevelGeometry() {
        return this.levelGeometry;
    }

    public LevelGeometryDraw getDraw() {
        return this.draw;
    }
}

